/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * StripUtilDisplay.h: Displays utilizations on multiple strip charts
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/StripUtilDisplay.h,v 1.8 1994/02/25 04:31:45 aydt Exp $
 */

#ifndef StripUtilDisplay_h
#define	StripUtilDisplay_h

#include <X11/Intrinsic.h>
#include "UtilDisplay.h"

extern "C" {
#include "Gantt.h"
}


// define some constants used for array dimensions
// g++ allows 'const int' to do this, but CC does not.

#define	GANTT_WINDOW_SIZE	50

class StripUtilDisplay : public UtilDisplay {
/*
 * StripUtilDisplay displays utilizations 
 * on array of strip charts.
 */

private:


	int	x[GANTT_WINDOW_SIZE];		// x values of Gantt chart
	int	(*y)[GANTT_WINDOW_SIZE];	// y values of Gantt chart
	int	ay[numAggregates][GANTT_WINDOW_SIZE];	// aggregate y values


	/* Method _handleResize:	Manages UtilDisplay
	 *				dialog resizing			*/
	virtual void _handleResize( Widget w );


	/* Method _handleSelection:		Actual callback for handling
	 *					of select callback	*/
	void	_handleSelection( Widget w );

public:

	/* Method StripUtilDisplay:	The class constructor.
	 *				A new StripUtilDisplay is
	 *				set using the given name, with
	 *				FU parent ufu, and X widget
	 *				parent par			*/
	StripUtilDisplay( char *name, UtilFU *ufu, Widget par );


	/* Method ~StripUtilDisplay:	The class destructor.		*/
	virtual ~StripUtilDisplay( void );


	/* Method changeValue:		Update the utilization value 
	 *				for PE number proc to util	*/
	virtual void    changeValue( int proc, float util );


	/* Method createPerfSetup:	Creates a single setup for utilization
	 *				shown on a strip performance
	 *				widget				*/
	virtual Widget  createPerfSetup( const char *label );


	/* Method getType:		Returns a character string describing
	 *				the type of this UtilDisplay	*/
	virtual const char * const getType( void ) const;


	/* Method selectCB:		Callback for handling XtNselect
	 *				callbacks consistently with the
	 *				other UtilDisplays		*/
	static	void selectCB( Widget w, StripUtilDisplay *disp, XtPointer cd );


	/* Method updatePerfWidgets:	Modifies the existing UtilDisplay
	 *				dialog to show the updated list
	 *				of individual selections or
	 *				aggregates			*/
	virtual void    updatePerfWidgets( void );


};

#endif StripUtilDisplay_h
