/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 *
*/
/*
 * SquareErrorCluster.h: Performance square error partitional clustering
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/SquareErrorCluster.h,v 1.4 1994/02/25 04:31:29 aydt Exp $
 */

#ifndef SquareErrorCluster_h
#define SquareErrorCluster_h

#include "Obj.h"
#include "PartitionalCluster.h"

#define NONEXISTENT_POINT   -1

typedef enum { ICP_RANDOM, ICP_SINGLE_INTERVAL } InitialClusterPolicy;
typedef enum { MP_CASE_CLOSEST, MP_CASE_MAXREDUCE } MigrationPolicy;


class SquareErrorCluster : public PartitionalCluster {
/*
 * SquareErrorCluster is a direct subclass of PartitionalCluster.  It
 * allows for implementation of square error clustering algorithms
 *
*/

private:
       InitialClusterPolicy initialClusterPolicy;
       MigrationPolicy migrationPolicy;
       double *clusterCentroids;
       int *clusterCounts;
       double *squareErrors;
	
protected:

public:
       /* Method SquareErrorCluster:     The SquareErrorCluster constructor */
       SquareErrorCluster();

       /* Method ~SquareErrorCluster:    The SquareErrorCluster destructor */
       ~SquareErrorCluster();

       /* Method _allocateDataStructures:  Allocate cluster-specific   
                                            data structures */
       void _allocateDataStructures();

       /* Method _computeClusterCentroid: Compute the cluster mean
	      (centroid) for a given cluster */
       void _computeClusterCentroid( int whichCluster );

       /* Method _computeDistanceToCentroid:  Compute Euclidean
              distance from a given data point to a given cluster centroid */
       double _computeDistanceToCentroid( int point, int centroid );
 
       /* Method _computeSquareError: Compute the current value for
              square-error for one specific cluster or for all clusters */
       double _computeSquareError();
       double _computeSquareError( int whichCluster );

       /* Method _initialClusterRandomPolicy: Use the random policy
                                         for computing initial clusters */
       void _initialClusterRandomPolicy();

       /* Method _migratePoints: Move points from cluster-to-cluster
	                            according to the given policy */
       Boolean_ _migratePoints();

       /* Method _migrationCaseClosestPolicy: Migrate points   
            one-by-one according to which centroid they are closest to */
       Boolean_ _migrationCaseClosestPolicy();

       /* Method _migrationMaxReductionPolicy: Migrate points one-by-one
	    according to which point most reduces the square error at a
	    given step */
       Boolean_ _migrationMaxReductionPolicy();

       /* Method cluster:  Perform square-error cluster analysis */
       virtual void cluster();

       /* Method getClusterReps: Determine representative elements for
	             each cluster found */
       void getClusterReps( int *repList );

       /* Method setInitialClusterPolicy:  Define the policy used to
	             select initial clusters in the square-error algorithm */
       void setInitialClusterPolicy( InitialClusterPolicy policy );
	
       /* Method setMigrationPolicy: Define the policy whereby points
	             will move from cluster-to-cluster after the initial
	             configuration */
       void setMigrationPolicy( MigrationPolicy policy );
};

inline void
SquareErrorCluster::setInitialClusterPolicy( InitialClusterPolicy policy )
{
     initialClusterPolicy = policy;
}


inline void
SquareErrorCluster::setMigrationPolicy( MigrationPolicy policy )
{
     migrationPolicy = policy;
}

#endif  
