/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Tara Madhyastha (tara@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * SoundFunctionalUnit.h: Implements a sound functional unit (FU)
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/SoundFunctionalUnit.h,v 1.18 1994/03/15 16:26:15 aydt Exp $
 *	
 */


#ifndef SoundFunctionalUnit_h
#define SoundFunctionalUnit_h


#include "FunctionalUnit.h"
#include "Array.h"
#include "SonicWidgetCreator.h"


class SoundFunctionalUnit : public FunctionalUnit {
/*
 *  SoundFunctionalUnit is the base class for sound functional units.
 */
private:
        static const char *const MY_CLASS;      // My class name

protected:
	/* Method arrayToDoubleVector:  Convert an array to a C++ vector of
         *                              double values, to be passed to other
         *                              routines                           */
	double* arrayToDoubleVector(Array *a, int &nx);

	/* Method getDefaultWCFdir:   Get home for widget control files from
         *                            WCF_DIR enviroment variable */
	void getDefaultWCFdir(CString& wcfdir);

	/* Method getWidgetControlFile: Prompt for sound widget control file */
	char* getWidgetControlFile(char *title, char *basename = "");

	/* Method getWCFFileName: Get the name of the appropriate sound    *
	 *                        widget control file (based on the class) *
	 *                        of the sound functional unit             */
	char* getWCFFileName();

	InputPort	*input;

	SonicWidgetCreator widgetReader;

	BaseSonicWidget *mySonicWidget;

	Boolean_ isReady;

	int blockingFlag;

public:

        /* Method SoundFunctionalUnit: The SoundFunctionalUnit constructor. */
        /* Method ~SoundFunctionalUnit: The SoundFunctionalUnit destructor. */
	SoundFunctionalUnit();
	~SoundFunctionalUnit();

 	/* Method configure:    Configure the functional unit           */
        virtual void configure();

	/* Method copy:			Create a copy of the FU   	*/   
	virtual FunctionalUnit * copy();
	
	/* Method init:		Initialize the sound FU     	*/
	virtual void init();

	/* Method loadConfigFromFile:   Load configuration from a file  */
	virtual Boolean_ loadConfigFromFile( const CString & fileName );


	/* Method ready: 	Returns TRUE_ if the sound FU
	*			is currently executable			*/
	virtual Boolean_ ready();

	/* Method run:		Execute the sound FU    		*/
	virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:     Save configuration to a file   */
        virtual Boolean_ saveConfigToFile( const CString & fileName )  const ;

	/* Method printOn: Stream output function */
	virtual void printOn(ostream &os = cout) const;
};

inline ostream &operator<<(ostream &os, SoundFunctionalUnit &obj)
{
	obj.printOn(os);
	return os;
}

#endif
