/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * Selection.h: Definition of the Selection class, used to specify ranges
 * which are selected by NumberLine and UtilDisplay objects.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/Selection.h,v 1.9 1994/02/25 04:31:44 aydt Exp $
 */

#ifndef	Selection_h
#define Selection_h

#include <fstream.h>
#include <stdio.h>
#include "Defines.h"
#include "ListNode.h"

/*
 * class Selection:  class declaration for objects representing Lists of
 * selected subranges out of a range.
 */
class Selection : public ListNode {
/*
 * Selection specifies ranges of data for use by other data
 * selection and display functions (e.g., to choose a subset
 * of the elements on a number line).
*/

private:
	int	lo, hi;			// the range represented by this node

	

	/* Method _insertHere:		Indicate where to 
	*				insert "this."  Returns TRUE_ if
	*				this should be inserted before
	*				its argument, FALSE_ otherwise.	*/
	virtual Boolean_ _insertHere( ListNode * );


	/* Method _makeCanonical:	Puts its argument in 
	*				a canonical form, where ranges
	*				apprear in increasing order in 
	*				the list, and no ranges overlap. */
	Selection * _makeCanonical( Selection * );


public:
        /* Method Selection:            The class constructor.		*/  
	Selection( void );

        /* Method Selection:            The class constructor.  
        *                               The one argument version creates
        *                               a "point" selection.            */
	Selection( int );

        /* Method Selection:            The class constructor.  
        *                               The two argument version creates
        *                               a "range" selection.            */
	Selection( int, int );
	

	/* Method insertYourself:	Inserts "this" into the
	*				given List at its correct location
	*				( as indicated by _insertHere() ).
	*				Returns the resulting List.	*/
	virtual ListNode * insertYourself( ListNode * );


	/* Method copy:                 Duplicates the Selection * headed
	*                               by "this" and returns the resulting
	*                               list.  The duplicate and the original
	*                               share no memory.                */
	Selection * copy( void );

	
	/* Method getPoint:		Retrieves the value
	*				which a "point" selection represents.
	*				Guaranteed to work correctly only
	*				for Selections which are actually
	*				points ( see isPoint, below ). 	*/
	void getPoint( int& );


	/* Method getRange:		Retrieves the high and low
	*				ends of the range which a "range"
	*				selection represents.		*/
	void getRange( int&, int& );
	

	/* Method intersectYourself:	Intersects "this" with
	*				the Selection argument.  Returns
	*				the resulting Selection *.	*/
	Selection * intersectYourself( Selection* );


	/* Method isPoint:		Predicate returning TRUE_
	*				if this represents a "point"
	*				selection, FALSE_ otherwise.	*/
	Boolean_ isPoint( void );


	/* Method removePoint:		Removes the point
	*				represented by its argument from the
	*				Selection * headed by this. 
	*				Returns the resulting list.	*/
	Selection * removePoint( int );


	/* Method removeRange:		Removes the range
	*				represented by its arguments from the
	*				Selection * headed by this.
	*				Returns the resulting list.	*/
	Selection * removeRange( int, int );


	/* Method setPoint:		Sets "this"s selection
	*				to the given point.		*/
	void setPoint( int );


	/* Method setRange:		Set "this"s selection
	*				to the given range.		*/
	void setRange( int, int );


	/* Method unionYourself:	Form the union of "this"
	*				and the given Selection
	*				argument.  Returns the resulting
	*				Selection *.			*/
	Selection * unionYourself( Selection* );


	/* Method printOn:		Outputs the representation
	*				of "this"s selection range to the
	*				given stream.			*/
	void printOn( ostream& );

	/* Method printList:		Print its argument
	*				Selection * on the given stream.
	*				Outputs Selection * in a
	*				delimited, standard form.	*/
	static void printList( ostream&, Selection * );

	/* Method readSelectionList:	Read a Selection * from
	*				the given stream.		*/
	static Selection * readSelectionList( FILE* );
};

#endif Selection_h
