/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ScatterPlotMatrixFU.h: Implements a two-dimensional array of scatterplots
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ScatterPlotMatrixFU.h,v 1.7 1994/03/15 16:26:10 aydt Exp $
 */

#ifndef ScatterPlotMatrixFU_h
#define ScatterPlotMatrixFU_h

#include "Callback.h"
#include "EventHandler.h"
#include "Value.h"
#include "IntList.h"
#include "MultivariateFunctionalUnit.h"
#include "SquareErrorClusterVariable.h"

class ScatterPlotMatrixFormWrapper;
class InputPort;
class WidgetBase;

enum SPMWidgetTypeEntry { XYGRAPH_ENTRY, MATRIX_ENTRY };

struct SPMConfigDataStruct {
      Widget dialog;
      Widget widgetOptionRadioBox;
      Widget totalDimension;
      Widget categoryNameToggle;
      Widget datasetNameWidget;
      Widget updateIntervalWidget;
      Widget inputOptionRadioBox;
} ;

struct SPMConfigPerDimDataStruct {
      Widget dialog;
      int    numParams;
      Widget *scrolledLists, *editAreas;
} ;

struct Callback1DTextWidgetSet {
      Widget headerWidget;
      Widget minimumTextWidget;
      Widget smallestTextWidget;
      Widget largestTextWidget;
      Widget medianTextWidget;
      Widget Q1valueTextWidget;
      Widget Q3valueTextWidget;
      Widget maximumTextWidget;
} ;

enum SPMInteractionTags { SPM_TAG_PREPROCESSING, 
			  SPM_TAG_CLUSTERING, 
			  SPM_TAG_PREFERENCES } ;

struct SPMPreprocessOptions {
       int    numberOptions;           /* initialize to 3 before use */
       Widget *toggleOptions;
} ;


struct SPMClusteringOptions {
/*
       Widget numberOfClustersWidget;
       int numberOfClusters;          
       Widget writeClusterRepsWidget;
       Boolean writeClusterReps;      
*/
       Widget clusteringIntervalWidget;
       int clusteringInterval;
       Widget clusteringRadioBox1;
       Boolean clusteringEnabled;
} ;

struct SPMPreferenceOptions {
       int    numberOptions;
       Widget *toggleOptions;
} ;

struct SPMInteractionOptions {
       SPMInteractionTags tag;
       Widget             mainWindow;
       void               *specificData;
} ;

/*
typedef int SPMPreprocessingMask;
struct SPMPreprocessData {
       Boolean     isInitialized = False;
       DoubleList  ppMinValues, ppMaxValues;
       double      *mean, *variance, *stdDev;
       double      *sumOfX, *partialEX;
       int         partialCount;
} ;

 */

class ScatterPlotMatrixFU : public MultivariateFunctionalUnit,
                            public virtual Callback,
                            public virtual EventHandler {
/*
 *
 * A ScatterPlotMatrixFU is a functional unit that implements a dynamic
 * scatterplot matrix (i.e., a 2-D array of scatterplots).
 */
enum SPMportTypes { FULL_ARRAY, ARRAY_ELEMENT } ;

private:
       static const char *const MY_CLASS;	// My class name
       Boolean_           isConfigured;         // Has configure() been run

       SPMWidgetTypeEntry widgetType;    // Type of widget used in the matrix
       IntList              widgetRanges, widgetMinValues;
  
       ScatterPlotMatrixFormWrapper  *scatterPlotMatrixForm; 
       InputPort                     *inputPort; 
       OutputPort                    *outputPort;
       Value                         inputValue;    // Cells for incoming data
       Value                         outputValue;

       int 	           portOption;              // Input port config
       // XYGraph-specific data
       int             connectOption;

       SquareErrorClusterVariable   *cluster;


protected:
        /* Method _setupSPMPerCategoryDialog:  Build the set of widgets
	                    associated with the optional SPM config window */
        Widget _setupSPMPerCategoryDialog( int dimension );

        /* Method _setupSPMConfigWindow:  Build the set of widgets associated
	                                  with the SPM config window       */
        Widget _setupSPMConfigWindow();

public:
        /* Method ScatterPlotMatrixFU: The ScatterPlotMatrixFU constructor */
        ScatterPlotMatrixFU();

        /* Method ~ScatterPlotMatrixFU: The ScatterPlotMatrixFU destructor */
	~ScatterPlotMatrixFU();

        /* Method callback1:              Done-with-config window callback */
        virtual void callback1(Widget, XtPointer, XtPointer);

        /* Method callback5:            End-of-run processing           */
        virtual void callback5(Widget, XtPointer, XtPointer);

	/* Method configure:    	Configure the functional unit	*/
	virtual void configure();

        /* Method copy:			Create a copy of the FU   	*/
	virtual FunctionalUnit * copy();
 
        /* Method fuCallback1:          Display the univariate widget
	                                callback                        */
        void fuCallback1( Widget callbackWidget,
			  Widget callbackMainWindow, 
			  Callback1DTextWidgetSet textWidgetSet, int cbDim );

        /* Method fuCallback2:          Clustering callback             */
        void fuCallback2( int initialIndex, int clusterPoints );

        /* Method fuSubclassProcessPerCategoryCallback: Process the end-of
	    per-dimension data entry */
        void fuSubclassProcessPerCategoryCallback();

	/* Method init:			Initialize the matrix display	*/
	virtual void init();

        /* Method inputTraitsValid:    Sets traits of output port   */
        virtual Boolean_ inputTraitsValid();

	/* Method loadConfigFromFile:   Load configuration from a file  */
	virtual Boolean_ loadConfigFromFile( const CString & fileName );
 
	/* Method ready: 		Returns TRUE_ if the ScatterPlotMatrix
	*				display is currently executable */
	virtual Boolean_ ready();

	/* Method run:		Execute the ScatterPlotMatrix display */
	virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:     Save configuration to a file   */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;
};

#endif ScatterPlotMatrixFU_h
     
