/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * NumberLine.h: A number line display used to select items
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/NumberLine.h,v 1.9 1994/02/25 04:31:43 aydt Exp $
 */

#ifndef	NumberLine_h
#define	NumberLine_h


class Selection;

 // define constants for use in specifying array sizes
 // g++ allows 'const int' to do this, but CC doesn't

#define NUM_INFO_WIDGETS	2

class NumberLine {
/*
 * NumberLine allows the selection of subranges and individual points
 * on a number line.
 */

private:
	enum { DA, SBAR } ;	// constants for information 
	enum { RIGHT, LEFT } ;	// producing widgets

	static const int MARGIN; // visible layout constants
	static const int TICK;
	static const int LNWID;
	static const int ARROW;
	static const int MAX_DIGITS;
	static const int ARROW_GRAVITY;
	static const char* const NL_CHARSET;


	// data representing internal state of the NumberLine

	int minValue, maxValue;		// extent of the number line
	int minVisValue, maxVisValue;	// limits on visible range

	int minFocValue, maxFocValue;	// limits on focus range
	int oldMinFocValue, oldMaxFocValue;	// initial range, for drags
	int ptrVal;			// value of pointer, for drags
	int focDir;			// direction of focus arrow, for drags

	int rangeEnd;			// initial end of range value

	// mode flags

	Boolean pointFlag;		// flags point or range operations
					// change point mode
	Boolean	selectFlag;		// flags select or deselect mode
	Boolean	focFlag;		// flags drag of focus flag
	Boolean	rangeEndSet;		// flags range drag in progress

	// Selection variables

	int interval;			// interval between ticks and labels
	Selection *currSList;	// current list of selections


	// X/Motif variables

	Widget hierarchy;		// widget tree for numberline widgets
	Widget infoWidgets[NUM_INFO_WIDGETS];	// information-producing
						// widgets
	Dimension width, height;	// dimensions of DrawingArea
	Position yloc;			// y coord of horizontal line
	GC gc;				// graphics context for DrawingArea 
	Display	*dpy;			// Display for DrawingArea
	Window	wndw;			// window for DrawingArea
	XmFontList nlFontList;		// list of fonts containing nlFont
	XFontStruct *nlFont;		// font for labels on DrawingArea


	/* Method _goodInterval:	Computes a an "attractive"
	 *				interval for the currently
	 *				visible range			*/
	static int _goodInterval( int lo, int hi );
	

	/* Method _clearAllSelections:	Actual callback to clear the
	 *				current NumberLine selection
	 *				to empty			*/
	void _clearAllSelections( void );


	/* Method _clearPoint:		Actual callback to clear a point
	 *				from the current selection	*/
	void _clearPoint( void );


	/* Method _clearRange:		Actual callback to clear a range
	 *				from the current selection	*/
	void _clearRange( void );


	/* Method _dragFocusEnd:	Actual event handler to handle
	 *				dragging the focus end arrows	*/
	void _dragFocusEnd( XEvent* );


	/* Method _dragPoint:		Actual event handler to handle
	 *				dragging points on the line	*/
	void _dragPoint( XEvent* );


	/* Method _dragRange:		Actual event handler to handle
	 *				dragging ranges on the line	*/
	void _dragRange( XEvent* );


	/* Method _draw:		Draws the NumberLine on
	 *				its DrawingArea widget		*/
	void _draw( void );


	/* Method _drawArrow:			Draws a focus arrow at value val
	 *				and direction dir		*/
	void _drawArrow( int val , int dir );


	/* Method _drawCircle:		Draws a circle on the
	 *				DrawingArea at value val.  If
	 *				drawLabel is True, the value
	 *				label is drawn with the circle	*/
	void _drawCircle( int val, Boolean drawLabel );


	/* Method _drawRange:		Draws the highlighted range
	 *				[lo,hi] on the NumberLine	*/
	void _drawRange( int lo, int hi );


	/* Method _drawSelection:	Highlights the entire
	 *				current selection on the
	 *				NumberLine			*/
	void _drawSelection( void );


	/* Method _expand2x:		Actual callback for expanding the
	 *				focus area by a factor of 2	*/
	void _expand2x( void );


	/* Method _expandCompletely:	Actual callback for expanding the
	 *				focus area to its maximum size	*/
	void _expandCompletely( void );


	/* Method _handleButtonPress:	Actual callback for handling
	 *				X button press events		*/
	void _handleButtonPress( XEvent* );


	/* Method _handleButtonRelease:	Actual callback for handling
	 *				X button release events		*/
	void _handleButtonRelease( XEvent* );


	/* Method _handleExpose:	Actual callback for handling
	 *				X expose events			*/
	void _handleExpose( XmDrawingAreaCallbackStruct* );


	/* Method _handleMouse:		Actual callback for handling
	 *				any mouse actions such as clicking
	 *				or dragging in the DrawingArea.	*/
	void _handleMouse( XmDrawingAreaCallbackStruct* );


	/* Method _handleOneDown:	Actual callback for handling
	 *				incremental lowering of
	 *				ScrollBar value			*/
	void _handleOneDown( void );


	/* Method _handleOneUp:		Actual callback for handling
	 *				incremental raising of ScrollBar
	 *				value				*/
	void _handleOneUp( void );


	/* Method _handlePageDown:	Actual callback for handling
	 *				page lowering of ScrollBar value */
	void _handlePageDown( void );


	/* Method _handlePageUp:	Actual callback for handling
	 *				page raising of ScrollBar value	*/
	void _handlePageUp( void );


	/* Method _handleResize:	Actual callback for handling
	 *				X resize events			*/
	void _handleResize( void );


	/* Method _handleToBottom:	Actual callback for handling
	 *				lowering the ScrollBar value to
	 *				its minimum			*/
	void _handleToBottom( void );


	/* Method _handleToTop:		Actual callback for handling
	 *				raising the ScrollBar value to 
	 *				its maximum			*/
	void _handleToTop( void );


	/* Method _handleValueChanged:	Actual callback for handling
	 *				changes in the ScrollBar value	*/
	void _handleValueChanged( XmScrollBarCallbackStruct* );


	/* Method _logicalVal:		Converts DrawingArea 
	 *				x-coordinates to NumberLine
	 *				values				*/
	int _logicalVal( Position );


	/* Method _makeFocusArea:	Creates the NumberLine
	 *				focus area widget subtree	*/
	Widget	_makeFocusArea( Widget );


	/* Method _makeNumberLineWidgets: Creates the NumberLine
	 *				widget hierarchy		*/
	Widget	_makeNumberLineWidgets( Widget );


	/* Method _makeSelectionArea:	Creates the NumberLine
	 *				selection area widget subtree	*/
	Widget	_makeSelectionArea( Widget );


	/* Method _physicalVal:		Converts NumberLine values
	 *				to DrawingArea x-coordinates	*/
	Position _physicalVal( int );


	/* Method _refocus:		Actual callback for handling
	 *				changes in the NumberLine focus	*/
	void _refocus( void );


	/* Method _selectedFocArrow:	Predicate for determining
	 *				whether a focus arrow was
	 *				selected with a given mouse click */
	Boolean _selectedFocArrow( XEvent* );


	/* Method _selectedNumberLinePoint: Predicate for determining
	 *				if a point on the NumberLine
	 *				was chosen with a given mouse
	 *				click				*/
	Boolean _selectedNumberLinePoint( XEvent* );


	/* Method _setFocusEnd:		Finishs the drag of a
	 *				focus arrow			*/
	void _setFocusEnd( void );


	/* Method _setSelectPoint:	Finishes the drag of a 
	 *				point on the number line	*/
	void _setSelectPoint( void );


	/* Method _setSelectRange:	Finishes the drag of a
	 *				range on the number line	*/
	void _setSelectRange( void );


	/* Method _startDraggingPoint:	Starts the drag of a 
	 *				point on the number line	*/
	void _startDraggingPoint( void );


	/* Method _startDraggingRange:	Starts the drag of a 
	 *				range on the number line	*/
	void _startDraggingRange( void );


	/* Method _startFocusEnd:	Starts the drag of a focus arrow */
	void _startFocusEnd( void );


	/* Method _switchSelectMode:	Actual callback for switching 
	 *				the NumberLine's select mode	*/
	void _switchSelectMode( void );


	/* Method _switchPointMode:	Actual callback for switching
	 *				the NumberLine's point mode	*/
	void _switchPointMode( void );


	/* Method _zoom2x:		Actual callback for zooming in
	 *				the focus of the NumberLine by
	 *				a factor of 2			*/
	void _zoom2x( void );



public:

	/* Method NumberLine:		Class constructor.
	 *				Argument par is the Motif widget
	 *				which is to be the parent of 
	 *				the NumberLine, and the range
	 *				[lo,hi] determines the NumberLine"s
	 *				range.				*/
	NumberLine( Widget par, int lo, int hi );
	

	/* ~NumberLine:			The class destructor		*/
	~NumberLine( void );
	

	/* Method createGC:		Creates an X graphics
	 *				context for drawing into the
	 *				NumberLine window		*/
	void createGC( void );


	/* Method getHierarchy:		Retrieves the NumberLine
	 *				X widget hierarchy		*/
	Widget getHierarchy( void );
	

	/* Method getSelection:		Retrieves the current
	 *				list representing the subranges
	 *				and points which are selected on
	 *				the NumberLine.			*/
	Selection * getSelection( void );


	/* Method setSelection:		Sets the NumberLine"s
	 *				currently selected subset.	*/
	void setSelection( Selection* );



	 // static member functions used as callbacks
	 // non-static member functions cannot be used as callbacks, so
	 // these static member functions are used as stubs to call
	 // private member functions which do the actual work.

	/* Method clearAllCB:		Callback for "Clear All" 
	 *				selection button		*/
	static void clearAllCB( Widget, NumberLine*, XtPointer );


	/* Method dragFocusEndEH:	Event Handler for dragging a
	 *				NumberLine focus arrow.		*/
	static void dragFocusEndEH( Widget, NumberLine*, XEvent* );


	/* Method dragPointEH:			Event Handler for dragging a 
	 *				point on the NumberLine.	*/
	static void dragPointEH( Widget, NumberLine*, XEvent* );


	/* Method dragRangeEH:		Event Handler for dragging a 
	 *				range on the NumberLine.	*/
	static void dragRangeEH( Widget, NumberLine*, XEvent* );


	/* Method expand2xCB:		Callback for "Expand 2x" focus
	 *				button.				*/
	static void expand2xCB( Widget, NumberLine*, XtPointer );


	/* Method expandCompleteCB:	Callback for "Expand Completely"
	 *				focus button			*/
	static void expandCompleteCB( Widget, NumberLine*, XtPointer );


	/* Method exposeCB:		Callback for expose events for
	 *				the NumberLine DrawingArea.	*/
	static void exposeCB( Widget, NumberLine*, 
					XmDrawingAreaCallbackStruct* );


	/* Method handleMouseCB:	Callback for handling mouse clicks
	 *				in the DrawingArea.		*/
	static void handleMouseCB( Widget, NumberLine*, 
					XmDrawingAreaCallbackStruct* );


	/* Method oneDownCB:		Callback for pressing the ScrollBar
	 *				incremental arrow down.		*/
	static void oneDownCB( Widget, NumberLine*, XtPointer );


	/* Method oneUpCB:		Callback for pressing the ScrollBar
	 *				incremental arrow up.		*/
	static void oneUpCB( Widget, NumberLine*, XtPointer );


	/* Method pageDownCB:		Callback for pressing in the
	 *				ScrollBar "page down" region	*/
	static void pageDownCB( Widget, NumberLine*, XtPointer );


	/* Method pageUpCB:		Callback for pressing in the
	 *				ScrollBar "page up" region	*/
	static void pageUpCB( Widget, NumberLine*, XtPointer );


	/* Method pointModeCB:		Callback for switching the
	 *				point mode from the selection
	 *				RadioBox			*/
	static void pointModeCB( Widget, NumberLine*, XtPointer );


	/* Method refocusCB:		Callback for handling refocus
	 *				events for the NumberLine
	 *				DrawingArea			*/
	static void refocusCB( Widget, NumberLine*, XtPointer );


	/* Method resizeCB:		Callback for handling resize
	 *				events for the NumberLine
	 *				DrawingArea			*/
	static void resizeCB( Widget, NumberLine*, XtPointer );


	/* Method selectModeCB:		Callbcak for switching teh
	 *				selection mode from the selection
	 *				RadioBox			*/
	static void selectModeCB( Widget, NumberLine*, XtPointer );


	/* Method toBottomCB:		Callback for moving the ScrollBar
	 *				thumb all the way to its min value */
	static void toBottomCB( Widget, NumberLine*, XtPointer );


	/* Method toTopCB:		Callback for moving the ScrollBar
	 *				thumb all the way to its max value */
	static void toTopCB( Widget, NumberLine*, XtPointer );


	/* Method valueChangedCB:	Callback for changing the value
	 *				of the NumberLine ScrollBar	*/
	static void valueChangedCB( Widget, NumberLine*, 
					XmScrollBarCallbackStruct * );


	/* Method zoom2xCB:		Callback for zooming the focus
	 *				of the NumberLine by a factor
	 *				of 2				*/
	static void zoom2xCB( Widget, NumberLine*, XtPointer );

};

inline
void
NumberLine::_switchSelectMode( void )
{
	selectFlag = ( selectFlag ? False : True );
}


inline
void
NumberLine::_switchPointMode( void )
{
	pointFlag = ( pointFlag ? False : True );
}



inline
Widget
NumberLine::getHierarchy( void )
{
	return hierarchy;
}

#endif NumberLine_h
