/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * FileInputWrapper.h: The class which handles reading SDDF input from files.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FileInputWrapper.h,v 1.19 1994/03/15 16:27:38 aydt Exp $
 *	
 */

#ifndef FileInputWrapper_h
#define FileInputWrapper_h

#include "PacketHeader.h"
#include "StructureDescriptorResolver.h"
#include "Wrapper.h"

class BargraphFormWrapper;
class InputFileStreamPipe;
class PipeReader;
class RecordDossier;
class WidgetBase;

static const int TAG_CACHE_SIZE = 256;

class FileInputWrapper : public Wrapper {
/*
 * This class is derived from Wrapper and handles the reading of input
 * from an SDDF file and writing the packets onto output pipes connected to
 * the module.
 */
private:
	static const char *const MY_CLASS;          // My class name
	static PacketHeader    noHeader;	    // "blank" packet header

	CString 	       filename;	    // file we are writing to
	InputFileStreamPipe    *inputPipeFromFile;  // input pipe
	PipeReader 	       *pipeReader;	    // reader we use
	PabloSddfType 	       inputType;	    // type of input file
	PacketHeader 	       currentHeader;	    // header of current pkt
	Boolean_ 	       dataPending;         // is data waiting?

        RecordDossier*         *dossierCache;       // cache of tag->dossier*

	StructureDescriptorResolver resolver;	    // To resolve our src/tag

	Boolean_	       reportBytesRead;	    // Show bargraph?
        WidgetBase             *dialog;		    // Form for bargraph
	WidgetBase	       *titleBar;           // Title for bargraph
        BargraphFormWrapper    *barGraphForm;       // Bargraph and labels

//	***** Private Methods Available only to the FileInputWrapper Class *****

	/* Method _processData:			Looks up system tag in 
	*				        TagMappingDict.  Reads data
	*					into appropriate dossier of
	*					outputDictionary.             */
	void _processData();

	/* Method _processDescriptor:		Looks up system tag in Tag
	*					Mapping Dictionary.  Adds new
	*					entry to output Dictionary.   */
	void _processDescriptor( StructureDescriptor &descr );

public:
//	***** Constructors and Destructors *****

        /* Method FileInputWrapper: 		The constructor. 	      */
	FileInputWrapper( const CString& fileName ) ;

        /* Method ~FileInputWrapper: 	        The destructor.	              */
	~FileInputWrapper();

//      ***** Virtual Functions *****

        /* Method addInputPipe:                 Input pipes not allowed - 
	*					always returns FAILURE_	      */
        virtual Boolean_ addInputPipe( StreamPipe *pipe, ModuleId *source );

	/* Method configure:			Asks filename & opens file.
	*				        Reads in Descriptors at head
	*					of file & passes them to output
	*					pipes. singleModule value makes
	*					no difference in behavior.    */
	virtual void configure( Boolean_ singleModule );

        /* Method getWrapperClass:              Returns the class of the
        *                                       Wrapper instance for which it
        *                                       is called.                    */
        virtual WrapperClass getWrapperClass() const {
                return FileInputWrapperClass;
                } ;

	/* Method init:				Initialize Wrapper state.     */
	virtual void init(); 

	/* Method loadConfigurationFromDir:	If we are showing bytes read,
	*					attempt to get position & size
	*					from saved file. This calls the
	*					configure() method.           */
	virtual Boolean_ loadConfigurationFromDir( const CString& dir,
						   int moduleIndex ); 

	/* Method ready:			Looks for next packet header
	*					on pipe and returns TRUE_ unless
	*					the pipe is empty.            */
	virtual	Boolean_ ready();

        /* Method restart:                      Closes and reopens the data file
        *                                       associated with the module.   */
        virtual void restart();

	/* Method run:				Handles copying packet from the
	*					file to the output pipe(s).
	*					errorFlag is set if an error
	*					is seen during while running. */
	virtual void run( Boolean_& errorFlag );

	/* Method saveConfigurationToDir:	If we are showing bytes read,
	*					save position & size.         */
	virtual Boolean_ saveConfigurationToDir( const CString& dir, 
						 int moduleIndex ) const; 

	/* Method writeLayoutToFP:		Write line for this module to
	*					Layout file.                  */
	virtual void writeLayoutToFP( FILE *fp ) const;

//      ***** Functions Defined for all Classes *****
	
	/* Method printOn: 			Stream output function */
	void printOn( ostream& os = cout ) const;
};

//      ***** General Operators *****

inline ostream& operator<<( ostream& os, FileInputWrapper& obj )
{
	obj.printOn( os );
	return os;
}

#endif
