/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * FUParams.h: Implements FUParams.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/FUParams.h,v 1.13 1994/03/08 00:41:45 aydt Exp $
 */

#ifndef FUParams_h
#define FUParams_h

#include "BaseFUParamEntry.h"
#include "BaseFUParamEntryPtrList.h"
#include "CString.h"
#include "CStringObjList.h"
#include "Obj.h"
#include "Value.h"

class FUParams : public Obj {
/*
 * FUParams manages functional unit parameters.
 */

protected:
	BaseFUParamEntryPtrList *list;

public:
        /* Method FUParams: The FUParams constructor. */
	FUParams();

        /* Method ~FUParams: The FUParams destructor. */
	~FUParams();

	/* Method addDisplayParam:	Takes the scalar Value and uses it's
	*				DataType to format appropriately for
	*				display in in a read-only Text Widget */
	void addDisplayParam( const CString &name, const Value& value );

	/* Method addDisplayParam:	Takes an integer and display it in
	*				a read-only text widget.              */
	void addDisplayParam( const CString &name, int intValue );

	/* Method addDisplayParam:	Takes a double and displays it in
	*				a read-only text widget.              */
	void addDisplayParam( const CString &name, double dblValue );

	/* Method addDisplayParam:	Takes a char* and displays it in
	*				a read-only text widget.              */
	void addDisplayParam( const CString &name, char *cstr );

	/* Method addDisplayParam:	Takes a const char* and displays it in
	*				a read-only text widget.              */
	void addDisplayParam( const CString &name, const char *cstr );

	/* Method addDisplayParam:	Takes a const CString& and displays 
	*				it in a read-only text widget.        */
	void addDisplayParam( const CString &name, const CString& cstr );


	/* Method addSliderParam:	Adds a slider parameter		*/
	void addSliderParam(const CString &name, 
			    const BaseFUParamEntry::FUParamType type,
			    const FUParamValue &value,
			    double lower, double upper);

	/* Method addTextParam:	Adds a text parameter			*/
	void addTextParam(const CString &name, 
			  const BaseFUParamEntry::FUParamType type,
			  const FUParamValue &value);

	/* Method addFileParam:	Adds a file selection parameter		*/
	void addFileParam( const CString &name, 
			   const BaseFUParamEntry::FUParamType type,
			   const FUParamValue &value,
			   const CString &mask );

	/* Method addRadioButtonsParam:	Adds a radio button parameter	*/
	void addRadioButtonsParam(const CString &name, 
			  	  const BaseFUParamEntry::FUParamType type,
				  const FUParamValue &value,
				  const CStringObjList &buttons);

	/* Method nParams:	Returns the number of parameters	*/
	int nParams() const { return list->count(); } ;

	/* Method getEntry:	Returns a particular parameter		*/
	BaseFUParamEntry & getEntry(int n) const {
		return *(list->getElement(n)); } ;

	/* Method getEntry:	Returns a particular parameter		*/
	BaseFUParamEntry & getEntry(const CString &name) const;

	/* Method getType:	Returns the type of the parameter	*/
	BaseFUParamEntry::FUParamType getType(const CString &name) const;

	/* Method getValue:	Returns the value of the requested 
	*			parameter				*/
	const FUParamValue & getValue(const CString &name) const;

	/* Method valueIsValid:	Returns TRUE if the parameter has a
	*			valid value				*/
	Boolean_ valueIsValid(const CString &name) const;

	/* Method getType:	Returns the type of the parameter	*/
	BaseFUParamEntry::FUParamType getType(int n) const;

	/* Method getValue:	Returns the value of the requested 
	*			parameter				*/
	const FUParamValue & getValue(int n) const;

	/* Method valueIsValid:	Returns TRUE if the parameter has a
	*			valid value				*/
	Boolean_ valueIsValid(int n) const;
		
};

#endif
