/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *               University of Illinois at Urbana-Champaign
 *               Department of Computer Science
 *               1304 W. Springfield Avenue
 *               Urbana, IL     61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *      All Rights Reserved.
 *
 * Author: Keith A. Shields (shields@cs.uiuc.edu)
 * 
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ConstantsDialog.h: Implements a dialog for input constant values
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/ConstantsDialog.h,v 1.10 1994/02/25 04:28:24 aydt Exp $
 */

#ifndef ConstantsDialog_h
#define ConstantsDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Form.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/Frame.h>  
#include <Xm/ScrolledW.h>
#include <Xm/RowColumn.h>
#include <Xm/Label.h>
#include <Xm/TextF.h>

#include "InterfaceClass.h"
#include "ConfigBoard.h"
#include "Callback.h"
#include "GeneralDialogBox.h"
#include "Pablo.h"
#include "Obj.h"

class ConstantsDialog : public Obj, public virtual Callback  {
/*
* ConstantsDialog allows one to specify a constant that is the
* input to a functional unit port.
*/

protected:
  
  static const char *const MY_CLASS;  // my class name

  Boolean DoneRunning, *IsInputPortBoundToConstant, 
          *IsOutputFieldBoundToConstant;

  ConfigBoard *StatusBoard;

  InterfaceClass *PabloInterface;

  Widget DialogShell, *PortTextFields, *OutputTextFields;

  /* Method _buildActionArea:  make action area of the dialog */
  void _buildActionArea(Widget);

  /* Method _buildControlArea:  make control area of the dialog */
  void _buildControlArea(Widget);

  /* Method _buildOutputFrame:  setup area for scrolled region of output 
               record fields that have been bound to constants */
  void _buildOutputFrame(Widget, Widget);

  /* Method _buildPortFrame:  setup area for scrolled region of input ports
               that have been bound to constants */
  void _buildPortFrame(Widget, Widget);

  /* Method _setDialogTitle:  set the title for the dialog */
  void _setDialogTitle();

  /* Method _setupPortConstants:  setup port constant values */
  void _setupPortConstants(Widget);

  /* Method _setupOutputConstants:  setup output constant values */
  void _setupOutputConstants(Widget);

public:

  /* Method ConstantsDialog:   the ConstantsDialog constructor */
  ConstantsDialog(Widget, InterfaceClass*, ConfigBoard*);

  /* Method ~ConstantsDialog:   the ConstantsDialog destructor */
  ~ConstantsDialog();

  /* Method callback1: callback called when continue is selected  */
  virtual void callback1(Widget, XtPointer, XtPointer);

  /* Method callback2: callback called when reset is selected  */
  virtual void callback2(Widget, XtPointer, XtPointer);

  /* Method callback3: callback called when a constant value is entered for
              an input port */
  virtual void callback3(Widget, XtPointer, XtPointer);

  /* Method callback4: callback called when a constant value is entered for
              an output field */
  virtual void callback4(Widget, XtPointer, XtPointer);

  /* Method helpCallback: callback called when help is selected */
  virtual void helpCallback(Widget, XtPointer, XtPointer);

  /* Method run: popup an instance of this dialog */
  void run();
};

#endif










