/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * AddModuleDialog.h:   This module implements a custom dialog for
 *			creating instances of analysis modules on the
 *			primary Pablo graph palette.  Only a single 
 *			instance of this class is allowed.
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/AddModuleDialog.h,v 1.18 1994/02/25 04:29:24 aydt Exp $	
 */

#ifndef AddModuleDialog_h
#define AddModuleDialog_h

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Frame.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/List.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/RowColumn.h>
#include <Xm/ScrolledW.h>
#include <Xm/TextF.h>

#include "CString.h"
#include "CStringObjList.h"
#include "FunctionalUnitManager.h"
#include "FUClassification.h"
#include "GeneralDictionary.h"
#include "Obj.h"
#include "Pablo.h"
#include "PabloResources.h"
#include "util.h"

class PabloMainInterface;

class AddModuleDialog : public Obj {
/*
 *	The AddModuleDialog allows the user to interactively specify
 *	instances of analysis modules.  These modules are instantiated
 *	on the Pablo graph canvas (i.e., the primary display of the
 *	analysis graph).
 */

private:
        static const char *const MY_CLASS;              // Our class name

	static PabloMainInterface *pabloMainInterface;  // created by object

	Boolean_ isManaged;				// Currently managed?

protected:
	int	categoryCount;

	Widget	fuList[10];
	Widget	fuBox[10];

	Widget	addDialog;
	Widget	dialogPane;
	Widget	controlArea;
     	Widget	actionArea;

        Widget	dismissButton;
   	Widget	addButton;
   	Widget	helpButton;

	Widget	fuScrollBox;
	Widget	fuRowColumn;

	Widget	nameBox;
 	Widget	nameLabel;
	Widget	moduleText;
	Widget	fuLabel;

	Widget	iconBox;
	Widget	iconLabel;

	Widget	pixmapFrame;
	Widget	fuGraphic;

	Pixel	pabloForeground;
	Pixel	pabloBackground;

        CString selectedFU;
        GeneralDictionary *uniqueNumDict;

        /* Method _staticAddCallback:		the static interface to the
        *                               	dynamic callback for the "Add"
        *                               	button in this dialog         */
        static void _staticAddCallback( Widget w,
                                    XtPointer clData, XtPointer caData );

        /* Method _staticDefaultCallback:	the static interface to the
        *                                   	dynamic callback for the
	*					selection of a particular item
	*					in one of the scroll boxes    */
        static void _staticDefaultCallback( Widget w,
                                    XtPointer clData,
                                    XmListCallbackStruct *cbs );

        /* Method _staticDismissCallback:   	the static interface to the
	*				   	dynamic callback for the
	*					"Dismiss" button in this
	*					dialog                        */
        static void _staticDismissCallback( Widget w,
                                    XtPointer clData, XtPointer caData );

        /* Method _staticHelpCallback:   	the static interface to the
        *                               	dynamic callback for the "Help"
        *                               	button in this dialog 	      */
        static void _staticHelpCallback( Widget w,
                                    XtPointer clData, XtPointer caData );

        /* Method _addCallback:	the dynamic callback to create an
	*		 	instance of an analysis module                */
        void _addCallback();

        /* Method _addFUToList:	inserts an analysis module (an FU) in a
	*			particular scroll box		      	      */
        void _addFUToList( const char *fuName, FUClassType fuType );

	/* Method _defaultCallback: callback function invoked when a user
	*			selects an instance of an analysis module     */
        void _defaultCallback( Widget w,
                        XtPointer clientData, XmListCallbackStruct *ret );

	/* Method _dismissCallback: callback function invoked in response to
	*			the user desire to close the dialog	      */
        void _dismissCallback();

	/* Method _createPixmap: creates an icon representing the currently
	*			selected analysis module		      */
        void _createPixmap( int pixmapHeight,
                            int pixmapWidth, char *pixmapBits );

	/* Method _getUniqueNumFor: returns a unique number for the specfied
	*			analysis module to be used as part of a
	*			unique name				      */
        int  _getUniqueNumFor( const CString &fu );

	/* Method _helpCallback: callback function invoked in reponse to a
	*			user request for help			      */
        void _helpCallback();

	/* Method _initFromFUM: determines the number and types of analysis
	*			modules by querying the functional unit
	*			manager					      */
	void _initFromFUM();

public:
        /* Method AddModuleDialog:     The Constructor		              */
	AddModuleDialog( PabloMainInterface *createdBy );

        /* Method ~AddModuleDialog: the destructor (destroys the created
	*			dialog)					      */
	~AddModuleDialog();

	/* Method raiseDialog: 		Pops up the dialog for user 
	*				interaction                           */
	void raiseDialog();

	/* Method resetUniqueNums:   	Resets the dictionary of unique numbers
	*			        for FUs of each type.                 */
	void resetUniqueNums();

	/* Method printOn: 		Stream output function		      */
	void printOn( ostream &os = cout ) const ;
};

inline ostream &operator<<( ostream &os, AddModuleDialog &obj )
{
	obj.printOn(os);
	return os;
}

#endif
