/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * PrinterFU.cc - A PrinterFU fu.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FunctionalUnits/RCS/PrinterFU.C,v 1.6 1994/03/15 16:41:54 aydt Exp $
 */

#include <Xm/Text.h>

#include "PrinterFU.h"

#include "DataTraits.h"
#include "InputPort.h"
#include "PabloResources.h"
#include "TextWidget.h"

PrinterFU::PrinterFU()
{
	inputPort = NULL;
	text = NULL;
	dialog = NULL;
}

PrinterFU::~PrinterFU()
{
	delete inputPort;
	delete text;
	delete dialog;
}

void 	/* static */
PrinterFU::_showString( WidgetBase *text, char *s )
{
	XmTextPosition pos;

	pos = XmTextGetLastPosition( text->getWidget() );
	XmTextInsert( text->getWidget(), pos, s );
	pos = XmTextGetLastPosition( text->getWidget() );
	XmTextShowPosition( text->getWidget(), pos );
}


FunctionalUnit *
PrinterFU::copy()			/* virtual */
{
	PrinterFU *copy = new PrinterFU();
	return copy;
}

void 
PrinterFU::init() 			/* virtual */
{
	if ( inputPort != NULL ) {
	    delete inputPort;
	}
	if ( text != NULL ) {
	    delete text;
	}
	if ( dialog != NULL ) {
	    delete dialog;
	}

	inputPort = new InputPort( "Input" );

	inputPort->addTraits( INTEGER, 0 );
	inputPort->addTraits( INTEGER, 1 );
	inputPort->addTraits( INTEGER, 2 );
	inputPort->addTraits( FLOAT, 0  );
	inputPort->addTraits( FLOAT, 1  );
	inputPort->addTraits( FLOAT, 2  );
	inputPort->addTraits( DOUBLE, 0 );
	inputPort->addTraits( DOUBLE, 1 );
	inputPort->addTraits( DOUBLE, 2 );
	_addInputPort( inputPort );

	dialog = _getTitledFormDialog( "PrinterFUDialog", getName() );
	// NO scrolling, NO edits
	text = new TextWidget( dialog, NullArgs, "Contents", TRUE_, TRUE_ );

	text->manage();
	dialog->manage();
}

Boolean_ 
PrinterFU::ready()
{
	return TRUE_;
}

void 		/* virtual */
PrinterFU::run(  Boolean_& errorFlag )
{
	if ( ! inputPort->valueAvailable() ) {
	    warning ( "Problem in printer... value not available" );
	    errorFlag = TRUE_;
	    return;
	}

	const Value* valueP = inputPort->getValueP();
	DataTraits traits = valueP->getTraits();
	double d;

	if ( traits.isArray() ) {
	    Array *a = (Array *) *valueP;

	    int nDims = a->getDimension();
	    const int *dimSizes = a->getDimSizes();
	    int i, j;

	    _showString( text, form( "Showing array nDims=%d\n", nDims ) );
	    for ( i = 0; i < nDims; i++ ) {
		_showString( text, form( "Dimension %d has %d elements.\n", 
					 i, dimSizes[i] ) );
	    }

	    if ( nDims == 1 ) {
		_showString( text, "Showing vector.\n" );
		for ( i = 0; i < dimSizes[0]; i++ ) {
		    d = a->getCellValue( i );
		    _showString( text, form( "%lf\n", d ) );
		}
	    } else if ( nDims == 2 ) {
		_showString( text, "Showing 2-dim array\n" );
		for ( i = 0; i < dimSizes[0]; i++ ) {
		    for ( j = 0; j < dimSizes[1]; j++ ) {
			d = a->getCellValue(i, j);
			_showString( text, form( "%lf ", d ) );
		    }
		    _showString( text, "\n" );
		}
	    }
	} else {
	    d = *valueP;
	    _showString( text, form( "Scalar value = %lf\n", d ) );
	}
}
