/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Authors: Philip C. Roth (proth@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/***********************************************************
 *
 * ListNode.C
 *
 * Phil Roth
 * Definition of methods for ListNode class, 
 * a singly linked list class.
 *
 ************************************************************/
#include "ListNode.h"


ListNode::ListNode( void )
{
	next = NULL;
}


/* virtual */
ListNode::~ListNode( void )
{
	if ( next ) {
		delete next;		// delete rest of the List
	}
}

/*
 * _insertHere()
 *
 * If "this" should be inserted before list element n,
 * return TRUE_.  Otherwise, return FALSE_.
 *
 * As it stands, all new elements are inserted at the head of the List.
 */

/* virtual */
Boolean_
ListNode::_insertHere( ListNode * /* n */ )
{
	return TRUE_;
}



/*
 * insertYourself()
 *
 * Inserts "this" into the given List, before the element
 * indicated by the method _insertHere().
 * Returns the resulting List.
 */

/* virtual */
ListNode *
ListNode::insertYourself( ListNode *list )
{
	ListNode *curr = list;
	ListNode *prev = NULL;

	while ( curr ) {
		if ( _insertHere( curr ) ) {

			/* link "this" before curr */
			if ( prev ) {
				/* curr is in the list interior */
				prev->next = this;
			} else {
				/* curr is the first element of the list */
				list = this;
			}
			next = curr;

			return list;
		} else {
			/* advance pointers */
			prev = curr;
			curr = curr->next;
		}
	}

	/* "this" should go at the end of the list */
	if( prev ) {
		prev->next = this;		// list was not empty
	} else {
		list = this;			// list was empty
	}

	next = NULL;	// delimit the list
	return list;
}



/*
 * removeYourself()
 *
 * Removes "this" from the indicated list, if it exists there.
 * Returns the resulting list.
 * Does not delete anything; in particular, does not delete "this."
 */
/* virtual */
ListNode *
ListNode::removeYourself( ListNode *list )
{
	ListNode *curr = list;
	ListNode *prev = NULL;


	/* find "this" in the list */
	while( curr ) {
		if( curr == this ) {

			/* unlink "this" */
			if( prev ) {
				prev->next = curr->next; // not first element
			} else {
				list = curr->next;	// first element
			}

			/* make sure "this" can't still access list */
			curr->next = NULL;

			return list;
		} else {
			/* advance to next list element */
			prev = curr;
			curr = curr->next;
		}
	}

	/* "this" was not found in the list, do nothing */
	return list;
}

