/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 * Contributing Author: Robert Olson (olson@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FUConfig/RCS/ParamDisplay.C,v 1.6 1994/03/11 00:31:02 aydt Exp $
 *
 *	ParamDisplay:  Display parameters but don't let them be changed.
 */

#include <Xm/SeparatoG.h>

#include "ParamDisplay.h"

#include "ButtonWidget.h"
#include "FormDialogWidget.h"
#include "FormWidget.h"
#include "LabelWidget.h"
#include "LabelledWidget.h"
#include "Pablo.h"
#include "PabloHelpSystem.h"
#include "RowColumnWidget.h"
#include "WidgetBasePtrList.h"

#include "util.h"

void
ParamDisplay::_staticDestructMe( ParamDisplay *theInstance )
{
	delete theInstance;
}

ParamDisplay::ParamDisplay( WidgetBase *par, FUParams& params, 
			    const CString &title ) 
	     : WidgetBase( par )
{
	/* 
	 * elements is a list of pointers to the Widget Base instances we 
	 * create which we need to clean up when we call the destructor for
	 * this ParamDisplay instance.
	 */
	elements = new WidgetBasePtrList;

	/*  
	 * Create our form dialog widget, rowcolumn, and title
	 */
	dialog = new FormDialogWidget( par, NullArgs, "ParamDisplayDialog" );
	elements->addElement( dialog );
	setWidget( dialog->getWidget() );

	WidgetBase *rowcolumn = new RowColumnWidget( dialog, NullArgs, 
						     "rowColumn" );
	elements->addElement( rowcolumn );
	rowcolumn->manage();

	WidgetBase *titleLabel = new LabelWidget( rowcolumn, NullArgs, 
						  "title", title );
	elements->addElement( titleLabel );
	titleLabel->manage();

	UtilSetValue( XtParent( getWidget() ), XmNtitle, 
					       (XtArgVal) title.getValue() );

	/*
	 * For each parameter in the list, create a labelled widget for it 
	 * and the actual widget type requested to display the value.
	 */
	int i;
	WidgetBase *labelledWidget;
	WidgetBase *valueWidget;
	CString label;

	for ( i = 0; i < params.nParams(); i++ ) {
	    BaseFUParamEntry &param = params.getEntry( i );
	    label = param.getName() + ": ";
	    labelledWidget = new LabelledWidget( rowcolumn, label );
	    elements->addElement( labelledWidget );

	    valueWidget = param.createDisplayWidget( labelledWidget );
	    elements->addElement( valueWidget );
	    valueWidget->manage();
	}

	/*
	 * Create a separator and another form.
	 * Inside the form put the Dismiss and Help buttons. 
	 * Add the callbacks to Dismiss and Help.
	 */
	Widget separator = XtVaCreateManagedWidget( "separator", 
				 xmSeparatorGadgetClass,
				 dialog->getWidget(), 
				 XmNtopWidget, rowcolumn->getWidget(),
				 NULL );

	WidgetBase *bottomForm = new FormWidget( dialog, NullArgs, 
						     "bottomForm" );
	elements->addElement( bottomForm );
	bottomForm->manage();

	XtVaSetValues( bottomForm->getWidget(),
		       XmNtopWidget, separator,
		       NULL );

	WidgetBase *dismissButton = new ButtonWidget( bottomForm, NullArgs,
				          "dismissButton", "Dismiss");
	elements->addElement( dismissButton );
    	dismissButton->manage();

	dismissButton->addMemberCallback( XmNactivateCallback, 
				          &Callback::callback1, this );

	WidgetBase *helpButton = new ButtonWidget( bottomForm, NullArgs,
				          "helpButton", "Help");
	elements->addElement( helpButton );
    	helpButton->manage();

	helpButton->addMemberCallback( XmNactivateCallback, 
				          &Callback::helpCallback, this );

	/*
	 * Manage the dialog which displays it.
	 */
	dialog->manage();
}

ParamDisplay::~ParamDisplay()
{
	/* 
	 * We don't have to explicitly remove the callbacks because
	 * the will be removed when the widgets are destructed & the
	 * space in the parent Callback class is freed when that dtor
	 * is called (implicit in destrucing this.)
	 */

	int count = elements->count();
	int i;
	WidgetBase *wbp;

	for ( i = 0; i < count; i++ ) {
	    wbp = elements->getElement( i );
	    delete wbp;
	}
	delete elements;
}

void 		/* virtual OK callback */
ParamDisplay::callback1( Widget /* w */, XtPointer /* clientData */, 
				         XtPointer /* callData */ )
{
	/* 
	 * Lower the dialog by unmanaging it.
	 * Call "_staticDestructMe" to clean up after ourselves.
	 */
	dialog->unmanage();
	_staticDestructMe( this );
}

void 		/* virtual HELP callback */
ParamDisplay::helpCallback( Widget /* w */, XtPointer /* clientData */, 
			                    XtPointer /* callData */ )
{
        Pablo::HelpSystem()->giveHelpOn( "ParamDisplay" );
}
