/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author:	Ruth Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FUConfig/RCS/FUParams.C,v 1.14 1994/03/10 22:57:06 aydt Exp $
 */

#include "FUParams.h"

#include "RadioFUParamEntry.h"
#include "TextFUParamEntry.h"

FUParams::FUParams()
{
	list = new BaseFUParamEntryPtrList;
}

FUParams::~FUParams()
{
	list->deleteAllEntries();
	delete list;
}

void
FUParams::addDisplayParam( const CString& name, const Value& value )
{
	DataTraits traits = value.getTraits();
	if ( traits.isArray() ) {
	    warning( "FUParams::addDisplayParam() can't display Array Value." );
	    return;
	}

	TextFUParamEntry *ent;

	switch ( traits.getType() ){

	    case CHARACTER:
		{
		char buf[2];
		sprintf( buf, "%c", (char)value );
		ent = new TextFUParamEntry( name, BaseFUParamEntry::Str, 
					    buf, TRUE_ );
		}
		break;

	    case INTEGER:
		ent = new TextFUParamEntry( name, BaseFUParamEntry::Integer,
					    (int)value, TRUE_ );
		break;

	    case FLOAT:
	    case DOUBLE:
		ent = new TextFUParamEntry( name, BaseFUParamEntry::Real,
					    (double)value, TRUE_ );
		break;

	    case UNDEFINED:
		ent = new TextFUParamEntry( name, 
					    BaseFUParamEntry::UndefinedType,
					    (double)value, TRUE_ );
		break;
	}

	list->addElement(ent);
}

void
FUParams::addDisplayParam( const CString& name, int intValue )
{
	TextFUParamEntry *ent = new TextFUParamEntry( name, 
						      BaseFUParamEntry::Integer,
						      intValue, TRUE_ );
	list->addElement(ent);
}

void
FUParams::addDisplayParam( const CString& name, double dblValue )
{
	TextFUParamEntry *ent = new TextFUParamEntry( name, 
						      BaseFUParamEntry::Real,
					    	      dblValue, TRUE_ );
	list->addElement(ent);
}

void
FUParams::addDisplayParam( const CString& name, char *cstr )
{
	TextFUParamEntry *ent = new TextFUParamEntry( name, 
						      BaseFUParamEntry::Str, 
						      cstr, TRUE_ );
	list->addElement(ent);
}

void
FUParams::addDisplayParam( const CString& name, const char *cstr )
{
	TextFUParamEntry *ent = new TextFUParamEntry( name, 
						      BaseFUParamEntry::Str, 
						      cstr, TRUE_ );
	list->addElement(ent);
}

void
FUParams::addDisplayParam( const CString& name, const CString& cstr )
{
	TextFUParamEntry *ent = new TextFUParamEntry( name, 
						      BaseFUParamEntry::Str, 
						      cstr.getValue(), TRUE_ );
	list->addElement(ent);
}

void 
FUParams::addTextParam( const CString& name, 
			const BaseFUParamEntry::FUParamType type,
			const FUParamValue& value )
{
	TextFUParamEntry *ent;

	ent = new TextFUParamEntry( name, type, value, FALSE_ );
	list->addElement( ent );
}

void FUParams::addRadioButtonsParam( const CString& name, 
				     const BaseFUParamEntry::FUParamType type, 
				     const FUParamValue& value,
				     const CStringObjList& buttons )
{
	RadioFUParamEntry *ent;

	ent = new RadioFUParamEntry( name, type, value, buttons );
	list->addElement( ent );
}

BaseFUParamEntry& 
FUParams::getEntry( const CString& name ) const
{
	int i;

	for ( i = 0; i < list->count(); i++ ) {
	    BaseFUParamEntry *elt = list->getElement( i );
	    if ( ( elt->getName() ) == name ) {
		return *elt;
	    }
	}
	return BaseFUParamEntry::getNull();
}

BaseFUParamEntry::FUParamType 
FUParams::getType( const CString& name ) const
{
	BaseFUParamEntry &ent = getEntry( name );
	return ent.getType();
}

const FUParamValue& 
FUParams::getValue( const CString& name ) const
{
	BaseFUParamEntry &ent = getEntry( name );
	return ent.getValue();
}

Boolean_ 
FUParams::valueIsValid( const CString& name ) const
{
	BaseFUParamEntry &ent = getEntry( name );
	return ent.valueIsValid();
}

BaseFUParamEntry::FUParamType 
FUParams::getType( int n ) const
{
	BaseFUParamEntry &ent = getEntry( n );
	return ent.getType();
}

const FUParamValue& 
FUParams::getValue( int n ) const
{
	BaseFUParamEntry &ent = getEntry( n );
	return ent.getValue();
}

Boolean_ 
FUParams::valueIsValid( int n ) const
{
	BaseFUParamEntry &ent = getEntry( n );
	return ent.valueIsValid();
}
