/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	FUParamValue.cc
 * 	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FUConfig/RCS/FUParamValue.C,v 1.9 1994/03/10 22:56:23 aydt Exp $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "FUParamValue.h"

FUParamValue::FUParamValue() 
{
	type = Invalid;
}

FUParamValue::FUParamValue( int i ) 
{
	type = Integer;
	value.i = i;
}

FUParamValue::FUParamValue( double d ) 
{
	type = Real;
	value.r = d;
}

FUParamValue::FUParamValue( char *s ) 
{
	type = Str;
	value.s = (char *) malloc( strlen(s) + 1 );
	strcpy( value.s, s );
}

FUParamValue::FUParamValue( const char *s ) 
{
	type = Str;
	value.s = (char *) malloc( strlen(s) + 1 );
	strcpy( value.s, s );
}

FUParamValue::FUParamValue( const FUParamValue& ent )
{
	type = ent.type;
	if ( type == Str ) {
	    value.s = (char *) malloc( strlen(ent.value.s) + 1 );
	    strcpy( value.s, ent.value.s );
	} else {
	    value = ent.value;
	}
}

FUParamValue::~FUParamValue() 
{
	if ( type == Str ) {
	    free( value.s );
	    value.s = NULL;
	}
}

FUParamValue& 
FUParamValue::operator=( const FUParamValue& val )
{
	if ( type == Str ) {
 	    free( value.s );
	    value.s = NULL;
	}

	type = val.type;
	if ( type == Str ) {
	    value.s = (char *) malloc( strlen(val.value.s) + 1 );
	    strcpy( value.s, val.value.s );
	} else {
	    value = val.value;
	}

        return *this;
}


int
FUParamValue::operator==( const FUParamValue& val ) const
{
	int retVal;

	if ( type != val.type ) {
	    retVal = 0;
	} else {
	    switch ( type ) {
	        case Integer:
		    retVal = ( value.i == val.value.i );
		    break;
		
	        case Str:
		    retVal = ( strcmp(value.s, val.value.s) == 0 );
		    break;
		
	        case Real:
		    retVal = ( value.r == val.value.r );
		    break;

	        case Invalid:
		    retVal = 0;
		    break;
	    }
	}

	return retVal;
}

FUParamValue::operator const char *() const
{
	if ( getType() == Str ) {
	    return getString();
	} else {
	    static char buf[100];
	    if ( getType() == Integer ) {
		sprintf( buf, "%d", getInteger() );
	    } else {
		sprintf( buf, "%lf", getReal() );
	    }
	    return buf;
	}
}

FUParamValue::operator int() const
{
	if ( getType() == Str ) {
	    return atoi( getString() );
	} else if ( getType() == Real ) {
	    return (int) getReal();
	} else {
	    return getInteger();
	}
}

FUParamValue::operator float() const
{
	if ( getType() == Str ) {
	    return (float) atof( getString() );
	} else if ( getType() == Real ) {
	    return (float) getReal();
	} else {
	    return (float) getInteger();
	}
}

FUParamValue::operator double() const
{
	if ( getType() == Str ) {
	    return (double) atof( getString() );
	} else if ( getType() == Real ) {
	    return (double) getReal();
	} else {
	    return (double) getInteger();
	}
}

/*
 * Initialize Static members
 */
char *FUParamValue::typeNames[] = { "Integer", "Real", "Str" };
