/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/FUConfig/RCS/BaseFUParamEntry.C,v 1.13 1994/03/10 22:54:41 aydt Exp $
 */

#include <stdio.h>

#include "BaseFUParamEntry.h"
#include "WidgetBase.h"


BaseFUParamEntry::BaseFUParamEntry() :
		  name( "" ),
		  type( UndefinedType ),
		  value( 0 ),
		  validFlag( FALSE_ )
{
	_objectName = NULL;
}

BaseFUParamEntry::BaseFUParamEntry( const CString& name, const FUParamType type,
				    const FUParamValue& value ) :
		  name( name ),
		  type( type ),
		  value( value ),
		  validFlag( TRUE_ )
{
	_objectName = NULL;
}

BaseFUParamEntry::BaseFUParamEntry( BaseFUParamEntry& ent ) :
		  name( ent.name ),
		  type( ent.type ),
		  value( ent.value ),
		  validFlag( ent.validFlag )
{
	_objectName = NULL;
}

BaseFUParamEntry::~BaseFUParamEntry()
{
	if ( _objectName != NULL ) {
		delete _objectName;
	}
}

void
BaseFUParamEntry::setValue( const FUParamType newType,
                            const FUParamValue& newValue )
{
	type = newType;
	value = newValue;
}


void
BaseFUParamEntry::_setObjectName()
{
	if ( _objectName != NULL ) {
		delete _objectName;
	}

	char buf[256];
	sprintf( buf, "%s(%s)", getClassName(), (const char *)name );
	_objectName = new char[ strlen(buf) + 1 ];
	strcpy( _objectName, buf );
}
	
BaseFUParamEntry& 
BaseFUParamEntry::operator=( const BaseFUParamEntry& ent )
{
	name = ent.name;
	type = ent.type;
	value = ent.value;
	validFlag = ent.validFlag;

	_setObjectName();

	return *this;
}

int 
BaseFUParamEntry::operator==( const BaseFUParamEntry& ent ) const
{
	return ( (name == ent.getName() ) &&
	         (type == ent.getType() ) &&
	         (validFlag == ent.valueIsValid() ) &&
	         (value == ent.getValue() ) );
}
				 
const char* 
BaseFUParamEntry::getObjectName() const		/* virtual function */
{
	if ( _objectName == NULL ) {
		return getClassName();
	} else {
		return _objectName;
	}
}
	
void 
BaseFUParamEntry::setWidgetValue( WidgetBase *w )
{
	//cout << form("Setting String value to be %s\n", (const char *) value);
	w->setStringValue((const char *) value);
}

void 
BaseFUParamEntry::getValueFromWidget( WidgetBase *w )
{
	if ( getType() == Integer ) {
	    setValue( w->getIntegerValue() );
	} else if ( getType() == Real ) {
	    setValue( w->getDoubleValue() );
	} else {
	    /* strings are a bit more work since we must free the space */
	    char *string = w->getStringValue();
	    setValue( string );
	    XtFree( string );
	}
}

/*
 * initialize static data
 */
static BaseFUParamEntry PrivateNullEntry;
BaseFUParamEntry * BaseFUParamEntry::NullObjPtr = &PrivateNullEntry;
