/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * DisplayLabels.cc:
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Misc/RCS/DisplayLabels.C,v 1.16 1994/03/31 02:01:45 aydt Exp $
 */

#include <stdio.h>
#include "DisplayLabels.h"

DisplayLabels::DisplayLabels()
{
     widgetLeftVertLabel = NULL;
     widgetBottomHorizLabel = NULL;
     widgetTopHorizLabel = NULL;

     pctTotal = FORM_FRACTION_BASE;
     pctHtBottomHorizLabel = 0;
     pctHtLeftVertLabel = 0;
     pctHtTopHorizLabel  = 0;

     lengBottomHorizLabel = 0;
     lengLeftVertLabel = 0;
     lengTopHorizLabel = 0;
}     

DisplayLabels::~DisplayLabels()
{
}

XmString 
DisplayLabels::verticalizeLabel( const char *stringLabel )
{
     char verticalizedLabel[ LABEL_MAX_LEN * 2 ];

     for ( int j = 0;  stringLabel[j] != '\0'; j++ ) {
         verticalizedLabel[2*j] = stringLabel[j];
         verticalizedLabel[2*j+1] = '\n';
     }
     verticalizedLabel[2*j] = '\0';

     return( XmStringCreateLtoR( verticalizedLabel, "newCent-i-12" ) );
}

void 
DisplayLabels::loadLabelFont( Widget displayGiver, char *newStringFont )
{
     static char currentStringFont[FONT_MAX_LEN];

     if ( strcmp(currentStringFont, newStringFont) != 0) {
        labelFont = XmFontListCreate(
               XLoadQueryFont( XtDisplay(displayGiver), newStringFont ),
                               XmSTRING_DEFAULT_CHARSET);
        strcpy(currentStringFont, newStringFont);
     }
}

void 
DisplayLabels::loadMinMaxFont( Widget displayGiver, char *newStringFont )
{
     static char currentStringFont[FONT_MAX_LEN];

     if ( strcmp(currentStringFont, newStringFont) != 0) {
        minMaxFont = XmFontListCreate(
               XLoadQueryFont( XtDisplay(displayGiver), newStringFont ),
                               XmSTRING_DEFAULT_CHARSET);
        strcpy(currentStringFont, newStringFont);
     }
}

void 
DisplayLabels::getLabel( int whichLabel, const char **stringLabel ) const
{
	Arg arg[1];

     	if ( whichLabel == L_BOTTOM_HORIZ ) {
            if ( lengBottomHorizLabel > 0 ) {
		*stringLabel = stringBottomHorizLabel;
	     } else {
	    	*stringLabel = NULLCHARSTRING;
	     }
	} else if ( whichLabel == L_LEFT_VERT ) {
            if ( lengLeftVertLabel > 0 ) {
	    	*stringLabel = stringLeftVertLabel;
            } else {
	    	*stringLabel = NULLCHARSTRING;
	    } 
	} else if ( whichLabel == L_TOP_HORIZ ) {
	    // We don't support this for the more complex Min/Max label
	    *stringLabel = NULLCHARSTRING;
	}

}

int 
DisplayLabels::getLabelHeight( int whichLabel )
{
     if (whichLabel == L_BOTTOM_HORIZ) {
        return( pctHtBottomHorizLabel );
     } else if (whichLabel == L_LEFT_VERT) {
        return( pctHtLeftVertLabel );
     } else if (whichLabel == L_TOP_HORIZ) {
        return( pctHtTopHorizLabel );
     }
     return 0;			// shouldn"t get here!
}     

Boolean_
DisplayLabels::isALabel( int whichLabel )
{
     if ( whichLabel == L_BOTTOM_HORIZ ) {
        if ( widgetBottomHorizLabel == NULL ) {
           return(FALSE_);
        } else {
	   return(TRUE_);
        }
     } else if ( whichLabel == L_LEFT_VERT ) {
        if ( widgetLeftVertLabel == NULL ) {  
           return(FALSE_);
        } else {
	   return(TRUE_);
        }
     } else if ( whichLabel == L_TOP_HORIZ ) {
        if ( widgetTopHorizLabel == NULL ) {
           return(FALSE_);
        } else {
           return(TRUE_);
        }
     }
     return FALSE_;		// shouldn"t get here!
}  

Boolean_ 
DisplayLabels::setLabel( Widget labelParent, char *labelName, int whichLabel, 
					     const char *stringLabel ) 
{
     Arg      arglist[4];
     int      i;
     XmString xmstr;
     int      position;

     int sizeNewLabel = strlen(stringLabel);
     Boolean_ layoutChange = FALSE_;

     // Define the horizontal label
     if ( whichLabel == L_BOTTOM_HORIZ ) {

           lengBottomHorizLabel = sizeNewLabel;
           strncpy( stringBottomHorizLabel, stringLabel, LABEL_MAX_LEN-1 );
	   stringBottomHorizLabel[LABEL_MAX_LEN-1] = '\0';  

           // Put new label into XmString
	   xmstr = XmStringCreateLtoR( stringBottomHorizLabel, "newCent-i-12" );
           XtSetArg( arglist[0], XmNlabelString,  (XtArgVal) xmstr );

           if ( widgetBottomHorizLabel == NULL ) { 
	       	layoutChange = TRUE_;
               	widgetBottomHorizLabel = XtCreateManagedWidget( labelName,
		                                   xmLabelWidgetClass, 
					           labelParent, arglist, 1);

	       	// From top position of label calculate our % of form height
               	XtSetArg( arglist[0], XmNtopPosition, &position );
               	XtGetValues( widgetBottomHorizLabel, arglist, 1 );
               	pctHtBottomHorizLabel = pctTotal - position;

	       	// If we already have a vertical label, adjust it"s bottom
	       	// to be top of this horizontal label
	       	if ( widgetLeftVertLabel != NULL ) {
		    XtSetArg( arglist[0], XmNbottomPosition, 
					             (XtArgVal) position );
                    XtSetValues( widgetLeftVertLabel, arglist, 1 );
		}

            } else {			
                XtSetValues( widgetBottomHorizLabel, arglist, 1 );
            }   

	    XmStringFree( xmstr );
     }

     // Define the vertical label
     else if ( whichLabel == L_LEFT_VERT ) {
	    i = 0;

            lengLeftVertLabel = sizeNewLabel;
            strncpy( stringLeftVertLabel, stringLabel, LABEL_MAX_LEN-1 );
	    stringLeftVertLabel[LABEL_MAX_LEN-1] = '\0';

            // Add \n characters to "verticalize" the label
	    xmstr = verticalizeLabel( stringLeftVertLabel );
            XtSetArg( arglist[i], XmNlabelString, (XtArgVal) xmstr ); i++;

            if ( widgetLeftVertLabel == NULL ) {
		layoutChange = TRUE_;

	        // If we already have a bottom horizontal label, set the
	        // bottom of this vertical label to be the top of that.
                if ( widgetBottomHorizLabel != NULL ) {
                   XtSetArg( arglist[i], XmNbottomPosition, 
			 (XtArgVal)( pctTotal - pctHtBottomHorizLabel ) ); i++;
                }

                widgetLeftVertLabel = XtCreateManagedWidget( labelName,
					      	xmLabelWidgetClass,
					      	labelParent, arglist, i );

		// save our % of form width == right position of label
               	XtSetArg( arglist[0], XmNrightPosition, &pctHtLeftVertLabel );
                XtGetValues( widgetLeftVertLabel, arglist, 1 );

                // Adjust the min/max label
                if ( widgetTopHorizLabel != NULL ) {
                    XtSetArg( arglist[0], XmNleftPosition,
			                    (XtArgVal)pctHtLeftVertLabel );
                    XtSetArg( arglist[1], XmNrightPosition,
			   	  (XtArgVal)( pctTotal - pctHtLeftVertLabel ) );
                    XtSetValues( widgetTopHorizLabel, arglist, 2 );
	        }
	    } else {
               XtSetValues( widgetLeftVertLabel, arglist, i );	
            }

	    XmStringFree( xmstr );
    }

    return( layoutChange );
}

void 
DisplayLabels::createMinMaxLabel( Widget labelParent, char *labelName )
{
    Arg arglist[1];
    char stringMinMaxLabel[LABEL_MAX_LEN];

    strcpy( stringMinMaxLabel, "Min:\nMax: \0" );
    XmString xmStr = XmStringCreateLtoR( stringMinMaxLabel,"courier-12" );

    XtSetArg( arglist[0], XmNlabelString,  (XtArgVal) xmStr );
    widgetTopHorizLabel = XtCreateManagedWidget( labelName,
	                                         xmLabelWidgetClass, 
					         labelParent, arglist, 1);
    XtSetArg( arglist[0], XmNbottomPosition, &pctHtTopHorizLabel );
    XtGetValues( widgetTopHorizLabel, arglist, 1 );

    XmStringFree( xmStr );
}

void 
DisplayLabels::setLabel( double fuMin, double fuMax )
{
    char stringMinMaxLabel[LABEL_MAX_LEN];
    char stringMinValue[LABEL_MAX_LEN/2];
    char stringMaxValue[LABEL_MAX_LEN/2];
    char *blanks = "                              ";

    sprintf( stringMinValue, "% .3lf", fuMin );
    sprintf( stringMaxValue, "% .3lf", fuMax );

    int lengthMin = strlen( stringMinValue );
    int lengthMax = strlen( stringMaxValue );

    sprintf( stringMinMaxLabel, "Min:");
    if ( lengthMin < lengthMax ) {
        strncat( stringMinMaxLabel, blanks, (lengthMax - lengthMin) );
    }
    strcat( stringMinMaxLabel, stringMinValue );

    strcat( stringMinMaxLabel, "\nMax:");
    if ( lengthMax < lengthMin ) {
        strncat( stringMinMaxLabel, blanks, (lengthMin - lengthMax) );
    }
    strcat( stringMinMaxLabel, stringMaxValue );

    Arg arglist[2];
    XmString xmStr = XmStringCreateLtoR( stringMinMaxLabel, "courier-12" );
    XtSetArg( arglist[0], XmNlabelString,  (XtArgVal)xmStr );
    XtSetValues( widgetTopHorizLabel, arglist, 1 );
    XmStringFree( xmStr );
}

