/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * WidgetBase.h: Abstract base class for widget wrappers. 
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Motif/Includes/RCS/WidgetBase.h,v 1.17 1994/03/11 00:21:19 aydt Exp $
 */

#ifndef WidgetBase_h
#define WidgetBase_h

#include <Xm/Xm.h>

#include "Callback.h"
#include "CString.h"
#include "EventHandler.h"
#include "Obj.h"
#include "XArgs.h"

static const XArgs NullArgs(0);

enum AttachmentType {
	AttachNone,
	AttachForm,
	AttachWidget,
	AttachOppositeWidget,
	AttachPosition,
	AttachSelf,
	};

enum AttachmentLocation {
	AttachTop,
	AttachLeft,
	AttachRight,
	AttachBottom
	};
	
class WidgetBase : public Obj, public virtual Callback, 
		   public virtual EventHandler {
/*
*
*	A WidgetBase is the abstract base class for the C++ widget wrappers.
*	It keeps track of the widget hierarchy with a pointer to the widget's
*	parent and a list of pointers to the widget's children.
*
*/

protected:
	CString 	type;
	Widget 		widget;
	int 		displayParamsSet;
	Display 	*display;
	Screen 		*screen;
	int 		screenNumber;
	Colormap 	defaultColormap;
	WidgetBase 	*parent;
	WidgetBase 	**children;
	int 		nChildren;
	int 		nChildrenAllocated;

	/* Method _setDisplayParams:	Set the display parameter variables   */
	void _setDisplayParams();
	
	/* Method _setType: 		Set the type of the Widget            */
	void _setType( const char * t ) { type = t; } ;

	/* Method _setType: 		Set the type of the Widget            */
	void _setType( const CString & t ) { type = t; } ;

public:
	/* Method WidgetBase: 		The WidgetBase constructor            */
	WidgetBase( WidgetBase * parent );

	/* Method ~WidgetBase: 		The WidgetBase destructor             */
	~WidgetBase();

	/* Method getIntegerValue:	Returns the integer value of the
	*				widget				      */
	virtual int getIntegerValue() const {
		Obj::subclassResponsibility( "WidgetBase::getIntegerValue() ");
		return 0;
		} ;

	/* Method getDoubleValue:	Returns the double value of the
	*				widget				      */
	virtual double getDoubleValue() const {
		Obj::subclassResponsibility( "WidgetBase::getDoubleValue() ");
		return 0.0;
		} ;

	/* Method getStringValue:	Returns the string value of the
	*				widget.  Caller must use XtFree()
	*				to release the space used by the
	*				string                                */
	virtual char * getStringValue() const {
		Obj::subclassResponsibility( "WidgetBase::getStringValue() ");
		return NULL;
		} ;

	/* Method setIntegerValue:	Sets the integer value of the
	*				widget				      */
	virtual void setIntegerValue( int ) {
		Obj::subclassResponsibility( "WidgetBase::setIntegerValue() ");
		} ;

	/* Method setDoubleValue:	Sets the double value of the
	*				widget				      */
	virtual void setDoubleValue( double ) {
		Obj::subclassResponsibility( "WidgetBase::setDoubleValue() ");
		} ;

	/* Method setStringValue:	Sets the string value of the
	*				widget				      */
	virtual void setStringValue( const char * ) {
		Obj::subclassResponsibility( "WidgetBase::setStringValue() ");
		} ;

	/* Method manageFormDialog: 	manage the widget- can be overloaded  */
	virtual void manageFormDialog() { XtManageChild(widget) ; } ;

	/* Method unmanageFormDialog:	unmanage the widget-can be overloaded */
	virtual void unmanageFormDialog() { XtUnmanageChild(widget) ; } ;

	/* Method addMemberCallback: 	Add a callback which is a member
	*		             	function to the widget.  Done through
	*				the Callback::addCallback() method.   */
	void addMemberCallback( String name, pCf memberFunction, 
				Callback *object, XtPointer clientData = NULL );

	/* Method addMemberEventHandler: Add an event handler which is a member
	*		             	function to the widget.  Done via 
	*				EventHandler::addEventHandler().      */
	void addMemberEventHandler( EventMask mask, Boolean nonmaskable,
				    pEf memberFunction, EventHandler *object, 
				    XtPointer clientData = NULL );

	/* Method allocateColor:	Allocate a color from the default
	 *				colormap 		       	      */
	Pixel allocateColor( const CString& color );

	/* Method allocateRGBColor:	Allocate a color from the default
	 *				colormap 		       	      */
	Pixel allocateRGBColor( int red, int green, int blue );

	/* Method attachToWidget: 	if this widget is a child of a form
	 *				widget, set the attachment for this
	 *				widget 			       	      */
	void attachToWidget( AttachmentLocation loc, AttachmentType type,
			     WidgetBase *w = NULL );

	/* Method attachToWidget: 	if this widget is a child of a form
	 *				widget, set the attachment for this
	 *				widget 			       	      */
	void attachToWidget( AttachmentLocation loc, AttachmentType type,
			     int position );

	/* Method getArgs: 		get a set of the widget resource 
	*				values 				      */
	void getArgs( XArgs& xargs );

	/* Method getDefaultColormap:	return the default colormap           */
	Colormap getDefaultColormap();
	
	/* Method getDisplay:		return the Display pointer for widget */
	Display * getDisplay();

	/* Method getOrigin:		return the position of the widget     */
	void getOrigin( Position *x, Position *y );

	/* Method getParent: 		return the parent of the Widget       */
	WidgetBase * getParent() { return parent; } ;

	/* Method getPosition:		return the position of the widget     */
	void getPosition( Position *x, Position *y );

	/* Method getScreen:		return the Screen pointer for wigdet  */
	Screen * getScreen();

	/* Method getScreenNumber:  	return the screen number for widget   */
	int getScreenNumber();

	/* Method getSize:		return the size of the widget	      */
	void getSize( Dimension *width, Dimension *height );

	/* Method getType:  		return the type of the Widget         */
	CString & getType() { return type; } ;

	/* Method getValue: 		get one of the widget resource values */
	void getValue( String name, XtArgVal value );

	/* Method getWidget: 		return the X widget pointer of the 
					Widget 				      */
	Widget getWidget() const;

	/* Method getWindow: 		Return the window id                  */
	Window getWindow() { return XtWindow(widget); } ;

	/* Method manage: 		manage the widget                     */
	void manage() { XtManageChild(widget) ; } ;

	/* Method realize: 		realize the widget                    */
	void realize() { XtRealizeWidget(widget) ; } ;

	/* Method removeMemberCallback: Remove callback which is a member
	*		             	function to the widget.  Done through
	*				Callback::removeCallback() method.    */
	void removeMemberCallback( String name, pCf memberFunction, 
				Callback *object, XtPointer clientData = NULL );

	/* Method removeMemberEventHandler: Remove event handler which is a
	*		                 member function to the widget. Use 
	*				 EventHandler::removeEventHandler().  */
	void removeMemberEventHandler( EventMask mask, Boolean nonmaskable,
				    pEf memberFunction, EventHandler *object, 
				    XtPointer clientData = NULL );

	/* Method setArgs: 		Sets a set of widget resource values  */
	void setArgs( XArgs& xargs );

	/* Method setPosition:		Sets the X/Y widget position	      */
	void setPosition( Position x, Position y );

	/* Method setSensitive: 	Set the sensitivity                   */
	void setSensitive( Boolean_ flag = TRUE_ );

	/* Method setSize:		Sets the widget size		      */
	void setSize( Dimension width, Dimension height );

	/* Method setUnsensitive:	Sets the widget unsensitive	      */
	void setUnsensitive();

	/* Method setValue: set one of the widget resource values */
	void setValue( String name, XtArgVal value );

	/* Method setWidget: set the X widget pointer of the Widget */
	void setWidget( Widget w ) { widget = w; } ;

	/* Method translateCoords:	Translates from one position to
	*				another				      */
	void translateCoords( Position fx, Position fy,
			      Position *x, Position *y );

	/* Method unmanage: 		unmanage the widget */
	void unmanage() { XtUnmanageChild(widget) ; } ;

};

inline Widget
WidgetBase::getWidget() const
{
	return widget;
}

#endif

