/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * DefaultOutputHandlers.cc: Code to print error, abort and warning 
 * messages to "appropriate" output - either stderr or a window.
 * Also, code to print information about an object - either to stdout
 * or to a window.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Base/RCS/DefaultOutputHandlers.C,v 1.12 1994/02/28 21:23:21 aydt Exp $
 */
#include <stdlib.h>

#include "Obj.h"

/**************************************************
 * First, the routines that handle error messages.*
 **************************************************/

#ifndef WINDOWED_ERROR_HANDLERS

/*
 * Output to stderr
 */
 
void 
DefaultAbortHandler( const Obj *obj, const char *const buf )
{
	cerr << form( "Fatal Error (this=%x name=%s):\n  %s\n",
		     obj, obj->getObjectName(), buf );
	abort();
}

void 
DefaultErrorHandler( const Obj *obj, const char *const buf )
{
	cerr << form( "Error (this=%x name=%s):\n  %s\n",
		     obj, obj->getObjectName(), buf );
}

void 
DefaultInfoHandler( const char *const buf )
{
	cerr << form( "%s\n", buf );
}

void 
DefaultWarningHandler( const Obj *obj, const char *const buf )
{
	cerr << form( "Warning (this=%x name=%s):\n  %s\n",
		     obj, obj->getObjectName(), buf );
}

#else

/* 
 * Output to a window -- need to come back and change the
 * icon to error or warning -- for now just use info!
 */

#include "GeneralDialogBox.h"
#include "Pablo.h"

void 
DefaultAbortHandler( const Obj *obj, const char *const buf )
{
	Pablo::GeneralDialog()->runError( 
			     "Fatal error (obj = %x, name = %s):\n  %s",
			     obj, obj->getObjectName(), buf );
	::abort();
}

void 
DefaultErrorHandler( const Obj *obj, const char *const buf )
{
	Pablo::GeneralDialog()->runError( 
			     "Error (%s):\n  %s",
			     obj->getObjectName(), buf );
}

void 
DefaultInfoHandler( const char *const buf )
{
	Pablo::GeneralDialog()->runInfo( "%s\n", buf );
}

void 
DefaultWarningHandler( const Obj *obj, const char *const buf )
{
	Pablo::GeneralDialog()->runWarning( 
			       "Warning (%s):\n  %s",
			       obj->getObjectName(), buf );
}

#endif WINDOWED_ERROR_HANDLERS
