/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *  TraceParam.h:
 *	This file contains all the configurable parameters for
 *	the Pablo instrumentation interface library code.
 */

/*
 *	ASSERT_NO_BACKSLASH:
 *	   Define this token if the C compilation tools choke on
 *	   invocations of the Assert macro which are continued across
 *	   physical lines of source code by lines ending with a backslash.
 */

#ifdef sparc
#	define	ASSERT_NO_BACKSLASH
#endif /* sparc */

#ifdef i386
#	undef	ASSERT_NO_BACKSLASH
#endif /* i386 */


/*
 *	Reserved event identifiers:
 *	   These are the event IDs of all reserved, or internal, event
 *	   types.  Access to these events is limited to the internals of
 *	   the trace library itself, they are not user-accessible or
 *	   manipulable.  The values of the event IDs may of course be
 *	   freely reassigned and the trace library recompiled, to avoid
 *	   collision with user event IDs.
 */

#define EVENTID_AGGREGATE   0x80000000	/* triggered by every user event     */
#define EVENTID_BADCLOCK    0x80000001	/* clock granularity exceptions	     */
#define EVENTID_DUMPTIME    0x80000002	/* time to dump trace buffer	     */
#define EVENTID_CLOCKTIME   0x80000003	/* time to obtain clock value	     */
#define EVENTID_TRACETIME   0x80000004	/* time to record event traces	     */
#define EVENTID_COUNTTIME   0x80000005	/* time to record event counts	     */
#define EVENTID_INTVLTIME   0x80000006	/* time to record event intervals    */
#define EVENTID_DUMMY	    0x80000007	/* dummy internal event		     */

/*
 *	Event trace levels:
 *	   Trace levels range from completely ignored to the configured
 *	   maximum.  Between these two limits, the thresholds for including
 *	   event counts, interval event trace records, and full trace
 *	   records in the trace output must be defined.  If the trace level
 *	   at the occurrence of an event is greater than LEVEL_IGNORE but
 *	   less than the applicable threshold value, the event will be noted
 *	   internally by the trace library, but no trace record will be
 *	   output.  By defining LEVEL_COUNT to be less than LEVEL_INTERVAL
 *	   and/or LEVEL_FULL, interval trace records and/or full trace
 *	   records (respectively) will be suppressed in favor of event
 *	   counts, provided the trace level is at least LEVEL_COUNT but
 *	   less than the respective threshold.
 *
 *	   All trace levels MUST be nonnegative integers.
 */

#define LEVEL_IGNORE		0	/* do not trace this event	     */
#define LEVEL_COUNT		4	/* include count trace records	     */
#define LEVEL_INTERVAL		8	/* include interval trace records    */
#define LEVEL_FULL		12	/* include full trace records	     */
#define LEVEL_MAXIMUM		16	/* the highest trace level	     */

					/* the default initial trace level   */
#define DEFAULTTRACELEVEL	LEVEL_MAXIMUM

/*
 *	Event flags:
 *	   Boolean attributes associated with event types.
 */

#define EVENTFLAG_NORMAL	0x00	/* an ordinary event type	     */
#define EVENTFLAG_INTERNAL	0x01	/* internal event, no user access    */

					/* the default event flag value	     */
#define DEFAULTEVENTFLAGS	EVENTFLAG_NORMAL

/*
 *	Default event count writing frequency:
 *	   Rather than each event count trace record being written out to
 *	   the trace buffer, the trace library supplies a mechanism by
 *	   which only every Nth count record (for some positive integer
 *	   N) actually generates a trace record.  This value N is called
 *	   the event type's count writing frequency.  The default is 1,
 *	   i.e. every count trace record which would otherwise be generated
 *	   is written out.
 */

#define DEFAULTCOUNTFREQ	1	/* default count writing frequency   */


/*
 *	Trace buffer parameters:
 */

#define DEFAULTBUFFERSIZE	0x20000	/* size of the default trace buffer  */

/*
 *	Trace buffer types:
 *	   Buffers can be dumped either when full or circular.  In the
 *	   latter case, the latest values overwrite earlier trace buffer
 *	   contents.
 */

#define BUFFER_CIRCULAR		1	/* circular buffer, overwrite when   */
					/* the buffer fills		     */
#define BUFFER_DUMP		2	/* dump each time the buffer fills   */

					/* the default buffer type	     */
#define DEFAULTBUFFERTYPE	BUFFER_DUMP

/*
 *	Trace buffer status flags:
 */

#define BUFFERFLAG_EMPTY	0x00	/* empty buffer			     */
#define BUFFERFLAG_WRAP		0x01	/* circular buffer has wrapped	     */

/*
 *	Event hash table size:
 *	   Note that this says nothing about the hashing function itself,
 *	   although the two issues are inseparable.  But the size of the
 *	   table (and as a consequence, the range of the hashing function)
 *	   must be defined here.  There are many different criteria for
 *	   what determines a "good" hashing function.  Certainly the event
 *	   hash table size should be a prime number.  Also, this size should
 *	   be chosen relative to the anticipated number of different event
 *	   types so that there are few collisions.  But nothing in the trace
 *	   library code should assume anything about this hash table size
 *	   beyond the fact that it's a positive integer.
 */

#define EVENTHASHTABLESIZE	1009	/* the event hash table size	     */

/*
 *	Trace record family tag masks:
 *	   Each family of event IDs will have its own function for
 *	   generating the instances of trace records for all events
 *	   within that family.  Corresponding to each of these families
 *	   is also a packet tag mask.  Each Pablo trace file Record
 *	   Descriptor and Record Data packet contains a tag, which is
 *	   composed of the bitwise OR of the event's family tag and the
 *	   trace record subtype (see below).
 */

					/* internal event families:	     */
#define FAMILY_AGGREGATE	0000	/* aggregate internal event family   */
#define FAMILY_BADCLOCK		0010	/* clock exceptions family	     */
#define FAMILY_DUMPTIME		0020	/* trace buffer dump time family     */
#define FAMILY_CLOCKTIME	0030	/* clock overhead family	     */
#define FAMILY_TRACETIME	0040	/* event trace overhead family	     */
#define FAMILY_COUNTTIME	0050	/* event count overhead family	     */
#define FAMILY_INTVLTIME	0060	/* event interval overhead family    */
#define FAMILY_DUMMY		0070	/* dummy internal event family	     */

#define FAMILY_EXTERNAL		0100	/* external event family	     */

#define FAMILY_BITMASK		~007	/* family tag bit mask		     */

/*
 *	Trace record subtypes:
 *	   Internal arguments passed to the eventRecordFunction (see
 *	   the event descriptor declaration in Trace.h) to indicate
 *	   the generic subtype of trace record to be constructed for
 *	   writing out to the trace buffer--full trace record with
 *	   user-supplied data, event count, or interval.
 */

#define RECORD_TRACE		01	/* full trace record with data	     */
#define RECORD_COUNT		02	/* event count record		     */
#define RECORD_INTERVAL		03	/* interval event record	     */

#define RECORD_BITMASK		07	/* record subtype bitmask	     */


/*
 *	Error return codes 
 */

#define SUCCESS			0	/* code returned on successful	     */
					/* completion of invoked routine     */

#define FAILURE			-1	/* error code returned when an	     */
					/* invoked routine fails	     */

/*
 *	Logical constants
 */

#define TRUE			1	/* affirmative			     */
#define FALSE			0	/* negative			     */


/*
 *	Time constants - see the CLOCK typedef in Trace.h
 */

#define	NOSUCHTIME		{~0,-1}	/* used for portable time	     */
					/* meaning "never happened"	     */

#define ZEROTIME		{0,0}	/* the CLOCK version of zero ticks   */


/*
 *	Adaptive tracing control constants:
 *	   If adaptive tracing is in effect for an event type (the default)
 *	   then the current effective trace level is controlled by the
 *	   trace library software.  This trace level is incremented or
 *	   decremented within the range LEVEL_IGNORE+1 to the event type's
 *	   maximum trace level, as the interval between successive events
 *	   is greater than the event type's "high water" mark or is less
 *	   than its "low water" mark, respectively.
 */

#define	LOWWATERMARK		{0,0}	/* default minimum time between	     */
					/* events of a given type without    */
					/* reducing the recording level	     */

#define	HIGHWATERMARK	{~0,0x7fffffff}	/* default maximum time between	     */
					/* events of a given type without    */
					/* increasing the recording level    */


/*
 *	Trace library initialization levels:
 *	   The trace library has degrees of initialization, from entirely
 *	   uninitialized to fully initialized.  In between there is a level
 *	   at which the basic data structures have been initialized but
 *	   internal events are not yet generated by the trace library.
 *	   When the first user event occurs, full library initialization
 *	   is triggered, causing the start-up internal events.
 */

#define UNINITIALIZED		0	/* library entirely uninitialized   */
#define INIT_BASIC		1	/* basic initialization		    */
#define INIT_FULL		2	/* complete initialization	    */


/*
 *	Trace library operational mode:
 *	   Either MODE_ASYNC for asynchronous operation, or MODE_SYNC
 *	   (the default) for synchronous operation.
 */

#define	MODE_SYNC		1	/* nodes synchronize		    */
#define MODE_ASYNC		2	/* nodes do not synchronize	    */
