/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Tara M. Madhyastha (tara@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/* Define the masks for the message send/receive event families,	    */
/* similarly to FAMILY_EXTERNAL and internal event families in		    */
/* the include file TraceParam.h.					    */


#define readBeginID        700000
#define writeBeginID       700001
#define lseekBeginID          700002

#define freadBeginID       700003
#define fwriteBeginID      700004
#define fseekBeginID      700005


#define readEndID          700006
#define writeEndID         700007
#define lseekEndID         700008

#define freadEndID          700009
#define fwriteEndID         700010
#define fseekEndID          700011

#define readSummaryID       700012
#define writeSummaryID       700013
#define seekSummaryID       700014

#define  openBeginID        700015
#define  openEndID          700016


#define  fopenBeginID       700017
#define  fopenEndID         700018



#define fcloseBeginID       700019
#define fcloseEndID         700020
#define closeBeginID        700022
#define closeEndID          700023

#define fileLifeID          700021
#define timeSummaryID       700024
#define spaceSummaryID       700025

#define readSizeHistogramID   700026
#define writeSizeHistogramID   700027

#define FAMILY_READ	6000		/* read */
#define FAMILY_WRITE	7000		/* write */
#define FAMILY_SEEK     5000            /* seek */
#define FAMILY_OPEN       8000          /* open */
#define FAMILY_CLOSE    1100            /* close */

#define FAMILY_LIFETIME         1200
#define FAMILY_TIME_SUMMARY     1300
#define FAMILY_SPACE_SUMMARY     1400
#define FAMILY_HISTOGRAM         1500


/* Define data structure types for message send and receive trace records,  */
/* similarly to record data structures in Trace.h			    */

/* FAMILY_READ family Record Data packet:			    */

/* modify the field number when you modify the record type */
#define READ_NUM_FIELDS   9
struct   readRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double duration;        /* duration of read                         */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* Node (processor) id */
	int	filepointer;	/* file id */
	int	numBytes;	/* number bytes read */
	int	numVariables;	/* number variables read */
	int	cause;	        /* some indication of cause */
};


/* FAMILY_WRITE family Record Data packet:			    */

/* modify the field number when you modify the record type */
#define WRITE_NUM_FIELDS 9
struct writeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double duration;       /* duration */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* node (processor ) id */
	int	filepointer;	/* file id */
	int	numBytes;	/* number bytes read */
	int	numVariables;	/* number variables read */
	int	cause;	        /* some indication of cause */
};

/* modify the field number when you modify the record type */
#define SEEK_NUM_FIELDS     8
struct   seekRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double duration;         /* seek duration */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* node(processor) id */
	int	filepointer;	/* file id */
	int	offset;	        /* number bytes read */
	int	ptrname;	/* 0, 1 or 2 == beginning end */
};


/* modify the field number when you modify the record type */
#define LIFETIME_NUM_FIELDS   19
struct  fileLifetimeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	int eventID;
	int fileID;
	int     nodeID;  
	int     dummy;    /* have to put dummy int here for alignment*/
	double fileLifetime;   /* file open end -> file close begin */
	double overhead;       /* file open time + file close time */
	int readFrequency;
	int readBytes;
        double readTime;
	int writeFrequency;
	int writeBytes;
        double writeTime;
	int seekFrequency;
	int seekBytes;
        double seekTime;
	int    mode;
	char   userData[256];  /* file name */
};



/* modify the field number when you modify the record type */
#define TIME_SUMMARY_NUM_FIELDS   18
struct  timeLifeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int     clockDimension;  /* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double  start;	        /* time window supposedly began */
	int closed;             /* flag recording whether this record was forced */
	int eventID;
	int nodeID;
	int fileID;
	int readFrequency;
	int readBytes;
        float readTime;
	int writeFrequency;
	int writeBytes;
        float writeTime;
	int seekFrequency;
	int seekBytes;
        float seekTime;
	int firstByteAccessed;
	int lastByteAccessed;
/*	int medianByte; */
};

/* modify the field number when you modify the record type */
#define SPACE_SUMMARY_NUM_FIELDS   17
struct   spaceSummaryRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	int	eventID;	/* ID of corresponding event		    */
	int closed;             /* flag recording whether this record 
	                           was forced */
	int nodeID;
	int fileID;
	int readCount;
	int readBytes;
        float readTime;
	int writeCount;
	int writeBytes;
        float writeTime;
	int seekCount;
	int seekBytes;
        float seekTime;
	int firstByteAccessed;
	int lastByteAccessed;
};


/* modify the field number when you modify the record type */
#define OPEN_NUM_FIELDS   9
struct   openRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double  duration;
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* node identifier */
	int     fileID;         /* file identifier */
	int     flags;          /* flags supplied to open */
	int     mode;           /* mode in which file is opened */
	char    userData[1024];  /* file name, mode, etc. */
};

/* modify the field number when you modify the record type */
#define HISTOGRAM_NUM_FIELDS  5
struct   histogramRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_HISTOGRAM | RECORD_TRACE       */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;
	int     histSize;
	/* now comes the histogram data */
};

/* modify the field number when you modify the record type */
#define CLOSE_NUM_FIELDS      6
struct   closeRecordData {
	int	packetLength;	/* bytes in packet			    */
	int	packetType;	/* == PKT_DATA				    */
	int	packetTag;	/* == FAMILY_SYNCRECV_END | RECORD_TRACE    */
	int	clockDimension;	/* number of ints in a CLOCK		    */
	CLOCK	timeStamp;	/* time record generated		    */
	double	seconds;	/* floating-point timestamp		    */
	double	duration;	/* time spent in close */
	int	eventID;	/* ID of corresponding event		    */
	int     nodeID;         /* Node (processor) ID */
	int     fileID;         /* file identifier */
};

/* Stuff below here are data structure definitions for the portable part of 
the I/O extensions */

struct slidingWindowData {
  double windowSize;
  double start;
  double finish;
};


struct slidingWindowData statisticalWindowData;

int GlobalBlockSize;

struct eventSummaryData {
  int frequency;
  int numBytes;
  int numVariables;
  double totalTime;
};

struct blockSummaryData {
  int bytePosition;
  int firstByte;
  int lastByte;
  int totalBytes;
  double lowTime;
  double hiTime;
  struct eventSummaryData readData;
  struct eventSummaryData seekData;
  struct eventSummaryData writeData;
};
#define EVENT_FREQUENCY(i)       (blockSDT[i]->readData.frequency + blockSDT[i]->seekData.frequency + blockSDT[i]->writeData.frequency)

#define MAX_OPEN_FILES  32

struct blockSummaryData *blockSDT[MAX_OPEN_FILES];
struct blockSummaryData  *timeSDT[MAX_OPEN_FILES];

struct histogramData {
  int active;    /* flag toggling output of different hist. types */
  double start;  /* time window histogram start */
  double windowSize; /* time window histogram windowsize */
  int *data;         /* the histogram data */
  int lo;            /* low threshhold */
  int hi;            /* hi threshhold */
  int binwidth;      /* bin width */
  int numbins;       /* number of bins */
};

#define OUTPUT_HISTOGRAM(h, ts)  (h.active && (ts > (h.start + h.windowSize)))
#define READ_SIZE_HIST    0000001
#define WRITE_SIZE_HIST   0000002


#define RS_HIST(m)   (((m)&READ_SIZE_HIST) == READ_SIZE_HIST)
#define WS_HIST(m)   (((m)&WRITE_SIZE_HIST) == WRITE_SIZE_HIST)

struct histogramData readHistogram;
struct histogramData writeHistogram;

TR_RECORD *fileLifetime[MAX_OPEN_FILES];


/* this is a nasty macro to make life with Swave a little easier. */

#ifndef SWAVE_IO

#define returnRecord(x)    return x;

#else

#define returnRecord(x)    if (produceOwnIOOutput){return x;}else {return nullRecordFunction();}

#endif

