/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Keith A. Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *
 */


#ifndef Pixmaps_h
#define Pixmaps_h

#define trace_width 16
#define trace_height 8
static char trace_bits[] = {
   0x00, 0x00, 0x00, 0x20, 0x0c, 0x60, 0x1e, 0xf8, 0x33, 0x6c, 0x61, 0x26,
   0xc0, 0x03, 0x80, 0x01};

#define count_width 16
#define count_height 8
static char count_bits[] = {
   0x08, 0x10, 0x08, 0x10, 0x08, 0x10, 0x7f, 0xfe, 0x08, 0x10, 0x08, 0x10,
   0x08, 0x10, 0x00, 0x00};

#define mixed_width 16
#define mixed_height 8
static char mixed_bits[] = {
   0x04, 0x20, 0x04, 0x20, 0x1f, 0xf8, 0x04, 0x20, 0x34, 0x2c, 0x60, 0x06,
   0xc0, 0x03, 0x80, 0x01};

#define null_width 16
#define null_height 8
static char null_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00};

#define lineSelected_width 16
#define lineSelected_height 8
static char lineSelected_bits[] = {
   0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x70,
   0x00, 0x38, 0x00, 0x1c};


#include "Main.h"

extern void buildPixmaps();
extern Pixmap getPixmapToUse();

#endif Pixmaps_h

