/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *          (R)
 * The Pablo    Performance Analysis Environment software is NOT in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * PABLO is a registered trademark of
 * The Board of Trustees of the University of Illinois
 * registered in the U.S. Patent and Trademark Office.
 *
 * Author:  Keith A. Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 *
 */


#ifndef HelpDialog_h
#define HelpDialog_h

#define FILE_HELP_TEXT "Load Source File\n  Used to load the C file that you wish to instrument.  A Motif\n  file selection dialog is used to browse through directories\n  and choose a file.\n\nEdit CPP Options\n  Used to modify the options that will be sent to the C\n  pre-processor (CPP) when the input file is loaded and parsed.\n  A dialog with an editable text field containing the current\n  CPP options is popped up.  These options may be edited and will\n  be the ones send to CPP the next time a file is loaded.  These\n  options may also be specified from the command line.  Currently\n  supported CPP options are -D -I and -U.\n\nGenerate Instrumented Source\n  Used to generate an instrumented C file along with supplemental\n  files to keep track of a file's instrumentation state.  The\n  current instrumentation state is used to define a new source file\n  that includes calls to the Pablo Instrumentation Library at\n  the points in the code where instrumentation was applied.\n\nQuit\n  Used to quit this program.  You will be asked to verify\n  quitting if the instrumentation state has changed since an\n  instrumented source file was last generated."

#define GLOBAL_HELP_TEXT "Calls\n  Used to instrument calls to routines in the source file.  A\n  sub menu allows you to indicate what form of instrumentation\n  should be applied.  The type of instrumentation applied determines\n  what sort of instrumentation records are produced when the\n  instrumented code is executed.  Trace records will simply\n  indicate that a particular routine call has been executed.\n  Count records will also give a running count of the number\n  of times a particular routine call has been executed.  Clear\n  causes any existing instrumentation points related to routine\n  calls to be removed.\n\nOuter Loops\n  Used to instrument outer loops in the source file.  A sub menu\n  allows you to indicate what form of instrumentation should be\n  applied.  The type of instrumentation applied determines what\n  sort of instrumentation records are produced when the\n  instrumented code is executed.  Trace records will simply\n  indicate that a particular outer loop has been executed.  Count\n  records will also give a running count of the number of times\n  a particular outer loop has been executed.  Clear causes any\n  existing instrumentation points related to  outer loops to be\n  removed.\n\nBoth\n  Allows the instrumentation of routine calls and outer loops\n  to be consolidated into a single step."

#define ROUTINE_HELP_TEXT "Calls To Selected Routine\n  Used to provide instrumentation at the point where the currently\n  selected routine is called.  A sub menu allows you to choose\n  what form of instrumentation will be applied.  The Trace All\n  and Count All sub menu options will cause trace or count\n  instrumentation records to be produced each time the selected\n  routine is called.  In addition, Instrument Subset allows you\n  to instrument a subset of calls to the currently selected\n  routine.  Clear All will clear all instrumentation points\n  associated with calls to the currently selected routine.\n\nCalls In Selected Routine\n  Used to instrument calls to routines made in the currently\n  selected routine.  A sub menu allows you to choose what form\n  of instrumentation will be applied. The Trace All and Count\n  All sub menu options will cause trace or count instrumentation\n  records to be produced each time the selected routine calls\n  another routine.  In addition, Instrument Subset allows you\n  to instrument a subset of calls made by the currently selected\n  routine.  Clear All will clear all instrumentation points\n  associated with calls made in the currently selected routine.\n\nOuter Loops Of Selected Routine\n  Used to instrument all outer loops in the currently selected\n  routine.  A sub menu allows you to choose what form of\n  instrumentation will be applied. The Trace All and Count All\n  sub menu options will cause trace or count instrumentation\n  records to be produced each time an outer loop in the selected\n  routine is executed.  Clear All will clear all instrumentation\n  points associated with outer loops of the currently selected\n  routine."

#define ROUTINE_LIST_HELP_TEXT "  The routine list, located just below the menu bar, provides\n  a list of all routines in the currently loaded source file.\n  This includes both calling and called routines.  The currently\n  selected routine on this list is the routine to which\n  instrumentation choices made from the Routine Menu will apply."

#define SOURCE_VIEWER_HELP_TEXT "  The source code viewer is used to manually instrument lines\n  of the source program.  The viewer shows all lines of the\n  source program and highlights those lines that contain constructs\n  that can currently be instrumented.  To the left of the viewer\n  are symbols indicating the currently selected line as well\n  as the instrumentation status of all instrumentable lines.\n  A line is selected simply by clicking on it with the left mouse\n  button.  To change the instrumentation status of the currently\n  selected line, press one the three buttons below the source\n  code viewer.  If the currently selected line has more than one\n  instrumentable construct, a dialog will pop up to allow\n  selective instrumentation of those constructs."


#define SUBSET_HELP_TEXT "  This dialog is popped up when you wish to apply instrumentation\n  to a subset of possible instrumentable structures.  Currently,\n  this dialog is used to instrument a subset of routines that\n  are called by or make calls to the currently selected routine\n  as well as to selectively instrument multiple instrumentable\n  structures on the same source code line.  A list at the top\n  of the dialog shows all things that you can instrument at this\n  point.  This will either be all routines called by the currently\n  selected routine, all routines that call the currently selected\n  routine, or all instrumentable structures found on the\n  currently selected line (if more than one exists).  Multiple\n  items on the list can be selected simultaneously.  Symbols next\n  to each item in the list will indicate the instrumentation\n  status of that item.  Below the list is a radio box that allows\n  you to select what sort of instrumentation will be applied.\n  Below this are two buttons that determine which part of the\n  list will have the chosen instrumentation applied.  Pressing\n  Selected will cause all selected list items to be instrumented\n  while pressing Except will cause all list items except the\n  selected ones to be instrumented."

#include "Main.h"

extern void generateHelp();

#endif HelpDialog_h

