#line 1 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991, 1992
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Xingbin Zhang (zhang@cs.uiuc.edu)
 * Contributing Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004, and
 * by a grant from the Digital Equipment Corporation External Research
 * Program.
 *
 */

/*
 * pdeNode.c:
 *	This file contains the node code for an iterative elliptic
 *	PDE solver, implemented for the Intel iPSC/2 and iPSC/860.
 */


#line 1 "/usr/include/math.h"
/*	@(#)math.h	4.2	(ULTRIX)	9/4/90	*/
/************************************************************************
 *									*
 *			Copyright (c) 1985 - 1989 by			*
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   This software is  derived  from  software  received  from  the	*
 *   University    of   California,   Berkeley,   and   from   Bell	*
 *   Laboratories.  Use, duplication, or disclosure is  subject  to	*
 *   restrictions  under  license  agreements  with  University  of	*
 *   California and with AT&T.						*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/
/************************************************************************
 *			Modification History				*
 *
 * 011	DECwest ANSI 8-jun-1990
 *	atof now defined always, not just if ! _POSIX_SOURCE.
 *									*
 * 010  Dan Smith, 1990 Feb 21                                          *
 *      Added const to atof prototype. Protect symbols not required     *
 *      for ANSI/POSIX/X-OPEN compliance.                               *
 *                                                                      *
 * 009	Reeves, 1989 Dec 07						*
 *	Namespace protection.						*
 *									*
 * 008	Reeves, 1989 Jul 14						*
 *	Add isnan, lgamma declarations for X/Open			*
 *									*
 * 007	Reeves, 1989 Jun 16						*
 *	Make HUGE_VAL more amenable to multiple definitions (limits.h	*
 *	needs it too).							*
 *									*
 * 006	Reeves, 1989 Jun 05						*
 *	Add HUGE_VAL for ANSI, strtod, atol for historical reasons	*
 *									*
 * 005	Reeves, 1988 Dec 14						*
 *	X/Open requires MAXFLOAT both places; add it back here with	*
 *	the right value.						*
 *									*
 * 004	Jon Reeves, 1988 Nov 16						*
 *	Fix MAXFLOAT collision with values.h				*
 *									*
 * 003	Jon Reeves, 1988 Sept 26					*
 *	Add MIPS definitions						*
 *									*
 * 002	Jon Reeves, 1988 March 07					*
 *	Delete if/endif pairs for other machines that gave vcc trouble. *
 *									*
 *	David L Ballenger, 28-Mar-1985					*
 * 0001 Add definitions for system V compatibility			*
 *									*
 ************************************************************************/



#line 1 "/usr/include/ansi_compat.h"
/*
 * 	@(#)ansi_compat.h	4.4	(ULTRIX)	10/8/90
 */

/************************************************************************
 *									*
 *			Copyright (c) 1990 by			        *
 *		Digital Equipment Corporation, Maynard, MA		*
 *			All rights reserved.				*
 *									*
 *   This software is furnished under a license and may be used and	*
 *   copied  only  in accordance with the terms of such license and	*
 *   with the  inclusion  of  the  above  copyright  notice.   This	*
 *   software  or  any  other copies thereof may not be provided or	*
 *   otherwise made available to any other person.  No title to and	*
 *   ownership of the software is hereby transferred.			*
 *									*
 *   The information in this software is subject to change  without	*
 *   notice  and should not be construed as a commitment by Digital	*
 *   Equipment Corporation.						*
 *									*
 *   Digital assumes no responsibility for the use  or  reliability	*
 *   of its software on equipment which is not supplied by Digital.	*
 *									*
 ************************************************************************/

/*
 *   To avoid namespace pollution when using the ULTRIX header files under the
 * DEC ANSI compiler, all user-visible header files were modifed to reference
 * ANSI-style predefined macro name rather than their traditional names
 * (__ultrix vice ultrix).  Every file which accesses a predefined macro name
 * must include this file before any other files are included or the macros
 * are tested.
 *
 *   In strict ANSI mode, the appropriate ANSI-style macros are already
 * defined and the redefinitions in this file will not be seen.  When using
 * pcc, the traditional macro names are defined and this file will define
 * ANSI-style equivalents of the traditional names.  When using the DEC C
 * compiler, both the traditional and ANSI predefined macro names are
 * available so the definitions in this file are not made visible.
 *
 */


















#line 63 "/usr/include/ansi_compat.h"


#line 67 "/usr/include/ansi_compat.h"














#line 83 "/usr/include/ansi_compat.h"


#line 87 "/usr/include/ansi_compat.h"


#line 91 "/usr/include/ansi_compat.h"


#line 95 "/usr/include/ansi_compat.h"






#line 106 "/usr/include/ansi_compat.h"


#line 110 "/usr/include/ansi_compat.h"


#line 114 "/usr/include/ansi_compat.h"



#line 72 "/usr/include/math.h"


extern int errno, signgam;


struct exception {
	int type;
	char *name;
	double arg1;
	double arg2;
	double retval;
};

#line 131 "/usr/include/math.h"


extern double atof(), frexp(), ldexp(), modf(), strtod();
extern double exp(), log(), log10(), pow(), sqrt();
extern double floor(), ceil(), fmod(), fabs();
extern double sinh(), cosh(), tanh();
extern double sin(), cos(), tan(), asin(), acos(), atan(), atan2();
extern long atol();

extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double erf(), erfc();
extern double gamma();
extern double lgamma();
extern double hypot();
extern int isnan();


extern int matherr();




/* some useful constants */















#line 178 "/usr/include/math.h"












/* These names are OK according to ANSI extension rules */



#line 194 "/usr/include/math.h"






















#line 79 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"


#line 1 "/home/reed/noe/Install/include/iPSCtrace.h"
/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1991-1993
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author:  Roger J. Noe (noe@cs.uiuc.edu)
 * Contributing Author:  Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR87-06653 and
 * NSF CDA87-22836 (Tapestry), DARPA Contract No. DABT63-91-K-0004,
 * by a grant from the Digital Equipment Corporation External Research
 * Program, and by a collaborative research agreement with the Intel
 * Supercomputer Systems Division.
 *
 */

/*
 * iPSCtrace.h:
 *	This is the include file for applications using the Intel
 *	iPSC system customization interface for the message-passing
 *	extensions to the Pablo trace library.
 */

/* Define the message passing extension trace event IDs.		    */













/* Define the miscellaneous (mesgBeginID/mesgEndID) operation subtypes.	    */
























/* Declare functions instrumenting the actual message-passing routines.	     */

extern long	traceCSEND(), traceCRECV(), traceISEND(), traceIRECV();

extern long	traceGCOL(), traceGCOLX(), traceGDHIGH(), traceGDLOW(),
		traceGDPROD(), traceGDSUM(), traceGIAND(), traceGIHIGH(),
		traceGILOW(), traceGIOR(), traceGIPROD(), traceGISUM(),
		traceGIXOR(), traceGLAND(), traceGLOR(), traceGLXOR(),
		traceGOPF(), traceGSENDX(), traceGSHIGH(), traceGSLOW(),
		traceGSPROD(), traceGSSUM();




/* Define macros to call these instrumented routines.			     */





























#line 194 "/home/reed/noe/Install/include/iPSCtrace.h"

#line 81 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"














				/* HAS NODE NUMBER ADDED TO IT		     */







int	Rows;			/* number of rows in grid		     */
int	ConvIter;		/* iterations between checks		     */
int	MaxIter;		/* iteration count for benchmark	     */
int	stripWidth;

long    myNode;
long    nNodes;
double  NodeCnt;
int	cubeDim;

float	**OldPartition;		/* partitions for jacobi iteration	     */
float	**NewPartition;		/* iterations				     */
float	**Partition;

extern long numnodes();
extern long mynode();
extern long myhost();
extern long gray();
extern long ginv();


_PabloParser_main_ () {
#line 124 "PabloParseCode.c"
	extern int	PabloTraceFlag;
	int _Iterate_ReturnValue_;
	int _IterateEdge_ReturnValue_;
	int _Convergence_ReturnValue_;
#line 124 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"

	int	Iter;			/* iteration number		     */
	int	midToUpper;		/* boundary condition transmission   */
	int	midToLower;		/* flags			     */
	int	GlobalConv;		/* global convergence flag	     */

	int	i;

	void InitGrid();


	iPSCtraceInit();


	Iter = 0;
	GlobalConv = 	0;

	myNode = mynode();
	nNodes = numnodes();
	NodeCnt = nNodes;
	cubeDim = (int)(log(NodeCnt) / log(2.0) + 0.5);

	/*
	 *
	 * Receive size information from host
	 *
	 */

		traceCRECV( 	2       , &Rows, sizeof(int) );
		traceCRECV( 0	, &MaxIter, sizeof(int) );
		traceCRECV( 1       , &ConvIter, sizeof(int) );
		traceCRECV( 3       , &stripWidth, sizeof(int) );

	/*
	 *
	 * Initialize the grid based on the partition width
	 *
	 */

	
#line 163 "PabloParseCode.c"
(PabloTraceFlag && PabloTraceProc(10, 15076, 163),
#line 163 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
InitGrid()
#line 163 "PabloParseCode.c"
, PabloTraceFlag && PabloTraceProc(11, 15086, 163))
#line 163 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
;			/* allocate the partition array      */

	/*
	 *
	 * Node 0 gets the top boundary of the entire grid and the last node
	 * in the gray code embedding gets the bottom boundary.
	 *
	 */

	if( myNode == 0 ) {

	   	traceCRECV( 4       , OldPartition[0],
	          (stripWidth + 1) * (Rows + 2) * sizeof(float) );

	   for (i = 0; i <= Rows + 1; i++)	    /* fixed boundary values */
	      NewPartition[0][i] = OldPartition[0][i];

	} else if (myNode == gray(nNodes - 1)) {

	   	traceCRECV( 4       , OldPartition[1],
		  (stripWidth + 1) * (Rows + 2) * sizeof(float) );

	   for (i = 0; i <= Rows + 1; i++)	    /* fixed boundary values */
	      NewPartition[stripWidth+1][i] = OldPartition[stripWidth+1][i];

	} else
	    	traceCRECV( 4       , OldPartition[1],
		   stripWidth * (Rows + 2) * sizeof(float) );

	/* Copy left and right boundary pts to carry them between iterations */
	for(i = 1; i <= stripWidth; i++) {
	    NewPartition[i][0] = OldPartition[i][0];
	    NewPartition[i][Rows+1] = OldPartition[i][Rows+1];
	}

	/*
	 *
	 * The formula gray((ginv(myNode) - 1 + nNodes) % nNodes is
	 * not used to calculate the upper node since the embedding is not
	 * a ring but a strip; hence, there's no wrap around. Similarly,
	 * a simplified formula is also used for lower node identifiers.
	 *
	 */

	
#line 207 "PabloParseCode.c"
{	if (PabloTraceFlag)	PabloCountLoop(32, 16397, 207);
#line 207 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
for (Iter = 1; (Iter <= MaxIter) && !GlobalConv; Iter++) {
	   if( myNode != 0 )
		midToUpper = 	traceISEND( 6	,
				    OldPartition[1],
				    (Rows + 2) * sizeof(float),
				    gray( ginv(myNode)-1), 	0	 );

	   if( myNode != gray(nNodes - 1) )
		midToLower = 	traceISEND( 5	,
				    OldPartition[stripWidth],
				    (Rows + 2) * sizeof(float),
				    gray( ginv(myNode)+1), 	0	 );

	   
#line 220 "PabloParseCode.c"
(PabloTraceFlag && PabloTraceProc(24, 16792, 220), _Iterate_ReturnValue_ =
#line 220 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
Iterate()
#line 220 "PabloParseCode.c"
, PabloTraceFlag && PabloTraceProc(25, 16801, 220), _Iterate_ReturnValue_)
#line 220 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
;			/* update grid interior points	     */

	  /*
	   *
	   * Retrieve the boundary points
	   *
	   */

	  if( myNode != gray(nNodes - 1) )
	     	traceCRECV( 6	, OldPartition[stripWidth + 1],
		    (Rows + 2) * sizeof(float) );

	  if( myNode != 0 )
	     	traceCRECV( 5	, OldPartition[0],
		    (Rows + 2) * sizeof(float) );

	   
#line 236 "PabloParseCode.c"
(PabloTraceFlag && PabloTraceProc(26, 17134, 236), _IterateEdge_ReturnValue_ =
#line 236 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
IterateEdge()
#line 236 "PabloParseCode.c"
, PabloTraceFlag && PabloTraceProc(27, 17147, 236), _IterateEdge_ReturnValue_)
#line 236 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
;		/* Update the two partition edges    */

	  /*
	   *
	   * Check for global convergence using logarithmic condensation
	   *
	   */

	   GlobalConv = 
#line 244 "PabloParseCode.c"
(PabloTraceFlag && PabloTraceProc(28, 17300, 244), _Convergence_ReturnValue_ =
#line 244 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
Convergence(Iter)
#line 244 "PabloParseCode.c"
, PabloTraceFlag && PabloTraceProc(29, 17317, 244), _Convergence_ReturnValue_)
#line 244 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
;

	   Partition = NewPartition;    /* swap the partitions		     */
	   NewPartition = OldPartition;
	   OldPartition = Partition;

	   if (myNode != 0)
	     msgwait( midToUpper );

	   if (myNode != gray(nNodes - 1))
	     msgwait( midToLower );

	 }
#line 256 "PabloParseCode.c"
	if (PabloTraceFlag)	PabloCountLoop(33, 17569, 256);}
#line 256 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"


	/*
	 *
	 * Iterations complete.  Send the partition back to the host
	 *
	 */

	if ( myNode == 0 )
			traceCSEND( nNodes + 1, &Iter, sizeof(int), myhost(), 	1	 );

		traceCSEND( myNode, OldPartition[1],
	       stripWidth * (Rows + 2) * sizeof(float),
	       myhost(), 	1	 );
}


/************************************************************************/
/*									*/
/*	Procedure:	InitGrid					*/
/*	Function:	Initializes parameters for PDE solver		*/
/*	Author:		Daniel A. Reed					*/
/*	Last Change:	11/9/87						*/
/*									*/
/*	Parameters:	None (globals modified)				*/
/*									*/
/************************************************************************/

void InitGrid() {
#line 284 "PabloParseCode.c"
	extern int	PabloTraceFlag;
#line 284 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"


	int	i, j;

	OldPartition = (float **) malloc ((stripWidth + 2) * sizeof (float *));
	NewPartition = (float **) malloc ((stripWidth + 2) * sizeof (float *));

	OldPartition [0] = (float *)
		malloc ((stripWidth + 2) * (Rows + 2) * sizeof (float));
	NewPartition [0] = (float *)
		malloc ((stripWidth + 2) * (Rows + 2) * sizeof (float));

	for (i = 1; i <= stripWidth + 1; i++) {
	   OldPartition [i] = OldPartition [0] + i * (Rows + 2);
	   NewPartition [i] = NewPartition [0] + i * (Rows + 2);
	}
}


/************************************************************************/
/*									*/
/*    Procedure:	Converged					*/
/*    Function:		Determine convergence				*/
/*    Author:		Daniel Reed					*/
/*    Last change:	11/19/87					*/
/*									*/
/*    Output:	TRUE  - the current approximation has converged		*/
/*		FALSE - the current approximation has not converged	*/
/*									*/
/************************************************************************/

Converged (Iter)

	int	Iter;
{
#line 318 "PabloParseCode.c"
	extern int	PabloTraceFlag;
#line 318 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"

	int	i, j;

	for (i = 1; i <= stripWidth; i++)
	   for (j = 1; j <= Rows; j++)
	      if (fabs (OldPartition [i][j] - NewPartition [i][j]) > 	1e-5)
		 return (	0);

	return (	1);
}


/************************************************************************/
/*                                                                      */
/*      Procedure:      Convergence                                     */
/*      Function:       global convergence checking                     */
/*      Authors:        Daniel A. Reed                                  */
/*			Xingbin Zhang					*/
/*      Last Change:    5/6/92                                          */
/*									*/
/************************************************************************/

int Convergence(Iter)

	int	Iter;
{
#line 343 "PabloParseCode.c"
	extern int	PabloTraceFlag;
	int _Converged_ReturnValue_;
#line 343 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"

	int	GlobalConv;
	int	tempConv;

	int	i;
	int	cDim;

	/*
	 *
	 * Check for global convergence using logarithmic condensation
	 *
	 */

	if ((Iter % ConvIter) == 0) {

	  GlobalConv = 
#line 358 "PabloParseCode.c"
(PabloTraceFlag && PabloTraceProc(48, 20228, 358), _Converged_ReturnValue_ =
#line 358 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
Converged (Iter)
#line 358 "PabloParseCode.c"
, PabloTraceFlag && PabloTraceProc(49, 20244, 358), _Converged_ReturnValue_)
#line 358 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"
;		/* local convergence */

	  if ( myNode == 0 ) {

		/*
	         *
		 * Node 0 receives in total cube dimension number of messages
		 * containing intermediate convergence results, computes the
		 * AND of them, and redistribute them to all other nodes
		 * logarithmically.
		 *
		 */


		for (i = 0; i < cubeDim; i++) {
		   	traceCRECV( 8	 + (1 << i), &tempConv, sizeof(int) );

		   GlobalConv = GlobalConv && tempConv;
		}

		for (i = cubeDim - 1; i >= 0; i--)
		   	traceCSEND( 7	, &GlobalConv, sizeof(int),
			  1 << i, 	0	 );
	      }
	      else {

		/*
		 *
		 * Receive all the intermediate results for this node
		 *
		 */

		cDim = 0;

		while( (myNode >> cDim) % 2 == 0) {
		   	traceCRECV( 8	 + (((myNode >> cDim)+1) << cDim),
			  &tempConv, sizeof(int) );

		   GlobalConv = GlobalConv && tempConv;
		   cDim++;
		}

		/*
		 *
		 * Send the total result "up"
		 *
		 */

			traceCSEND( 8	 + myNode, &GlobalConv, sizeof(int),
		       ((myNode >> cDim) - 1) << cDim, 	0	 );

		/*
		 *
		 * Receive the new global convergence result
		 *
		 */

			traceCRECV( 7	, &GlobalConv, sizeof(int) );

		/*
		 *
		 * Redistribute the global result to other nodes
		 *
		 */

		for(i = cDim - 1; i >= 0; i--) {
		   	traceCSEND( 7	, &GlobalConv, sizeof(int),
			  ((myNode >> i) + 1) << i, 	0	 );
		}
	     }
	  } else
	     GlobalConv = 	0;

	return( GlobalConv );
}


/************************************************************************/
/*									*/
/*	Procedure:	Iterate						*/
/*	Function:	Jacobi iteration				*/
/*	Author:		Daniel A. Reed					*/
/*	Last Change:	1/7/88						*/
/*	Modified so that the procedure updates only the internal points	*/
/*		of the grid and does one iteration;			*/
/************************************************************************/

Iterate()
{
#line 446 "PabloParseCode.c"
	extern int	PabloTraceFlag;
#line 446 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"

	int    i,j;

	for (i = 2; i <= stripWidth - 1; i++) {
	   for (j = 1; j <= Rows; j++) {
	      NewPartition [i][j] =
		0.25 * (OldPartition [i-1][j] + OldPartition [i][j+1] +
			OldPartition [i+1][j] + OldPartition [i][j-1]);
	   }
	}
}




/************************************************************************/
/*									*/
/*	Procedure:	IterateEdge					*/
/*	Function:	Jacobi iteration				*/
/*	Updates the boundary points of the strip once;			*/
/*									*/
/************************************************************************/

IterateEdge()
{
#line 470 "PabloParseCode.c"
	extern int	PabloTraceFlag;
#line 470 "/import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c"

	int    i,j;

	/* upper boundary */
	i = 1;
	for (j = 1; j <= Rows; j++) {
	      NewPartition [i][j] =
		0.25 * (OldPartition [i-1][j] + OldPartition [i][j+1] +
			OldPartition [i+1][j] + OldPartition [i][j-1]);
	}

	/* lowerboundary (if stripWidth = 1 then row 1 computed twice */
	i = stripWidth;
	for (j = 1; j <= Rows; j++) {
	      NewPartition [i][j] =
		0.25 * (OldPartition [i-1][j] + OldPartition [i][j+1] +
			OldPartition [i+1][j] + OldPartition [i][j-1]);
	}
}
