

/*
 * The main function below was created by the
 * Pablo Performance Analysis Environment's
 * instrumenting parser.  When linked with
 * other code that was instrumented by this
 * parser, and with the Pablo trace capture
 * library and extensions, it will perform
 * trace capture library initialization before
 * invoking the original main function supplied
 * in the input code.
 *
 * Set PabloTraceFlag to zero to deactivate the
 * instrumenting code.  A nonzero value will
 * reactivate the instrumenting code.
 */

int	PabloTraceFlag = 1;

main(argc, argv, envp)
int	argc;
char	**argv, **envp;
{
	int	returnValue;

	static int	procEntryIDs[18] = {
		48,	/* Converged	*/
		42,	/* fabs	*/
		38,	/* malloc	*/
		36,	/* traceCSEND	*/
		34,	/* myhost	*/
		30,	/* msgwait	*/
		28,	/* Convergence	*/
		26,	/* IterateEdge	*/
		24,	/* Iterate	*/
		22,	/* traceISEND	*/
		20,	/* ginv	*/
		14,	/* gray	*/
		10,	/* InitGrid	*/
		8,	/* traceCRECV	*/
		6,	/* log	*/
		4,	/* numnodes	*/
		2,	/* mynode	*/
		0,	/* iPSCtraceInit	*/
		};
	static int	procExitIDs[18] = {
		49,	/* Converged	*/
		43,	/* fabs	*/
		39,	/* malloc	*/
		37,	/* traceCSEND	*/
		35,	/* myhost	*/
		31,	/* msgwait	*/
		29,	/* Convergence	*/
		27,	/* IterateEdge	*/
		25,	/* Iterate	*/
		23,	/* traceISEND	*/
		21,	/* ginv	*/
		15,	/* gray	*/
		11,	/* InitGrid	*/
		9,	/* traceCRECV	*/
		7,	/* log	*/
		5,	/* numnodes	*/
		3,	/* mynode	*/
		1,	/* iPSCtraceInit	*/
		};

	static int	iterEntryIDs[15] = {
			/* /import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c	*/
		64,
		62,
		60,
		58,
		56,
		54,
		52,
		50,
		46,
		44,
		40,
		32,
		18,
		16,
		12,
		};
	static int	iterExitIDs[15] = {
			/* /import/Bongo/reed/noe/Pablo/Instrument/Parser/Examples/PDE/pdeNode.c	*/
		65,
		63,
		61,
		59,
		57,
		55,
		53,
		51,
		47,
		45,
		41,
		33,
		19,
		17,
		13,
		};
	char	traceFile[32];		/* instrumentation trace file name   */

	sprintf( traceFile, "Jacobi%d.bin", mynode() );
	setTraceFileName( traceFile );

	preInitProcTrace();
	preInitLoopTrace();
	initProcTrace( 18, procEntryIDs, procExitIDs );
	initLoopTrace( 15, iterEntryIDs, iterExitIDs );

	if (argc >= 2) {
		if (strcmp(argv[1], "-trace") == 0) {
			PabloTraceFlag = 1;
			argc--;
			argv[1] = argv[0];
			argv++;
		} else if (strcmp(argv[1], "-notrace") == 0) {
			PabloTraceFlag = 0;
			argc--;
			argv[1] = argv[0];
			argv++;
		}
	}

	returnValue = _PabloParser_main_( argc, argv, envp );

	endTracing();
	return returnValue;
}
