.TH "XYGraph" "3-PerfW" "January 30, 1991" "Version 1.1" "Performance Widgets"
.ad b
.ne 4
.SH NAME
XYGraph \- A xy-plot widget
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNcolors:Pixel*:NULL:graph colors
XtNconnect:Boolean:FALSE:connect graph points
XtNfont:XFontStruct*:"fixed":font
XtNgridColor:Pixel:"black":grid color
XtNautoscale:Boolean:TRUE:automatically compute graph scales
XtNmarkersize:int:4:size of points when drawn
XtNminx:int:0:minimum graph X value (when autoscale FALSE)
XtNminy:int:0:minimum graph Y value (when autoscale FALSE)
XtNminy:int:100:maximum graph X value (when autoscale FALSE)
XtNminy:int:100:maximum graph X value (when autoscale FALSE)
XtNlogx:Boolean:FALSE:log x axis
XtNlogy:Boolean:FALSE:log y axis
XtNnumColors:int:0:number of value colors
XtNshowRange:Boolean:FALSE:show graph range
XtNshowTicks:Boolean:FALSE:show graph ticks
XtNtextColor:Pixel:"black":text color
XtNtitle:char*:NULL:title
XtNvaluecnt:int*:NULL:number of points per line
XtNxticks:int:10:number of x ticks
XtNxvalues:int*:NULL:graph xvalues
XtNxygraphCnt:int:1:number of lines in point set
XtNyticks:int:10:number of graph y ticks
XtNyvalues:int*:NULL:graph yvalues
XtNselect:XtCallbackList:NULL:callbacks for graph selection
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records x and y position of mouse 
notify:invokes the graph select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
void XYGraphSetValues(w, xvalues, yvalues, ptcnt, lines)
XYGraphWidget w;
int *xvalues;
int *yvalues;
int *ptcnt;
int lines;
.fi
.sp
XYGraphSetValues() sets the X and Y values using the array pointers
xvalues and yvalues.
Lines specifies the number of distinct lines to be displayed,
and ptcnt specifies the number of points in each line. 
The xy-plot display is automatically updated.
.sp
.ne 4
.SH INHERITABLE FUNCTIONS
.br
None.
.ne 4
.SH DESCRIPTION
.br
The \fBXYGraph\fR widget manages a rectangular X-Y plot display.
The specified points are plotted in the display after optionally
being logged (base 10).
A set of tick marks are drawn to delimit (x,y) values, if enabled.
A title appears at the top of the xy-plot, if given.
Similarly, a range of xy-plot values is shown at the bottom of the
xy-plot, if enabled.
.PP
A callback is supported.  When the left mouse button is
clicked, the mouse coordinates are returned to any registered callbacks.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
None are planned.
.ne 4
.SH AUTHOR
.br
.nf
Daniel Reed, \fIreed@oboe.cs.uiuc.edu\fR
Department of Computer Science
University of Illinois
.fi
