.TH "Piechart" "3-PerfW" "February 16, 1991" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
Piechart \- A pie chart widget.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNcolors:Pixel*:NULL:fill colors
XtNentries:int:0:number of pie chart entries
XtNgridColor:Pixel:"black":grid color separating entries
XtNmaxValue:int:100:maximum array value
XtNminValue:int:0:minimum array value
XtNnumColors:int:0:number of fill colors
XtNnumPixmaps:int:0:number of fill pixmaps
XtNpixmaps:Pixmap*:NULL:fill pixmaps
XtNselect:XtCallbackList:NULL:callback for pie chart selection
XtNshowGrid:Boolean:FALSE:show pie chart grid
XtNvalues:float*:NULL:pie chart values
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records row and column for selected cell
notify:invokes the pie chart select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBPiechartSetValues\fR(w, v)
PiechartWidget w;	/* pie chart widget */
int *v;	/* two-dimensional array of values */
	/* minvalue <= v[] <= maxvalue */
.fi
.sp
PiechartSetValues() sets the values array to v.
The pie chart display is automatically updated.
.sp
.nf
void \fBPiechartSetValue\fR(w, e, v)
PiechartWidget w;	/* pie chart widget */
int e;	/* entry */
int v;	/* minvalue <= v <= maxvalue */
.fi
.sp
PiechartSetValue() sets the value of the pie chart element
at element e to v.
The pie chart display is automatically updated.
.sp
.nf
void \fBPiechartSetColors\fR(w, n, c)
PiechartWidget w;	/* pie chart widget */
int n;	/* number of colors */
Pixel *c;	/* array of colors */
.fi
.sp
PiechartSetColor() sets the number of fill colors
to n and the fill colors to the first n in c[].
.sp
.nf
void \fBPiechartSetPixmap\fR(w, n, p)
PiechartWidget w;
int n;
Pixmap *p;
.fi
.sp
PiechartSetPixmap() sets the number of fill pixmaps
to n and the fill pixmaps to the first n in p[].
.ne 4
.SH DESCRIPTION
.br
The \fBPiechart\fR widget manages a circular pie chart display
of the specified number of entries; a maximum of sixty four (64) entries
are possible.
The user sets the minimum and maximum values the pie chart will show.
Pie chart values must be in this range.
The array values are linearly mapped to a color (pixmap) table and the
corresponding pie chart element is shown filled by with the mapped
color (pixmap).
A grid is drawn to separate the pie chart elements, if enabled.
.PP
Pie chart element selection is supported throught the XtNselect callback
resource.
The user-supplied callback routine is returned the
value of the pie chart element at the current mouse position.
.ne 4
.SH FUTURE ENHANCEMENTS
.br
Additional callbacks may be provided in the future for region selection.
.ne 4
.SH AUTHOR
.br
.nf
Daniel A. Reed, \fIreed@oboe.cs.uiuc.edu\fR
Department of Computer Science
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
