/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/interval/Demo/RCS/multiintervalpixmap.c,v 1.5 1994/02/25 04:46:32 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>

#include "Interval.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN		50
#define MAX		500
#define INTERVALS		8
#define PADDING 	2
#define NUMINTERVALS	5
#define INTERVALWIDTH	500
#define INTERVALHEIGHT	20

#define BITMAPNUM	10	
Pixmap	pixmaps[BITMAPNUM];
#define COLORNUM	14
Pixmap	pixels[COLORNUM];

int	low[NUMINTERVALS][INTERVALS];
int	high[NUMINTERVALS][INTERVALS];
int	colorindex[NUMINTERVALS][INTERVALS];

Widget	interval[NUMINTERVALS];

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

void main(argc, argv)
int argc;
char **argv;
{
  int		i, j, argi;
  int		total;
  Widget	top, form;
  Arg		arglist[10];
  XEvent	event;

  top = XtInitialize("main", "XINTERVAL", NULL, 0, &argc, argv);

  argi = 0;
  SetArg(XtNborderWidth, 1);
  SetArg(XtNdefaultDistance, 0);
  form = XtCreateManagedWidget("", formWidgetClass, top,
			       arglist, argi);
  
  for (i=0; i<NUMINTERVALS; i++) {
    argi = 0;
    SetArg(XtNwidth, INTERVALWIDTH);
    SetArg(XtNheight, INTERVALHEIGHT);
    SetArg(XtNminValue, MIN);
    SetArg(XtNmaxValue, MAX);
    SetArg(XtNorientation, XtorientHorizontal);
    SetArg(XtNtop, XtRubber);
    SetArg(XtNbottom, XtRubber);
    SetArg(XtNleft, XtChainLeft);
    SetArg(XtNright, XtChainRight);
    SetArg(XtNfromVert, NULL);
    SetArg(XtNvertDistance, i*(INTERVALHEIGHT+1));
    SetArg(XtNfromHoriz, NULL);
    SetArg(XtNhorizDistance, 0);
    SetArg(XtNselect, selectcallback);

    interval[i] = XtCreateManagedWidget("INTERVAL", intervalWidgetClass,
				     form, arglist, argi);
  }
  XtRealizeWidget(top);

  genpix(XtDisplay(top), XtScreen(top));
  for (i=0; i<NUMINTERVALS; i++) {
    IntervalSetPixmaps(interval[i], BITMAPNUM, pixmaps);
    total = 0;
    for (j=0; j<INTERVALS; j++) {
      high[i][j] = random() % 100;
      total += high[i][j];
    }
    for (j=0; j<INTERVALS; j++) {
      if (j==0)
	low[i][j] = MIN;
      else
	low[i][j] = high[i][j-1];
      if (j==(INTERVALS-1))
	high[i][j] = MAX;
      else
	high[i][j] = (low[i][j] +
		      (MAX - MIN) * ((float) high[i][j] / (float) total));
      colorindex[i][j] = -(j+1);
    }
    IntervalSetIntervals(interval[i], INTERVALS, low[i], high[i],
			 colorindex[i]);
  }

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
    sleep(1);
    for (i=0; i<NUMINTERVALS; i++) {
      total = 0;
      for (j=0; j<INTERVALS; j++) {
	high[i][j] = random() % 100;
	total += high[i][j];
      }
      for (j=0; j<INTERVALS; j++) {
	if (j==0)
	  low[i][j] = MIN;
	else
	  low[i][j] = high[i][j-1];
	if (j==(INTERVALS-1))
	  high[i][j] = MAX;
	else
	  high[i][j] = (low[i][j] +
			(MAX - MIN) * ((float) high[i][j] / (float) total));
	colorindex[i][j] = -(j+1);
      }
      IntervalSetIntervals(interval[i], INTERVALS, low[i], high[i],
			   colorindex[i]);
    }
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value = %d\n", value);

} /* Select */
