.TH "HistoryDial" "3-PerfW" "Jan. 1, 1990" "Version 1.0" "Performance Widgets"
.ad b
.ne 4
.SH NAME
HistoryDial \- A dial widget with history.
.ne 4
.SH CLASS HIERARCHY
.br
Core
.ne 4
.SH NEW RESOURCES
.br
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNfaceBorderColor:Pixel:"black":face border color
XtNfaceColor:Pixel:"white":face color
XtNhistory:int:0:depth of dial history
XtNhistoryColors:Pixel*:NULL:history colors
XtNmaxValue:int:100:maximum value
XtNminValue:int:0:minimum value
XtNneedleColor:Pixel:"black":needle color
XtNnumhistoryColors:int:0:number of history colors
XtNtickColor:Pixel:"black":tick color
XtNvalue:int:0:needle value (minvalue - maxvalue)
XtNselect:XtCallbackList:NULL:callbacks for history dial selection
.TE
.ne 4
.SH TRANSLATIONS
.br
.TS
tab(:);
l l.
<Btn1Down>:select()
<Btn1Up>:notify()
.TE
.ne 4
.SH ACTIONS
.br
.TS
tab(:);
l l.
select:records current dial value
notify:invokes the dial select callbacks
.TE
.ne 4
.SH PUBLIC FUNCTIONS
.br
.nf
.ta 3i
void \fBHistoryDialSetValue\fR(w, v)
HistoryDialWidget w;
int v;
.fi
.sp
HistoryDialSetValue() sets the current value of the history dial to v.
The history dial display is automatically updated.
.sp
.nf
void \fBHistoryDialSetHistoryColors\fR(w, n, c)
HistoryDialWidget w;
int n;
Pixel *c;
.fi
.sp
HistoryDialSetHistoryColors() creates colors to be used to show
dial position history.
The colors are in order of newer to older.
.ne 4
.SH DESCRIPTION
.br
The \fBHistoryDial\fR widget manages a circular display of a dial.
A needle is drawn to show the current value of the dial where
the minimum value is at 12 o'clock and values increase clockwise
on the dial.
The user sets the minimum and maximum values the dial will show.
Dial values must be in this range.
Tick marks are shown on the dial (default 100) with major ticks every
5 ticks.
.PP
The distinguishing feature of the \fBHistoryDial\fP widget is its ability
to show needle position history.
The amount of history and the colors to use are given as resources.
For example, these can be set to show older needle positions fading
out and eventually disappearing.
.PP
There are color resources for all components of the dial.
.PP
Clicking the left mouse button on a dial invokes a callback function
with the current value of the dial. 
.ne 4
.SH FUTURE ENHANCEMENTS
.br
The following resources will be added in the future:
.sp
.TS
tab(:);
lB lB lB lB.
Name:Type:Default:Description
.T&
lB l l l.

XtNbeginDegree:int:0:beginning degree
XtNendDegree:int:360:ending degree
XtNclockwise:Boolean:TRUE:clockwise rotation
XtNnumTicks:int:100:number of ticks
XtNmajorTick:int:5:ticks per major tick
.TE
.sp
The history will be specified by an arc of the full circle given by a
beginning degree and an ending degree.
Clockwise rotation indicates that increasing values will be
shown in clockwise order.
The number of ticks and the ticks per major tick will be settable.
.PP
An additional callback may be supported in the future.
Clicking the middle mouse button will set the dial value to that
value closest to the mouse position and call any registered callbacks.
.ne 4
.SH AUTHOR
.br
.nf
Allen Malony, \fImalony@csrd.uicsrd.uiuc.edu\fR
Center for Supercomputing Research and Development,
University of Illinois
.fi
.ne 4
.SH COMMENTS
All comments and suggestions should be directed to the author.
