/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/gantt/Demo/RCS/multigantt.c,v 1.5 1994/02/25 04:46:03 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Form.h>
#include <X11/Xaw/Label.h>

#include "Gantt.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN	0
#define MAX	100

#define COLORNUM	8
Pixel	pixels[COLORNUM];

#define NUMGANTTS 8
#define GANTTWIDTH 40
#define GANTTHEIGHT 200
#define PADDING 2

static XrmOptionDescRec options[] = {
  {"-xticks",	"*gantt.xticks",	XrmoptionSepArg,	NULL},
  {"-yticks",	"*gantt.yticks",	XrmoptionSepArg,	NULL},
};

static void Select();

static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

Syntax(call)
char *call;
{
  printf("Usage: %s", call);
  printf("\t-xticks <number>\n");
  printf("\t-yticks <number>\n");
  exit(1);

} /* Syntax */

Widget	gantts[NUMGANTTS];

void main(argc, argv)
int	argc;
char	**argv;
{
  int		i, j, argi;
  int		x[NUMGANTTS][100], y[NUMGANTTS][100];
  Widget	top, gantt;
  Arg		arglist[25];
  XEvent	event;

  /* create top level widget */

  top = XtInitialize("MultiGantt", "MultiGantt", options,
		     XtNumber(options), &argc, argv);

  if (argc != 1)
    Syntax(argv[0]);

  /* create gantt chart container */
  argi = 0;
  SetArg(XtNborderWidth, 1);
  SetArg(XtNdefaultDistance, 0);
  SetArg(XtNwidth, 400);
  SetArg(XtNheight, 100);
  gantt = XtCreateManagedWidget("", formWidgetClass, top,
				arglist, argi);

  gencolor(XtDisplay(top), XtScreen(top), COLORNUM);
  
  for (i=0; i<NUMGANTTS; i++) {
    argi = 0;
    SetArg(XtNwidth, GANTTWIDTH);
    SetArg(XtNheight, GANTTHEIGHT);
    SetArg(XtNorientation, XtorientVertical);
    SetArg(XtNborderWidth, 1);
    SetArg(XtNxmin, 1);
    SetArg(XtNxmax, 100);
    SetArg(XtNymin, 1);
    SetArg(XtNymax, 100);
    SetArg(XtNtop, XtChainTop);
    SetArg(XtNbottom, XtChainBottom);
    SetArg(XtNleft, XtRubber);
    SetArg(XtNright, XtRubber);
    SetArg(XtNfromVert, NULL);
    SetArg(XtNvertDistance, PADDING);
    SetArg(XtNfromHoriz, NULL);
    SetArg(XtNselect, selectcallback);
    SetArg(XtNhorizDistance, i*GANTTWIDTH + (i+1)*PADDING);

    gantts[i] = XtCreateManagedWidget("gantt", ganttWidgetClass,
				      gantt, arglist, argi);

    GanttSetColorMap(gantts[i], COLORNUM, pixels);
  }

  XtRealizeWidget(top);

  for (i=0; i<NUMGANTTS; i++) {
    for (j=0; j<100; j++) {
      x[i][j] = j+1;
      y[i][j] = (random() % 100) + 1;
    }
    GanttAddLine(gantts[i], i, 100, i, x[i], y[i]);
    GanttShowGantt(gantts[i]);
  }

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }
    sleep(1);

    for (i=0; i<NUMGANTTS; i++) {
      GanttUnMapLine(gantts[i], i);

      for (j=0; j<100; j++) {
	x[i][j] = j+1;
	y[i][j] = (random() % 100) + 1;
      }

      GanttDeleteLine(gantts[i], i);
      GanttAddLine(gantts[i], i, 100, i, x[i], y[i]);
      GanttShowGantt(gantts[i]);
    }
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data;
caddr_t call_data;
{
  int	i;

  CoordinateLoc *xy = (CoordinateLoc *) call_data;
  
  printf("Callback:  Line = %d x = %d  y = %d\n", xy->lid, xy -> x, xy -> y);

} /* Select */
