/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/coloredit/RCS/ColorEdit.c,v 1.7 1994/02/25 04:45:44 aydt Exp $
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/Xaw/FormP.h>
#include <X11/Xaw/ScrollbarP.h>
#include <X11/Xaw/LabelP.h>
#include <X11/Xaw/CommandP.h>
#include "ColorEditP.h"

#define offset(field)		XtOffset(ColorEditWidget, field)
#define Set_Arg(r, v)		XtSetArg(arglist[argi], r, v); argi++

#define RED	0
#define GREEN	1
#define BLUE	2

/**********************/
/* private procedures */
/**********************/
static void		Initialize(), Destroy(), ConstraintInitialize();
static void		JumpCallback(), OkCallback();
static long		RequestColor();
static Boolean		SetValues();

static XColor	mix;

/***********************/
/* coloredit resources */
/***********************/
static XtResource resources[] = {
  /* core resources */
  {XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
     offset(core.width), XtRString, "200"},
  {XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
     offset(core.height), XtRString, "200"},
  {XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
     offset(coloredit.callbacks), XtRCallback, (caddr_t) NULL},
};

/**************************/
/* coloredit class record */
/**************************/
ColorEditClassRec colorEditClassRec = {
  { /***************/
    /* core fields */
    /***************/
    (WidgetClass) &formClassRec,	/* superclass			*/
    "ColorEdit",			/* class_name			*/
    sizeof(ColorEditRec),		/* size				*/
    NULL,				/* class_initialize		*/
    NULL,				/* class_part_initialize	*/
    FALSE,				/* class_inited			*/
    Initialize,				/* initialize			*/
    NULL,				/* initialize_hook		*/
    XtInheritRealize,			/* realize			*/
    NULL,				/* actions			*/
    0,					/* num_actions			*/
    resources,				/* resources			*/
    XtNumber(resources),		/* resource_count		*/
    NULLQUARK,				/* xrm_class			*/
    TRUE,				/* compress_motion		*/
    TRUE,				/* compress_exposure		*/
    TRUE,				/* compress_enterleave		*/
    FALSE,				/* visible_interest		*/
    Destroy,				/* destroy			*/
    XtInheritResize,			/* resize			*/
    XtInheritExpose,			/* expose			*/
    NULL,				/* set_values			*/
    NULL,				/* set_values_hook		*/
    XtInheritSetValuesAlmost,		/* set_values_almost		*/
    NULL,				/* get_values_hook		*/
    NULL,				/* accept_focus			*/
    XtVersion,				/* version			*/
    NULL,				/* callback_private		*/
    NULL,				/* tm_table			*/
    XtInheritQueryGeometry,		/* query_geometry		*/
    XtInheritDisplayAccelerator,	/* display_accelerator		*/
    NULL,				/* extension			*/
  },
  { /**************************/
    /* composite_class fields */
    /**************************/
    XtInheritGeometryManager,		/* geometry_manager		*/
    XtInheritChangeManaged,		/* change_manged		*/
    XtInheritInsertChild,		/* insert_child			*/
    XtInheritDeleteChild,		/* delete_child			*/
    NULL,				/* extension			*/
  },
  { /***************************/
    /* constraint_class fields */
    /***************************/
    NULL,				/* subresourses			*/
    0,					/* subresource_count		*/
    sizeof(ColorEditConstraintsRec),	/* constraint_size		*/
    ConstraintInitialize,		/* initialize			*/
    NULL,				/* destroy			*/
    NULL,				/* set_values			*/
    NULL,				/* extension			*/
  },
  { /*********************/
    /* form_class fields */
    /*********************/
    XtInheritLayout,			/* layout			*/
  },
  { /**************************/
    /* coloredit_class fields */
    /**************************/
    0,					/* empty			*/
  }
};

WidgetClass	colorEditWidgetClass = (WidgetClass) &colorEditClassRec;

/**********************************/
/* coloredit jump callback record */
/**********************************/
static XtCallbackRec jump_callback[] = {
  {JumpCallback, NULL},
  {NULL, NULL},
};

/****************************************/
/* coloredit ok command callback record */
/****************************************/
static XtCallbackRec ok_callback[] = {
  {OkCallback, NULL},
  {NULL, NULL},
};

/************************************************************************/
/*                          PRIVATE PROCEDURES                          */
/************************************************************************/

/************************************************************************/
/* JumpCallback()							*/
/************************************************************************/
static void JumpCallback(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  char			string[20];
  int			i, argi, mixvalue, which = (int) client_data;
  int			width, height;
  float			*percent = (float *) call_data;
  Arg			arglist[10];
  ColorEditWidget	parent = (ColorEditWidget) XtParent(w);

#ifdef DEBUG
printf("JumpCallback\n");
#endif
  mixvalue = (int) ((1.0 - *percent) * 256.0 * 256.0);
  if (mixvalue > 0xFFFF)
    mixvalue = 0xFFFF;

  switch (which) {
  case RED:
    mix.red = mixvalue;
    break;
  case GREEN:
    mix.green = mixvalue;
    break;
  case BLUE:
    mix.blue = mixvalue;
    break;
  default:
    fprintf(stderr, "JumpCallback: thumb calldata invalid\n");
    exit(1);
  }
  XStoreColor(XtDisplay(w), XDefaultColormapOfScreen(XtScreen(w)), &mix);

} /* JumpCallback */

/************************************************************************/
/* OkCallback() calls the resource supplied callbacks passing with it	*/
/* a pointer to the XColor structure mix.				*/
/************************************************************************/
static void OkCallback(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  ColorEditWidget	parent = (ColorEditWidget) client_data;

#ifdef DEBUG
printf("OkCallback\n");
#endif
  XtCallCallbacks(parent, XtNcallback, &mix);

} /* OkCallback */

/************************************************************************/
/* Initialize()								*/
/************************************************************************/
static void Initialize(request, new)
Widget	request, new;
{
  char			string[20];
  int			i, argi, child = 0;
  int			x, y;
  int			width = new->core.width, height = new->core.height;
  int			scroll_w, scroll_h, color_w, color_h;
  int			s = DefaultScreen(XtDisplay(new));
  long			planemask;
  float			hpad, wpad;
  Arg			arglist[20];
  ColorEditWidget	w = (ColorEditWidget) new;
  Display		*d = XtDisplay(new);
  Pixel			red, green, blue;
  Widget		children[10];

#ifdef DEBUG
printf("Initialize\n");
#endif
  width = w->core.width;
  height = w->core.height;
  wpad = 0.05 * (float) width;
  hpad = 0.05 * (float) height;
  scroll_w = (int) (((float) width/2.0 - 4.0*wpad) / 3.0);
  scroll_h = (int) ((float) height - 2.0*hpad);
  color_w = (int) ((float) width/2.0 - 2.0*wpad);
  color_h = (int) ((float) scroll_h / 4.0);
#ifdef DEBUG
printf("w=%d, h=%d, ", width, height);
printf("scroll_w=%d, scroll_h=%d, ", scroll_w, scroll_h);
printf("color_w=%d, color_h=%d\n", color_w, color_h);
#endif

  sprintf(string, "%d", 256*256);
  red = RequestColor(w, "red");
  green = RequestColor(w, "green");
  blue = RequestColor(w, "blue");
  XAllocColorCells(d, DefaultColormap(d, s), 0, &planemask, 0,
		   &mix.pixel, 1);
  mix.red = mix.green = mix.blue = (short) ~0;
  mix.flags = DoRed | DoGreen | DoBlue;
  XStoreColor(d, DefaultColormap(d, s), &mix);

#ifdef DEBUG
printf("creating red scrollbar\n");
#endif
  argi = 0;
  jump_callback[0].closure = (caddr_t) RED;
  Set_Arg(XtNwidth, scroll_w);
  Set_Arg(XtNheight, scroll_h);
  Set_Arg(XtNborder, red);
  Set_Arg(XtNforeground, red);
  Set_Arg(XtNfromHoriz, NULL);
  Set_Arg(XtNhorizDistance, wpad);
  Set_Arg(XtNfromVert, NULL);
  Set_Arg(XtNvertDistance, hpad);
  Set_Arg(XtNjumpProc, jump_callback);
  Set_Arg(XtNresizable, TRUE);
  w->coloredit.redscrollW = XtCreateWidget("", scrollbarWidgetClass,
					   w, arglist, argi);
  children[child] = w->coloredit.redscrollW;
  child++;

#ifdef DEBUG
printf("creating green scrollbar\n");
#endif
  argi = 0;
  jump_callback[0].closure = (caddr_t) GREEN;
  Set_Arg(XtNwidth, scroll_w);
  Set_Arg(XtNheight, scroll_h);
  Set_Arg(XtNborderColor, green);
  Set_Arg(XtNforeground, green);
  Set_Arg(XtNfromHoriz, w->coloredit.redscrollW);
  Set_Arg(XtNhorizDistance, wpad);
  Set_Arg(XtNfromVert, NULL);
  Set_Arg(XtNvertDistance, hpad);
  Set_Arg(XtNjumpProc, jump_callback);
  Set_Arg(XtNresizable, TRUE);
  w->coloredit.greenscrollW = XtCreateWidget("", scrollbarWidgetClass,
					     w, arglist, argi);
  children[child] = w->coloredit.greenscrollW;
  child++;

#ifdef DEBUG
printf("creating blue scrollbar\n");
#endif
  argi = 0;
  jump_callback[0].closure = (caddr_t) BLUE;
  Set_Arg(XtNwidth, scroll_w);
  Set_Arg(XtNheight, scroll_h);
  Set_Arg(XtNborderColor, blue);
  Set_Arg(XtNforeground, blue);
  Set_Arg(XtNfromHoriz, w->coloredit.greenscrollW);
  Set_Arg(XtNhorizDistance, wpad);
  Set_Arg(XtNfromVert, NULL);
  Set_Arg(XtNvertDistance, hpad);
  Set_Arg(XtNjumpProc, jump_callback);
  Set_Arg(XtNresizable, TRUE);
  w->coloredit.bluescrollW = XtCreateWidget("", scrollbarWidgetClass,
					    w, arglist, argi);
  children[child] = w->coloredit.bluescrollW;
  child++;

#ifdef DEBUG
printf("creating color box\n");
#endif

  argi = 0;
  ok_callback[0].closure = (caddr_t) w;
  Set_Arg(XtNwidth, color_w);
  Set_Arg(XtNheight, color_h);
  Set_Arg(XtNbackground, mix.pixel);
  Set_Arg(XtNlabel, "Select");
  Set_Arg(XtNfromHoriz, NULL);
  Set_Arg(XtNhorizDistance, width/2 + wpad);
  Set_Arg(XtNfromVert, NULL);
  Set_Arg(XtNvertDistance, height/2 - color_h/2);
  Set_Arg(XtNresizable, TRUE);
  Set_Arg(XtNcallback, ok_callback);
  w->coloredit.colorW = XtCreateWidget("", commandWidgetClass,
				       w, arglist, argi);
  children[child] = w->coloredit.colorW;
  child++;

#ifdef DEBUG
  printf("managing children in Initialize\n");
#endif

  XtManageChildren(children, child);

#ifdef DEBUG
   printf ("exiting Initialize\n");
#endif

} /* Initialize */

/************************************************************************/
/* Destroy()                                                             */
/************************************************************************/
static void Destroy(current)
Widget current;
{
	ColorEditWidget w = (ColorEditWidget) current;

#ifdef DEBUG
printf("Destroy\n");
#endif

/*
	XtRemoveAllCallbacks(w, XtNcallback);
*/
}

/************************************************************************/
/* ConstraintInitialize()						*/
/************************************************************************/
static void ConstraintInitialize(request, new)
Widget request, new;
{
  ColorEditWidget	w = (ColorEditWidget) new->core.parent;
  WidgetList		children = w->composite.children;
  ColorEditConstraints	constraint =
			  (ColorEditConstraints) new->core.constraints;
  Widget		*childP;

#ifdef DEBUG
printf("ConstraintInitialize\n");
#endif

} /* ConstraintInitialize */

/************************************************************************/
/* SetValues()								*/
/************************************************************************/
static Boolean SetValues(gcurrent, grequest, gnew)
Widget	gcurrent, grequest, gnew;
{
  Boolean	redisplay = FALSE;

#ifdef DEBUG
printf("SetValues\n");
#endif
  return(redisplay);

} /* SetVaues */

/************************************************************************/
/* RequestColor()							*/
/************************************************************************/
static long RequestColor(w, name)
Widget	w;
char	*name;
{
  Display	*d = XtDisplay(w);
  XColor	truecolor, availcolor;

#ifdef DEBUG
printf("RequestColor %s\n", name);
#endif
  if (XAllocNamedColor(d, DefaultColormap(d, DefaultScreen(d)),
		       name, &availcolor, &truecolor) == 0) {
    fprintf(stderr, "RequestColor: cannot allocate color %s\n", name);
    return(-1);
  }
  if (truecolor.red != availcolor.red ||
      truecolor.green != availcolor.green ||
      truecolor.blue != availcolor.blue) {
    fprintf(stderr, "RequestColor: warning - %s color may be wrong\n", name);
  }
  return availcolor.pixel;

} /* RequestColor */
