/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/bargraph/Demo/RCS/onebargraphpixmap.c,v 1.5 1994/02/25 04:45:28 aydt Exp $
 */

#include <X11/Xatom.h>
#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/Xaw/Box.h>

#include "Bargraph.h"

#define SetArg(r, v)	XtSetArg(arglist[argi], r, v); argi++;

#define MIN	0
#define MAX	100

#define BITMAPNUM	8
Pixmap	pixmaps[BITMAPNUM];
#define COLORNUM	8
Pixel	pixels[COLORNUM];

#define BITMAPWIDTH	16
#define BITMAPHEIGHT	16

static char bitmap[] = {
  0x55, 0x55, 0x88, 0x88, 0x55, 0x55,		/* crossweave	*/
  0x22, 0x22, 0x55, 0x55, 0x88, 0x88,
  0x55, 0x55, 0x22, 0x22, 0x55, 0x55,
  0x88, 0x88, 0x55, 0x55, 0x22, 0x22,
  0x55, 0x55, 0x88, 0x88, 0x55, 0x55, 0x22, 0x22,
};

static void Select();
static XtCallbackRec selectcallback[] = {
  {Select,	(caddr_t) NULL	},
  {NULL,	(caddr_t) NULL	},
};

static XrmOptionDescRec options[] = {
  {"-hold",	"*bargraph.stickyHold",		XrmoptionSepArg,	NULL},
};

Syntax(call)
char *call;
{
  printf("Usage: %s\n", call);
  printf("\t-hold <sticky hold>\n");
  exit(1);

} /* Syntax */

void main(argc, argv)
int	argc;
char	**argv;
{
  int		i, value, argi, ArgNum;
  Widget	top, bargraph;
  Arg		arglist[10];
  Pixmap	fill_pixmap;
  XEvent	event;

  ArgNum = argc;

  top = XtInitialize("main", "XBargraph", options,
			  XtNumber(options), &argc, argv);
  if (argc != 1)
    Syntax(argv[0]);

  argi = 0;
  SetArg(XtNselect, selectcallback);
  SetArg(XtNtitle, "Bargraph");
  SetArg(XtNwidth, 300);
  SetArg(XtNheight, 50);
  SetArg(XtNborderWidth, 1);
  SetArg(XtNorientation, XtorientHorizontal)

  SetArg(XtNfillPixmap, NULL);
  fill_pixmap = XCreatePixmapFromBitmapData(XtDisplay(top),
					    XtScreen(top)->root,
					    bitmap, BITMAPWIDTH, BITMAPHEIGHT,
					    BlackPixelOfScreen(XtScreen(top)),
					    WhitePixelOfScreen(XtScreen(top)),
					    XDefaultDepthOfScreen(XtScreen(top)));
  arglist[6].value = (XtArgVal) fill_pixmap;

  if (ArgNum <= 1) {			/* set a default configuration	*/
     SetArg(XtNstickyHold, 5);
  }

  bargraph = XtCreateManagedWidget ("bargraph", bargraphWidgetClass,
				    top, arglist, argi);
  XtRealizeWidget(top);

  value = MIN + (MAX-MIN)*(getvalue() / 100.);
  BargraphSetValue(bargraph, value);

  while(1) {
    while (XtPending()) {
      XtNextEvent(&event);
      XtDispatchEvent(&event);
    }

    sleep(1);

    value = MIN + (MAX-MIN)*(getvalue() / 100.);
    BargraphSetValue(bargraph, value);
  }

} /* main */

static void Select(w, client_data, call_data)
Widget	w;
caddr_t	client_data, call_data;
{
  int	value = (int) call_data;

  printf("Callback:  value = %d\n", value);

} /* Select */
