/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */

#ifndef ParallelCoordsFormWrapper_h
#define ParallelCoordsFormWrapper_h

#include <Xm/Separator.h>
class MultivariateWidgetWrapper;

extern "C" {
#include "ParallelCoords.h"
}
#include "ParallelCoordsFU.h"


typedef struct {
      Widget pointSetName;
      Widget pointCount;
} PCStatusInformation;


class ParallelCoordsFormWrapper : public MultivariateWidgetWrapper,
                                  public virtual Callback
{
/* 
 *
 * A ParallelCoordsFormWrapper is the C++ wrapper for the ParallelCoords
 * display widget
 *
*/

private:
        Widget pcMainWindow, dataForm, statusForm, interactionForm;
	Widget pcWidget;
        ParallelCoordsFU               *PCFUthisPtr;
	PCStatusInformation            statusInformation;
	VoidPtrList                    pcLabels;

	PCClusteringOptions clusteringOptions;
	int dim;

protected:
	/* Method _createPreferenceWindow : Create all the widgets
	                    associated with the PC preferences */
	Widget _createPreferenceSheet();

	/* Method _setPCDataWidgets : Create all widgets associated with 
	                              the PC data window */
	void _setPCDataWidgets( int dimension );

	/* Method _setPCLabelWidgets : Create all the widgets associated
	                               with PC labels */
	void _setPCLabelWidgets( int dimension );

	/* Method _setupInteractionArea : Create all widgets associated
	                                  with the PC interaction area */
        void _setupInteractionArea( Widget parentWidget );

	/* Method _setupStatusArea:  Create all widgets associated with the
	                             PC status window */
	int _setupStatusArea( Widget statusForm );

	/* Method _updateFormOffsets:  Fix absolute sizes of the status
	      area above the data area */
	void _updateFormOffsets();

public:
        /* Method ParallelCoordsFomWrapper:  The constructor */       
        ParallelCoordsFormWrapper(Widget PCparent, ParallelCoordsFU *pcFUPtr );
     
	/* Method ~ParallelCoordsFormWrapper:  The destructor */
	~ParallelCoordsFormWrapper();

	/* Method callback1:  Handle interaction area push buttons */
	virtual void callback1( Widget, XtPointer, XtPointer );

	/* Method callback2:  Handle dialog window dismiss */
	virtual void callback2( Widget, XtPointer, XtPointer );

	/* Method getCategoryLabel:  Retrieve the label for a given data
	                             dimension */
	char * getCategoryLabel( int theDimension );

	/* Method getPCAttr:  Obtain the value of a PC widget resource */
	void getPCAttr( String name, XtArgVal value );

	/* Method getPerfWidgetPosition:  Retrieve position and size 
	                                information for the PC main window */
	void getPerfWidgetPosition( int& x, int& y, int& width, int& height );

	/* Method getPointSetName:  Retrieve position and size
	                            information for the PC main window */
	char * getPointSetName();

	/* Method realize:  Make visible the PC display */
	void realize();

	/* Method setCategoryLabel:  Define a label describing one of the
	                             data dimensions */
	void setCategoryLabel( const char *buf, int theDimension );

	/* Method setDimension:  Set the data dimension to be displayed */
	void setDimension( int dimension );

	/* Method setPCAttr:  Set widget attributes for the PC form */
	void setPCAttr( int x, int y, int width, int height );
	
	/* Method setPCValues:  Set data values for the Parallel Coordinates */
	void setPCValues( int *nDimDataPoints, int pointCount );
	void setPCValues( int *dataPoint );
	
	/* Method setPerfWidgetColors: Define the colors associated with
	                               the display */
	void setPerfWidgetColors();

	/* Method setPointCount:   Write to the status area the number
	                           of points currently being displayed */
	void setPointCount( int numPoints );

	/* Method setPointSetName:  Define a label describing the current
	                            dataset */
	void setPointSetName( char *buf );
};

#endif	

