/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *			 Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ContourWrapper.h: A class wrapper for the Contour performance widget
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/ContourFormWrapper.h,v 1.11 1994/02/25 04:45:01 aydt Exp $
 */
#ifndef ContourFormWrapper_h
#define ContourFormWrapper_h

#include "ContourFU.h"
#include "DisplayColorTables.h"  /* Maintains widget color table information */
#include "DisplayLabels.h"       /* Handles all widget labelling functions */
#include "PerfWidget.h"

class ContourFormWrapper : public PerfWidget {
/*
* A ContourFormWrapper is the C++ wrapper for the Contour display widget.
*/

private:
	static const char *const MY_CLASS;

        DisplayLabels 	   labels;
	DisplayColorTables colorTable;
        Widget             contourChild;
	ContourFU          *contourFUthisPtr;

	/* Method _findContourFormPosition:   Layout elements within the form */
        void _findContourFormPosition( int *contourLayoutXOrg,
				       int *contourLayoutYOrg,
		    		       int *contourWidthProportion, 
				       int *contourHeightProportion );
	
	/* Method _setContourFormPosition:    Sets the layout attributes for
	*				      the contour widget within the
	*				      form.                           */
        void _setContourFormPosition( int contourLayoutXOrg,
				     int contourLayoutYOrg,
		     	             int contourWidthProportion, 
				     int contourHeightProportion );

public:
	/* Method ContourFormWrapper: 	      The constructor.                */
	ContourFormWrapper( WidgetBase *par, ContourFU *contourFUPtr,
			    const XArgs& args, const CString& name );

	/* Method ~ContourFormWrapper:        The destructor                  */
	~ContourFormWrapper();

	/* Method callback1:		      Overloads Callback::callback1 to
	*				      handle callback in the display  */
	virtual void callback1( Widget w, XtPointer clientData, 
				XtPointer callData ); 

	/* Method getContourAttr:	      Get attribute of individual
	*				      Contour widget.                 */
        void getContourAttr( String name, XtArgVal value ) const;

	/* Method getContourFormAttr:	      Get attribute of form widget    */
        void getContourFormAttr( String name, XtArgVal value ) const;

	/* Method getContourLabel:	      Set aLabel to point to text
	*				      string for label specified. If
	*				      label is not set, then aLabel
	*				      points to a null string.        */
        void getContourLabel( int whichLabel, const char **aLabel ) const;

	/* Method setContourAttr:	      Set attribute of individual
	*				      Contour widget                  */
        void setContourAttr( String name, XtArgVal value );

	/* Method setContourFormAttr:	      Set attribute of form widget.   */
	void setContourFormAttr( String name, XtArgVal value );

	/* Method setContourLabel:	      Set the horizontal or vertical
	*				      label.                          */
        void setContourLabel( int whichLabel, const char *stringLabel );

        /* Method setPerfWidgetColors:        Sets the colors for the
	                                      contour widget                  */
	void setPerfWidgetColors();

	/* Method setDisplayValue:	      Sets the current value of
	*				      the contour display widget.     */
	void setDisplayValue( int row, int column, float value );

	/* Method setDisplayValues:	      Sets all values of the contour
	*				      display widget. The values array
	*				      should have nRows * nCols entries,
	*				      where nRows & nCols were set with
	*				      previous calls to setContourAttr*/
	void setDisplayValues( float *values );

};

#endif
