/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *			 Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ContourFormWrapper.cc:  Class wrapper for the Contour performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/ContourFormWrapper.C,v 1.12 1994/02/25 04:44:54 aydt Exp $
 */

#include "ContourFormWrapper.h"

extern "C" {
#include "Contour.h"
}

#include <Xm/Form.h>	// Form widget class name definition
#include "XArgs.h"

ContourFormWrapper::ContourFormWrapper( WidgetBase *par, 
					ContourFU *contourFUPtr, 
					const XArgs& args,
				 	const CString& name ) 
		   : PerfWidget( par )
{
	_setClassName( MY_CLASS );
    	_setType( "ContourFormWrapper" );

        // Create the Motif Form Widget
	widget = XtCreateManagedWidget( name.getValue(), xmFormWidgetClass, 
					par->getWidget(), args.getArgs(), 
					args.getNArgs() );
	setContourFormAttr( XmNfractionBase, (XtArgVal)10000 );

        // Create a single Contour to be the initial child of the Form
	Arg arg;
        XFontStruct *contourRangeFont = XLoadQueryFont(  XtDisplay(widget),
                       "-adobe-courier-medium-r-normal-*-12-*-*-*-m-*-*-*" ); 
        if ( contourRangeFont != NULL ) {
            XtSetArg( arg, XtNfont, (XtArgVal)contourRangeFont );
    	}
        contourChild = XtCreateManagedWidget( "ContourChild", 
					      contourWidgetClass, widget,
				              &arg, 1 );
     	setContourLabel( L_LEFT_VERT, NULLCHARSTRING );
     	setContourLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

        addCallback( contourChild, XtNselect, &Callback::callback1, this, NULL);
        contourFUthisPtr = contourFUPtr;
}

ContourFormWrapper::~ContourFormWrapper()
{
	XtDestroyWidget( widget );
}

void 
ContourFormWrapper::_findContourFormPosition( int *contourLayoutXOrg, 
					      int *contourLayoutYOrg,
	      				      int *contourWidthProportion, 
					      int *contourHeightProportion )
{
  	int iFractionBase;
  	getContourFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
  	*contourLayoutYOrg = 0;
 
  	if ( labels.isALabel( L_LEFT_VERT ) ) {
      	    *contourWidthProportion = (int)( iFractionBase -
                                      2 * labels.getLabelHeight(L_LEFT_VERT) );
            *contourLayoutXOrg = labels.getLabelHeight(L_LEFT_VERT);
  	} else {
      	    *contourWidthProportion = iFractionBase;
            *contourLayoutXOrg = 0;
  	}

  	if ( labels.isALabel( L_BOTTOM_HORIZ ) ) {
            *contourHeightProportion = (int)( iFractionBase -
                                   labels.getLabelHeight(L_BOTTOM_HORIZ) );
  	} else {
      	    *contourHeightProportion = (int)iFractionBase;
  	}
}

void 
ContourFormWrapper::_setContourFormPosition( int contourLayoutXOrg, 
					     int contourLayoutYOrg,	
                      			     int contourWidthProportion, 
					     int contourHeightProportion )
{
     	Arg arglist[4];

     	XtSetArg( arglist[0], XmNleftPosition, (XtArgVal)contourLayoutXOrg); 
     	XtSetArg( arglist[1], XmNrightPosition, 
                    (XtArgVal)( contourLayoutXOrg+contourWidthProportion ) ); 
     	XtSetArg( arglist[2], XmNtopPosition, (XtArgVal)contourLayoutYOrg );
     	XtSetArg( arglist[3], XmNbottomPosition,
                   (XtArgVal)( contourLayoutYOrg+contourHeightProportion) );
     	XtSetValues( contourChild, arglist, 4 );
}

void 
ContourFormWrapper::callback1( Widget /* w */, XtPointer /* clientData */, 
			       XtPointer /* callData */ ) 
{
   	int iRow, iCol;
   	ContourGetRowCol( (ContourWidget)contourChild, &iRow, &iCol );
   	contourFUthisPtr->fuCallback( iRow, iCol );
}

void 
ContourFormWrapper::getContourAttr( String name, XtArgVal value ) const
{
     	Arg arg;
 
     	XtSetArg( arg, name, value );
     	XtGetValues( contourChild, &arg, 1 );
}

void 
ContourFormWrapper::getContourFormAttr( String name, XtArgVal value ) const
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtGetValues( widget, &arg, 1 );
}

void 
ContourFormWrapper::getContourLabel( int whichLabel, const char **aLabel ) const
{
     	labels.getLabel( whichLabel, aLabel );
} 

void 
ContourFormWrapper::setContourAttr( String name, XtArgVal value )
{
   	Arg arg;

   	XtSetArg( arg, name, value );
   	XtSetValues( contourChild, &arg, 1 );
}

void 
ContourFormWrapper::setContourFormAttr( String name, XtArgVal value )
{
  	Arg arg;
  
  	XtSetArg( arg, name, value );
  	XtSetValues( widget, &arg, 1 );
}

void 
ContourFormWrapper::setContourLabel( int whichLabel, const char *stringLabel )
{
     	Boolean_ layoutChange = FALSE_;

     	if ( whichLabel == L_LEFT_VERT ) {
            layoutChange = labels.setLabel( widget, "ContourLabelVert",
					    whichLabel, stringLabel );
     	} else if ( whichLabel == L_BOTTOM_HORIZ ) {
            layoutChange = labels.setLabel( widget, "ContourLabelHoriz", 
					    whichLabel, stringLabel );
     	}
     	if ( layoutChange ) {
            int contourLayoutXOrg, contourLayoutYOrg;
            int contourWidthProportion, contourHeightProportion;

            _findContourFormPosition( &contourLayoutXOrg, &contourLayoutYOrg,
			    	      &contourWidthProportion, 
				      &contourHeightProportion );
            _setContourFormPosition( contourLayoutXOrg, contourLayoutYOrg,
      			             contourWidthProportion, 
				     contourHeightProportion );
        }
}

void 
ContourFormWrapper::setPerfWidgetColors()
{
        colorTable.gencolor( getDisplay(), getScreen() );
	ContourSetColors( (ContourWidget)contourChild, 
			   colorTable.getNumColors(),
                           colorTable.getColormapEntries() );
}

void 
ContourFormWrapper::setDisplayValue( int row, int column, float value )
{
	ContourSetValue( (ContourWidget)contourChild, row, column, value );
}

void 
ContourFormWrapper::setDisplayValues( float *values )
{
	ContourSetValues( (ContourWidget)contourChild, values );
}

/*
 *      Initialize the static data.   Only executed once.
 */
const char *const ContourFormWrapper::MY_CLASS = "ContourFormWrapper";

