/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author:  Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * BubbleFormWrapper.cc:  Class wrapper for the bubble performance widget  
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Wrappers/RCS/BubbleFormWrapper.C,v 1.12 1994/02/25 04:44:56 aydt Exp $
 */

#include "BubbleFormWrapper.h"

extern "C" {
#include "Bubble.h"
}

#include <Xm/Xm.h>
#include <Xm/Form.h>	// Form widget class name definition
#include <Xm/Label.h>   // For Bubble widget labelling

#include "XArgs.h"
#include "util.h"


BubbleFormWrapper::BubbleFormWrapper( WidgetBase *par, BubbleFU *bubbleFUPtr,
				    const XArgs & args,
				    const CString & name ) : PerfWidget( par )
{
        Arg arglist[1];    
        int i = 0;

       	_setType("BubbleFormWrapper");
        bubbleFUthisPtr = bubbleFUPtr;

        // Create the Motif FORM
    	widget = XtCreateManagedWidget( name.getValue(),
				 xmFormWidgetClass, par->getWidget(),
				 args.getArgs(), args.getNArgs() );
        XtSetArg(arglist[0], XmNfractionBase, (XtArgVal)10000 );
        XtSetValues(widget, arglist, 1 );

        // Crate a single Bubble to the initial child
    	bubbleChild = XtCreateManagedWidget( "BubbleChild",
			         bubbleWidgetClass, widget,
			         arglist, i );
        // Create the labels
        labels.createMinMaxLabel(widget, "BubbleMinMaxLabel");
	setBubbleLabel( L_LEFT_VERT, NULLCHARSTRING );
	setBubbleLabel( L_BOTTOM_HORIZ, NULLCHARSTRING );

        addCallback( bubbleChild, XtNselect, &Callback::callback1, this, NULL );
}

BubbleFormWrapper::~BubbleFormWrapper()
{
}

void 			/* virtual from Callback:: */
BubbleFormWrapper::callback1( Widget /* callbackWidget */, 
			      XtPointer /* ptr1 */, XtPointer /* ptr2 */ )
{
   int iRow, iCol;
   BubbleGetRowCol( (BubbleWidget)bubbleChild, &iRow, &iCol );
   bubbleFUthisPtr->fuCallback(iRow, iCol);
}

  
// Generates the appropriate label for the current display instance
void 
BubbleFormWrapper::setBubbleLabel(int whichLabel, const char *stringLabel)
{
     Boolean_ layoutChange;
     if (whichLabel == L_LEFT_VERT) {
         layoutChange = 
         labels.setLabel( widget, "BubbleLabelVert", whichLabel, stringLabel );
     } else if (whichLabel == L_BOTTOM_HORIZ) {
         layoutChange = 
         labels.setLabel( widget,"BubbleLabelHoriz", whichLabel, stringLabel );
     }
     if (layoutChange) {
         int bubbleLayoutXOrg, bubbleLayoutYOrg,
             bubbleWidthProportion, bubbleHeightProportion;
         findBubbleFormPosition(&bubbleLayoutXOrg, &bubbleLayoutYOrg,
			      &bubbleWidthProportion, &bubbleHeightProportion);
         setBubbleFormPosition( bubbleLayoutXOrg, bubbleLayoutYOrg,
				bubbleWidthProportion, bubbleHeightProportion);
     }
}

// Sets values in the Bubble"s min/max label
void 
BubbleFormWrapper::setBubbleLabel( double fuMin, double fuMax )
{
     labels.setLabel( fuMin, fuMax );
}


// Retrieves the text string for the given label
void 
BubbleFormWrapper::getBubbleLabel( int whichLabel, const char **aLabel ) const
{
     labels.getLabel(whichLabel, aLabel);
} 

// Retrieves a Bubble (not BubbleForm) attribute
void 
BubbleFormWrapper::getBubbleAttr( String name, XtArgVal value )
{
     Arg arg[1];
 
     XtSetArg( arg[0], name, value );
     XtGetValues( bubbleChild, arg, 1 );
}

// SETS a Bubble attribute for the Bubble within the Form 
void 
BubbleFormWrapper::setBubbleAttr( String name, XtArgVal value )
{
   Arg arg[1];

   XtSetArg( arg[0], name, value );
   XtSetValues( bubbleChild, arg, 1 );
}


void 
BubbleFormWrapper::getBubbleFormAttr( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtGetValues( widget, arglist, 1 );
}

void 
BubbleFormWrapper::setBubbleFormAttr( String name, XtArgVal value )
{
  Arg arglist[1];
  
  XtSetArg( arglist[0], name, value );
  XtSetValues( widget, arglist, 1 );
}


void 
BubbleFormWrapper::findBubbleFormPosition(
              int *bubbleLayoutXOrg, int *bubbleLayoutYOrg,
	      int *bubbleWidthProportion, int *bubbleHeightProportion )
{
  int iFractionBase;
  getBubbleFormAttr( XmNfractionBase, (XtArgVal) &iFractionBase );
  *bubbleLayoutYOrg = labels.getLabelHeight(L_TOP_HORIZ);
 
  if (labels.isALabel(L_LEFT_VERT)) {
      *bubbleWidthProportion = (int)(iFractionBase -
                                  2*labels.getLabelHeight(L_LEFT_VERT));
      *bubbleLayoutXOrg = labels.getLabelHeight(L_LEFT_VERT);
  } else {
      *bubbleWidthProportion = iFractionBase;
      *bubbleLayoutXOrg = 0;
  }
  if (labels.isALabel(L_BOTTOM_HORIZ)) {
      *bubbleHeightProportion = (int)(iFractionBase -
                               labels.getLabelHeight(L_BOTTOM_HORIZ) -
                               labels.getLabelHeight(L_TOP_HORIZ) );
  } else {
      *bubbleHeightProportion = 
                   (int)(iFractionBase-labels.getLabelHeight(L_TOP_HORIZ));
  }
}

void 
BubbleFormWrapper::setBubbleFormPosition( 
                      int bubbleLayoutXOrg, int bubbleLayoutYOrg,	
                      int bubbleWidthProportion, int bubbleHeightProportion )
{
     Arg arglist[4];
     int i = 0;

     XtSetArg( arglist[i], XmNleftPosition, (XtArgVal)bubbleLayoutXOrg); i++;
     XtSetArg( arglist[i], XmNrightPosition, 
                    (XtArgVal)(bubbleLayoutXOrg+bubbleWidthProportion)); i++;
     XtSetArg( arglist[i], XmNtopPosition, (XtArgVal)bubbleLayoutYOrg); i++;
     XtSetArg( arglist[i], XmNbottomPosition,
                   (XtArgVal)bubbleLayoutYOrg+bubbleHeightProportion); i++;
     XtSetValues( bubbleChild, arglist, i );
}

void 
BubbleFormWrapper::setDisplayValue( int row, int column, int value )
{
	BubbleSetValue( (BubbleWidget)bubbleChild, row, column, value );
}


void 
BubbleFormWrapper::setDisplayValues( int rows, int cols, int *values )
{
	BubbleSetValues( (BubbleWidget)bubbleChild, rows, cols, values );
}


void 
BubbleFormWrapper::setPerfWidgetColors()
{
        colorTable.gencolor( getDisplay(), getScreen() );
	BubbleSetColors( (BubbleWidget)bubbleChild, 
                         colorTable.getNumColors(),
                         colorTable.getColormapEntries() );
}

void 
BubbleFormWrapper::setPerfWidgetPixmaps( int pixmapCount, Pixmap* pixmaps )
{
	BubbleSetPixmaps( (BubbleWidget)bubbleChild, pixmapCount, pixmaps );
}
