/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/Scatter3DP.h,v 1.8 1994/02/25 04:47:59 aydt Exp $
 */

#ifndef _Scatter3DP_h
#define _Scatter3DP_h

#include "Scatter3D.h"
#include <X11/CoreP.h>
#include <X11/Xaw/FormP.h>

#define PI		3.14159265358979
#define TWOPI		(2. * PI)
#define NINETY		(PI / 2.0)
#define	MAXPOINTS	1024
#define MAXSETS		30
#define MIN_SIZE	164
#define	PADDING		5
#define FONTPAD		3

#define	XCOLOR		0
#define	YCOLOR		1
#define ZCOLOR		2
#define OTHERCOLOR	3

#define	MINAXIS		1

#define	DEFAULTSCALE	0.5
#define DEFAULTTHETA	90.0
#define DEFAULTPHI	15.0
#define DEFAULTRADIUS	2.0

#define NUM_CONTROL	6
#define	XBAR		0
#define	YBAR		1
#define ZBAR		2
#define	ZOOM		3
#define THETA		4
#define PHI		5
#define XBARSCROLL	2
#define	YBARSCROLL	7
#define	ZBARSCROLL	12
#define	ZOOMSCROLL	17
#define THETASCROLL	22
#define PHISCROLL	27
#define XBARLABEL	4
#define	YBARLABEL	9
#define	ZBARLABEL	14
#define	ZOOMLABEL	19
#define THETALABEL	24
#define PHILABEL	29

#define	XAXIS		0
#define YAXIS		1
#define ZAXIS		2

typedef struct {
  double val[4][4];
} matrix3D;

typedef struct {
  double val[4];
} point3D;

typedef struct {
  double val[3];
} point2D;

typedef struct {
  /* public */
  int		backing_store;		/* backing store type		*/
  int		ptcnt[MAXSETS];		/* number of data points	*/
  int		setcnt;			/* number of data sets		*/

  int		minXvalues;		/* minimum X data value		*/
  int		maxXvalues;		/* maximum X data value		*/
  int		minYvalues;
  int		maxYvalues;
  int		minZvalues;
  int		maxZvalues;

  int		markersize;		/* size of data markers		*/

  Boolean	autoscale;		/* autoscale the axes?		*/

  XFontStruct	*font;			/* font for text		*/
  Pixel*	point_color;		/* color for data points	*/
  Pixel		apply_color;		/* apply button color		*/
  Pixel		reset_color;		/* reset button color		*/
  Pixel		close_color;		/* close button color		*/
  Pixel		axisXcolor;		/* X axis color			*/
  Pixel		axisYcolor;		/* Y axis color			*/
  Pixel		axisZcolor;		/* Z axis color			*/
  Pixel		axisOcolor;		/* Other axis color		*/
  XtCallbackList select;		/* callback for select		*/
  /* private data */
  Widget	controlW[38];
  Widget	popupW;
  Widget	popupFormW;

  int		Xdegrees;
  int		Ydegrees;
  int		Zdegrees;
  double	Zoomfraction;
  double	theta;
  double	phi;

  point3D	VRP;
  point3D	VPN;
  point3D	VUP;
  point3D	PRP;

  double	umin, umax, vmin, vmax;
  double	frontplane, backplane;

  Boolean	configChanged;

  matrix3D	transMatrix;

  int		colorcnt;		/* number of colors		*/
  int		value_select;		/* selected value		*/
  int		Xvalues[MAXSETS][MAXPOINTS];/* stored values		*/
  int		Yvalues[MAXSETS][MAXPOINTS];
  int		Zvalues[MAXSETS][MAXPOINTS];
  GC		pointGCs[MAXSETS];	/* GCs for data points		*/
  GC		eraseGC;		/* GC for erase			*/
  GC		axisGC[4];		/* GCs for axes			*/
  Pixmap        drawPixmap;		/* drawing pixmap 		*/
  GC		pixmapGC;		/* pixmap GC 			*/
} Scatter3DPart;

typedef struct _Scatter3DRec {
   CorePart core;
   Scatter3DPart scatter3d;
   } Scatter3DRec;

typedef struct {int dummy;} Scatter3DClassPart;

typedef struct _Scatter3DClassRec {
   CoreClassPart core_class;
   Scatter3DClassPart scatter3d_class;
   } Scatter3DClassRec;

extern Scatter3DClassRec scatter3dClassRec;

#endif _Scatter3DP_h
