/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/PolarP.h,v 1.9 1994/02/25 04:47:32 aydt Exp $
 */

#ifndef _XtPolarP_h
#define _XtPolarP_h

#include "Polar.h"
#include <X11/CoreP.h>

#define PI		3.14159265358979
#define TWOPI		(2. * PI)
#define NINETY		(PI / 2.0)
#define	MAXPOINTS	1024
#define MAXAXES		32
#define MAXCIRCLES	8
#define MIN_SIZE	164
#define	PADDING		5
#define FONTPAD		3

typedef struct {
  /* public */
  Boolean	fill;			/* fill polar			*/
  int		backing_store;		/* backing store type		*/
  int		numaxes;		/* number of axes		*/
  int		numcircles;		/* number of polar circles	*/
  int		magnitude;		/* data value range		*/
  int		ptcnt;			/* number of data points	*/
  int		markersize;		/* size of data markers		*/
  Pixel		circle_color;		/* color for circles		*/
  Pixel		point_color;		/* color for data points	*/
  Pixel		axis_color;		/* color for axes		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  int		value_select;		/* selected value		*/
  int           value_select_pos;       /* selected value pos           */
  Dimension	radius;			/* radius factor		*/
  int		polar_offsetY;		/* y offset 			*/
  int		Xvalues[MAXPOINTS];	/* stored values		*/
  int		Yvalues[MAXPOINTS];
  int           dataXValues[MAXPOINTS];
  int           dataYValues[MAXPOINTS];
  GC		circleGC;		/* GC for face border		*/
  GC		pointGC;		/* GC for data points		*/
  GC		eraseGC;		/* GC for erase			*/
  GC		axisGC;			/* GC for axes			*/
  Position	centerX;
  Position	centerY;
  XPoint	points[MAXAXES];
  CoordinateLoc location;               /* x-y location of mouse click   */
} PolarPart;

typedef struct _PolarRec {
   CorePart core;
   PolarPart polar;
   } PolarRec;

typedef struct {int dummy;} PolarClassPart;

typedef struct _PolarClassRec {
   CoreClassPart core_class;
   PolarClassPart polar_class;
   } PolarClassRec;

extern PolarClassRec polarClassRec;

#endif _XtPolarP_h
