/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Allen D. Malony (malony@uicsrd.csrd.uiuc.edu)
 * Contributing Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/KiviatP.h,v 1.11 1994/02/25 04:47:47 aydt Exp $
 */

#ifndef _XtKiviatP_h
#define _XtKiviatP_h

#include "Kiviat.h"
#include <X11/CoreP.h>

#define PI		3.14159265358979
#define TWOPI		(2. * PI)
#define NINETY		(PI / 2.0)
#define	MAX_AXES	512
#define MIN_SIZE	164
#define	PADDING		3
#define FONTPAD		3

typedef struct {
  /* public */
  Boolean	fill;			/* fill kiviat			*/
  Boolean	history;		/* show history			*/
  Boolean	maxhistory;		/* show history of maxima?	*/
  int		backing_store;		/* backing store type		*/
  int		numaxes;		/* number of axes		*/
  int		min_value, max_value;	/* minimum and maximum value	*/
  Pixel		face_border_color;	/* color for face border	*/
  Pixel		fill_color;		/* color for fill		*/
  Pixel		history_color;		/* color for history		*/
  Pixel		axis_color;		/* color for axes		*/
  XtCallbackList select;		/* callback for select		*/
  /* private */
  int		value_select;		/* selected value		*/
  int		axis_select;		/* selected axis		*/
  Dimension	radius;			/* radius factor		*/
  int		values[MAX_AXES];	/* stored values		*/
  double	history_values[MAX_AXES]; /* stored history values	*/
  int		count;			/*  number of times called	*/
  GC		face_borderGC;		/* GC for face border		*/
  GC		fillGC;			/* GC for fill			*/
  GC		historyGC;		/* GC for history		*/
  GC		eraseGC;		/* GC for erase			*/
  GC		axisGC;			/* GC for axes			*/
  Position	centerX;
  Position	centerY;
  XPoint	points[MAX_AXES];
  XPoint	history_points[MAX_AXES];
} KiviatPart;

typedef struct _KiviatRec {
   CorePart core;
   KiviatPart kiviat;
   } KiviatRec;

typedef struct {int dummy;} KiviatClassPart;

typedef struct _KiviatClassRec {
   CoreClassPart core_class;
   KiviatClassPart kiviat_class;
   } KiviatClassRec;

extern KiviatClassRec kiviatClassRec;

#endif _XtKiviatP_h
