/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Authors: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *                       Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * ContourP.h: File containing the private definitions for the Contour widget.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/Widgets/Includes/RCS/ContourP.h,v 1.9 1994/02/25 04:47:56 aydt Exp $
 */

#ifndef _XtContourP_h
#define _XtContourP_h

#include "Contour.h"
#include <X11/CoreP.h>

/*============================================================================*
 *      Constants used by the Contour widget
 *============================================================================*/

#define MINSIZE         300             /* minimum width and height          */
#define MAXROWS         500             /* maximum number of rows allowed    */
#define MAXCOLUMNS      500             /* maximum number of columns allowed */
#define PADDING         2               /* padding allowance around edges    */
#define FONTPAD		2		/* padding around text               */

/*============================================================================*
 * Contour widget Class Part: New fields for the Contour widget class 
 *============================================================================*/
typedef struct {
	int dummy;		/* dummy field to keep compiler happy */
} ContourClassPart;

/*============================================================================*
 * Contour widget Class Record: Combination of Contour and Core Class Parts
 *============================================================================*/
typedef struct _ContourClassRec {
   	CoreClassPart 	core_class;
   	ContourClassPart contour_class;
} ContourClassRec;

/*============================================================================*
 * External declaration of the class record for the Contour widget
 *============================================================================*/

extern ContourClassRec contourClassRec;

/*============================================================================*
 * Contour widget Instance Part: New fields for the Contour widget instance
 *============================================================================*/

typedef struct {
  	/* public instance variables - resources 			    */
	Boolean		    show_contours;	/* show contour list	    */
  	Boolean		    show_grid;		/* show grid		    */
	Boolean		    show_range;		/* show contour range	    */
        Boolean             show_range_above;   /* positioning of range     */
  	int		    columns;		/* number of columns	    */
  	int		    rows;		/* number of rows	    */
	int                 column_select;      /* selected column          */
        int                 row_select;         /* selected row             */
        int		    contour_cnt;	/* number of contours       */
  	Pixel		    grid_color;		/* contour grid color	    */
  	Pixel		    text_color;		/* contour text color	    */
	XFontStruct	    *font;		/* font for text 	    */
  	XtCallbackList	    select;		/* callback for select	    */

  	/* private instance variables - state   			    */
  	contourCallbackInfo cb_info;
  	float		    contours[MAXCON];	/* contour lines	    */
  	float		    xmove;		/* last x location	    */
  	float		    ymove;		/* last y location	    */
  	float		    xloc;		/* current x location	    */
  	float		    yloc;		/* current y location	    */
  	float		    *values;		/* pointer to values	    */
	int		    numcolors;		/* number of contour colors */
  	int		    offsetx;		/* contour x offset	    */
  	int		    offsety;		/* contour y offset         */
  	int		    sizex;		/* plot area x dimension    */
  	int		    sizey;		/* plot area y dimension    */
  	GC		    *contourGCs;	/* contour GCs		    */
  	GC		    gridGC;		/* grid GC		    */
  	GC		    textGC;		/* text GC		    */
} ContourPart;

/*============================================================================*
 * Contour widget Instance Record: 
 * 	Combination of Contour and Core Instance Parts
 *============================================================================*/

typedef struct _ContourRec {
   	CorePart core;
   	ContourPart contour;
} ContourRec;

#endif _XtContourP_h
