/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Keith Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * EventHandler.cc: Base class used to manage X Event Handlers in Pablo
 *
 */

#include "EventHandler.h"
#include "Assert.h"

void 		/* static */
EventHandler::staticEventHandler( Widget w, XtPointer clientData, 
				  XEvent *event, Boolean *continueToDispatch )
{
    EventHandlerData *ehData = (EventHandlerData *)clientData;

    EventHandler *object = ehData->_object;
    pEf proc = ehData->_memberFunction;

    (object->*proc)( w, ehData->_clientData, event, continueToDispatch );
}

EventHandler::EventHandler()
{
    headEntry = NULL;
    tailEntry = NULL;
}

EventHandler::~EventHandler()
{
    EventHandlerListEntry* currentEntry = headEntry;
    EventHandlerListEntry* followingEntry;

    while ( currentEntry != NULL ) {
	followingEntry = currentEntry->nextEntry;
	XtRemoveEventHandler( currentEntry->_w, 
			      currentEntry->_mask,
			      currentEntry->_nonmaskable,
			      (XtEventHandler) EventHandler::staticEventHandler,
			      &currentEntry->ehData );
	delete currentEntry;
	currentEntry = followingEntry;
    }
}

void
EventHandler::addEventHandler( Widget w, EventMask mask, Boolean nonmaskable,
				pEf memberFunction, EventHandler *object, 
				XtPointer clientData )
{
    EventHandlerListEntry *ehEntry = new EventHandlerListEntry;

    ehEntry->_w = w;
    ehEntry->_mask = mask;
    ehEntry->_nonmaskable = nonmaskable;
    ehEntry->ehData._memberFunction = memberFunction;
    ehEntry->ehData._object = object;
    ehEntry->ehData._clientData = clientData;

    if ( headEntry == NULL ) {
       headEntry = ehEntry;
       tailEntry = ehEntry;
    } else {
       tailEntry->nextEntry = ehEntry;
       tailEntry = ehEntry;
    }

    XtAddEventHandler( w, mask, nonmaskable, 
		       (XtEventHandler) EventHandler::staticEventHandler,
                       &ehEntry->ehData );

}

void
EventHandler::removeEventHandler( Widget w, EventMask mask, 
				   Boolean nonmaskable, pEf memberFunction, 
				   EventHandler *object, XtPointer clientData )
{
    EventHandlerListEntry* matchEntry = headEntry;

    while ( matchEntry != NULL ) {
	if ( matchEntry->_w == w 
	     && matchEntry->_mask == mask
	     && matchEntry->_nonmaskable == nonmaskable
    	     && matchEntry->ehData._memberFunction == memberFunction 
             && matchEntry->ehData._object == object 
             && matchEntry->ehData._clientData == clientData ) {

	    break;
	} else {
	    matchEntry = matchEntry->nextEntry;
	}
    }

    Assert( matchEntry != NULL );

    if ( headEntry == matchEntry ) {		// match first entry
	headEntry = matchEntry->nextEntry;
	if ( tailEntry == matchEntry ) {	// list had only 1 element
	    tailEntry = NULL;
	}
    } else {					// matched "interior" entry
	EventHandlerListEntry *currentEntry = headEntry;

	while ( currentEntry->nextEntry != matchEntry ) {
	    currentEntry = currentEntry->nextEntry;
	    Assert( currentEntry != NULL );
	}

	currentEntry->nextEntry = matchEntry->nextEntry;
	if ( matchEntry->nextEntry == NULL ) {
	    tailEntry = currentEntry;
	}
    }

    XtRemoveEventHandler( w, mask, nonmaskable,
			  (XtEventHandler) EventHandler::staticEventHandler,
		          &matchEntry->ehData );

    delete matchEntry;

}
