/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Keith Shields (shields@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *      Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * Callback.cc: Base class used to manage X callbacks in Pablo
 *
 */

#include "Callback.h"
#include "Assert.h"

void 		/* static */
Callback::staticCallback( Widget w, XtPointer clientData, XtPointer callData )
{
    CallbackData *cbData = (CallbackData *)clientData;

    Callback *object = cbData->_object;
    pCf proc = cbData->_memberFunction;

    (object->*proc)( w, cbData->_clientData, callData );
}

Callback::Callback()
{
    headEntry = NULL;
    tailEntry = NULL;
}

Callback::~Callback()
{
    /* 
     * Note that it is the responsiblity of the caller to explicitly call
     * removeCallback for each callback or the Destroy the widget so that
     * XtRemoveCallback is called appropriately - can't call XtRemoveCallback
     * here because it causes problems if the widget is destroyed before
     * this destructor code is invoked.
     */
    CallbackListEntry* currentEntry = headEntry;
    CallbackListEntry* followingEntry;

    while ( currentEntry != NULL ) {
	followingEntry = currentEntry->nextEntry;
	delete currentEntry;
	currentEntry = followingEntry;
    }
}

void
Callback::addCallback( Widget w, String name, pCf memberFunction, 
		       Callback *object, XtPointer clientData )
{
    CallbackListEntry *cbEntry = new CallbackListEntry;

    cbEntry->_w = w;
    cbEntry->_name = name;
    cbEntry->cbData._memberFunction = memberFunction;
    cbEntry->cbData._object = object;
    cbEntry->cbData._clientData = clientData;

    if ( headEntry == NULL ) {
       headEntry = cbEntry;
       tailEntry = cbEntry;
    } else {
       tailEntry->nextEntry = cbEntry;
       tailEntry = cbEntry;
    }

    XtAddCallback( w, name, (XtCallbackProc)Callback::staticCallback,
                   &cbEntry->cbData );

}

void
Callback::removeCallback( Widget w, String name, pCf memberFunction, 
		          Callback *object, XtPointer clientData )
{
    CallbackListEntry* matchEntry = headEntry;

    while ( matchEntry != NULL ) {
	if ( matchEntry->_w == w 
	     && matchEntry->_name == name 
    	     && matchEntry->cbData._memberFunction == memberFunction 
             && matchEntry->cbData._object == object 
             && matchEntry->cbData._clientData == clientData ) {

	    break;
	} else {
	    matchEntry = matchEntry->nextEntry;
	}
    }

    Assert( matchEntry != NULL );

    if ( headEntry == matchEntry ) {		// match first entry
	headEntry = matchEntry->nextEntry;
	if ( tailEntry == matchEntry ) {	// list had only 1 element
	    tailEntry = NULL;
	}
    } else {					// matched "interior" entry
	CallbackListEntry *currentEntry = headEntry;

	while ( currentEntry->nextEntry != matchEntry ) {
	    currentEntry = currentEntry->nextEntry;
	    Assert( currentEntry != NULL );
	}

	currentEntry->nextEntry = matchEntry->nextEntry;
	if ( matchEntry->nextEntry == NULL ) {
	    tailEntry = currentEntry;
	}
    }

    XtRemoveCallback( w, name, (XtCallbackProc)Callback::staticCallback,
		      &matchEntry->cbData );
    delete matchEntry;

}
