/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Bradley W. Schwartz (schwartz@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 *//*
 * DisplayColorTables.cc:
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/UsefulClasses/RCS/DisplayColorTables.C,v 1.9 1994/02/25 04:34:38 aydt Exp $
 */

#include "DisplayColorTables.h"

#define COLORNUM 28
static char *defaultColors[COLORNUM] = {         // Array of default colors
             "#0019fe",
             "#0031fb",
             "#004af4",
             "#0061ec",
             "#0078e1",
             "#008ed4",
             "#00a2c5",
             "#00b5b5",
             "#00c5a2",
             "#00d48e",
             "#00e178",
             "#00ec61",
             "#00f44a",
             "#00fe19",
             "#19fe00",
             "#4af400",
             "#61ec00",
             "#78e100",
             "#8ed400",
             "#a2c500",
             "#b5b500",
             "#c5a200",
             "#d48e00",
             "#e17800",
             "#ec6100",
             "#f44a00",
             "#fb3100",
             "#fe1900"
            };

DisplayColorTables::DisplayColorTables()
{
	colors = defaultColors;
	numColors = COLORNUM;
	pixels = NULL;		// We allocate this in gencolor
}

DisplayColorTables::~DisplayColorTables()
{
	if ( pixels != NULL ) {
	    // At some point we should really XFreeColors here too!
	    delete [] pixels;
	}
}

void 
DisplayColorTables::gencolor( Display *d, Screen *s )
{
  	int	 i;
  	XColor	 c;

	Colormap map = XDefaultColormapOfScreen( s ) ;

	if ( pixels == NULL ) {
	    pixels = new Pixel[ numColors ];
	}

  	for ( i = 0; i < numColors; i++ ) {
    	    XParseColor( d, map, colors[i], &c );
            if ( XAllocColor( d, map, &c ) == False ) {
		error( "Cannot allocate requested color(%s) - using black",
			colors[i] );
                pixels[i] = XBlackPixelOfScreen( s );
	    } else {
                pixels[i] = c.pixel;
	    }
  	}

} 

void 
DisplayColorTables::loadNewColormap( char **newColors, int numNewColors )
{
	colors = newColors;
	numColors = numNewColors;
	
	if ( pixels != NULL ) {
	    delete[] pixels;
	    pixels = NULL;
	}
}

int 
DisplayColorTables::getNumColors() const
{
   	return( numColors );
}

const Pixel 
DisplayColorTables::getColormapEntry( int entry ) const
{
   	return( pixels[entry] );
}

Pixel *
DisplayColorTables::getColormapEntries()
{
	if ( pixels == NULL ) {
	    error( "You must call gencolor() before getColormapEntries()\n" );
	}
   	return( pixels );
}
