/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * TranscriptWindowBuf.cc: Implements a stream subclass for the Pablo 
 *			   information and error dialog
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/TranscriptWindowBuf.C,v 1.10 1994/02/25 04:33:48 aydt Exp $
 *
 */
#include <stdlib.h>

#include "TranscriptWindowBuf.h"

TranscriptWindowBuf::TranscriptWindowBuf() : window(NULL)
{
	strcpy( linebuf, "" );		// initialize it
	type = TW_Error;
	lineptr = linebuf;
	logFilePointer = NULL;

	earlyInputBufferSize = 16384;
	earlyInputBuffer = (char *)calloc( earlyInputBufferSize, sizeof(char) );
	strcpy( earlyInputBuffer, "  " );

	earlyInputStream = new ostrstream( earlyInputBuffer,
				 	  earlyInputBufferSize );
}

TranscriptWindowBuf::~TranscriptWindowBuf()
{
	_flushbuf();
}

void
TranscriptWindowBuf::_flushbuf()
{
        *lineptr++ = 0;

        if (window) {
           window->writeText( linebuf, type );
        } else {
           *lineptr = 0;
           printf( "TS: %s", linebuf );
           fflush(stdout);
           *earlyInputStream << linebuf;
        }

        if ( logFilePointer ) {
           fputs( linebuf, logFilePointer );
           fflush( logFilePointer );
        }

        lineptr = linebuf;
}

void
TranscriptWindowBuf::close()
{
        _flushbuf();
}

int
TranscriptWindowBuf::is_open()
{
        return 1;
}

int
TranscriptWindowBuf::overflow( int c )
{
        *lineptr++ = c;

        if ( c == '\n' ) {
           _flushbuf();
        }

        return 1;
}

void
TranscriptWindowBuf::setLogFile( FILE *fp )
{
	logFilePointer = fp;
}

void
TranscriptWindowBuf::setWindowAndType( TranscriptWindow *transWindow,
					   TextType textType )
{
	window = transWindow;
	type = textType;

	window->writeText( earlyInputBuffer, textType );

	free( earlyInputBuffer );
	delete earlyInputStream;
}

int
TranscriptWindowBuf::underflow()
{
	return 0;
}

void
TranscriptWindowBuf::printOn( ostream &os )
{
	os << "TranscriptWindowBuf\n";
}
