/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * TranscriptWindow.cc: Implements a simple popup window containing
 *			a transcript of Pablo information, warning
 *			and error messages
 *
 * $Header : $
 *	
 */

#include "TranscriptWindow.h"

#include "PabloHelpSystem.h"
#include "WidgetBase.h"

TranscriptWindow::TranscriptWindow()
{
	XmString	transcriptMessage;

	_setClassName( MY_CLASS );

	transcriptDialog = XtCreatePopupShell( "transcriptDialog",
                 		topLevelShellWidgetClass,
				Pablo::TopLevel()->getWidget(),
				NULL, 0);

	XtVaSetValues( transcriptDialog,
		       XtNtitle, "Pablo System Transcript",
		       NULL );

	dialogPane = XtVaCreateWidget( "dialogPane",
			xmPanedWindowWidgetClass, transcriptDialog,
               	        XmNsashWidth, 1, XmNsashHeight, 1,
			NULL );

	controlArea = XtVaCreateWidget( "transcriptControlArea",
			xmFormWidgetClass, dialogPane,
			NULL );

     	actionArea = XtVaCreateWidget( "transcriptActionArea",
                        xmFormWidgetClass, dialogPane,
                        NULL );

	//  The action area contains two buttons, "Dismiss" and "Help"

        dismissButton = XtVaCreateManagedWidget( "Dismiss",
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	helpButton = XtVaCreateManagedWidget( "Help", 
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

 	infoLabel = XtVaCreateManagedWidget( "infoLabel",
                              xmLabelWidgetClass, controlArea,
                              NULL );

        transcriptMessage =  XmStringCreateLtoR( "Pablo Information",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( infoLabel, XmNlabelString,
                       (XtArgVal) transcriptMessage, NULL );

        XmStringFree( transcriptMessage );

	infoText = XmCreateScrolledText(controlArea, "infoText", NULL, 0 );

	XtVaSetValues( infoText,
			XmNblinkRate, 0,
			XmNeditable, False,
			XmNeditMode, XmMULTI_LINE_EDIT,
			XmNautoShowCursorPosition, True,
			XmNcursorPositionVisible, False,
			XmNresizeWidth, True,
			NULL );

        errorLabel = XtVaCreateManagedWidget( "errorLabel",
                              xmLabelWidgetClass, controlArea,
                              NULL );

        transcriptMessage =  XmStringCreateLtoR( "Pablo Errors",
                                XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( errorLabel, XmNlabelString,
                       (XtArgVal) transcriptMessage, NULL );

        XmStringFree( transcriptMessage );

        errorText = XmCreateScrolledText(controlArea, "errorText", NULL, 0 );

	XtVaSetValues( errorText,
                        XmNblinkRate, 0,
                        XmNeditable, False,
                        XmNeditMode, XmMULTI_LINE_EDIT,
                        XmNautoShowCursorPosition, True,
                        XmNcursorPositionVisible, False,
			XmNresizeWidth, True,
                        NULL );

        XtManageChild( infoText );
        XtManageChild( errorText );
        XtManageChild( dialogPane );
        XtManageChild( controlArea );
        XtManageChild( actionArea );

	//  Motif action areas are never supposed to change size.
	//  We fix the size of the pane containing the buttons.

   	Dimension h; 
   	XtVaGetValues( dismissButton, XmNheight, &h, NULL );

   	XtVaSetValues( actionArea,
		       XmNpaneMaximum, h,
		       XmNpaneMinimum, h,
		       NULL );

        XtAddCallback( dismissButton, XmNactivateCallback,
		      (XtCallbackProc)TranscriptWindow::_staticDismissCallback,
		      (XtPointer) this );
        XtAddCallback( helpButton, XmNactivateCallback,
		      (XtCallbackProc)TranscriptWindow::_staticHelpCallback,
		      (XtPointer) this );
}

TranscriptWindow::~TranscriptWindow()
{
	XtDestroyWidget( dialogPane );
	XtDestroyWidget( controlArea );
	XtDestroyWidget( actionArea );
	XtDestroyWidget( transcriptDialog );
}

void
TranscriptWindow::_helpCallback( char* topic )
{
        Pablo::HelpSystem()->giveHelpOn( topic );
}

void
TranscriptWindow::_staticDismissCallback( Widget ,
                                       XtPointer clientData,
                                       XtPointer )
{
        TranscriptWindow *obj = (TranscriptWindow *) clientData;

        obj->closeWindow();
}

void
TranscriptWindow::_staticHelpCallback( Widget ,
                                    XtPointer clientData,
                                    XtPointer )
{
        TranscriptWindow *obj = (TranscriptWindow *) clientData;
   
        obj->_helpCallback( "SystemTranscript" );
}

void
TranscriptWindow::closeWindow()
{
        Assert( transcriptDialog != NULL );

        XtUnmanageChild( transcriptDialog );
}

void
TranscriptWindow::openWindow()
{
	Assert( transcriptDialog != NULL );

        XtManageChild( transcriptDialog );
}

void
TranscriptWindow::writeText( const char *text,
				  TextType type )
{
	XmTextPosition textPosition;
	Widget w;

	if ( type == TW_Normal ) {
	   w = infoText;
	} else if ( type == TW_Error ) {
	   w = errorText;
	} else {
	   w = NULL;
	}

	if ( w == NULL ) {
	   return;
	}

	textPosition = XmTextGetLastPosition( w );
	XmTextInsert( w, textPosition, (char *) text );

	textPosition = XmTextGetLastPosition( w );
	XmTextShowPosition( w, textPosition );
}

void
TranscriptWindow::printOn( ostream &os ) const 
{
	os << "TranscriptWindow\n";
}

/*
 * Initialize the static data
 */

const char *const TranscriptWindow::MY_CLASS = "TranscriptWindow";
