/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Contributing Author: Ruth A. Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * RunDialog.C: Implements a run panel dialog for Pablo.  We can have only
 * 		one run panel instance per Pablo invocation.
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/RunDialog.C,v 1.16 1994/03/28 15:39:19 aydt Exp $
 *	
 */

#include <stdlib.h>
#include <Xm/Frame.h>
#include <Xm/Text.h>

#include "RunDialog.h"

#include "PabloHelpSystem.h"
#include "PabloMainInterface.h"
#include "PabloResources.h"

/* Constants used only in this file */
const int XmRUN_GRAPH =  0;
const int XmRUN_MODULE = 1;
const int XmRUN_ONCE =   2;

const int XmEVENTS =     0;
const int XmTIME =       1;


RunDialog::RunDialog( PabloMainInterface* createdBy ) 
{
	XmString	labelMessage;
	char		tmpBuf[50];

	_setClassName( MY_CLASS );

	if ( pabloMainInterface != NULL ) {
	    abort( "Can't have more than one Run Panel instance.\n" );
	} else {
	    pabloMainInterface = createdBy;
	}
	isManaged = FALSE_;

 	cbinfo.dp = this;

	cbinfoModule.dp = this;
	cbinfoModule.button = XmRUN_MODULE;
	cbinfoGraph.dp = this;
	cbinfoGraph.button = XmRUN_GRAPH;
        cbinfoOnce.dp = this;
        cbinfoOnce.button = XmRUN_ONCE;

	cbinfoEvents.dp = this;
	cbinfoEvents.button = XmEVENTS;
	cbinfoTime.dp = this;
	cbinfoTime.button = XmTIME;

	runDialog = XtCreatePopupShell( "runDialog",
                 		topLevelShellWidgetClass,
				Pablo::TopLevel()->getWidget(),
				NULL, 0);

	XtVaSetValues( runDialog,
		       XtNtitle, "Pablo Execution Control",
		       NULL );

	dialogPane = XtVaCreateWidget( "dialogPane",
			xmPanedWindowWidgetClass, runDialog,
               	        XmNsashWidth, 1, XmNsashHeight, 1,
			NULL );

        executeForm = XtVaCreateWidget( "executeForm",
                        xmFormWidgetClass, dialogPane,
                        NULL );

        /*******  BEGIN NOT IMPLEMENTED
	
        updateForm = XtVaCreateWidget( "updateForm",
                        xmFormWidgetClass, dialogPane,
                        NULL );

	********END NOT IMPLEMENTED   */

     	actionArea = XtVaCreateWidget( "actionArea",
                        xmFormWidgetClass, dialogPane,
                        NULL );

	//  The action area contains five buttons.  Of these, the
	//  "Checkpoint" is not yet operational.  It is intended to
	//  support future implementation of Pablo checkpoints.

        dismissButton = XtVaCreateManagedWidget( "Dismiss",
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	runButton = XtVaCreateManagedWidget( "Run", 
                     xmPushButtonWidgetClass, actionArea,
		     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	stopButton = XtVaCreateManagedWidget( "Stop", 
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

	checkpointButton = XtVaCreateManagedWidget( "Checkpoint",
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

   	snapshotButton = XtVaCreateManagedWidget( "Snapshot",
		     xmPushButtonWidgetClass, actionArea,
		     XmNdefaultButtonShadowThickness, 1,
		     NULL );

	helpButton = XtVaCreateManagedWidget( "Help", 
                     xmPushButtonWidgetClass, actionArea,
                     XmNdefaultButtonShadowThickness, 1,
                     NULL );

	//  Create a run toggle box allowing selection of either
	//  module or graph execution

	runGraph = TRUE_;
	runBox = XtVaCreateManagedWidget( "runBox",
			xmRowColumnWidgetClass, executeForm,
			XmNorientation, XmVERTICAL,
			XmNnumColumns, 1,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			NULL );

 	runLabel = XtVaCreateManagedWidget( "runLabel",
                              xmLabelWidgetClass, runBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "Execute graph: ",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( runLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

	radioFrame = XtVaCreateManagedWidget( "stepBox",
                        xmFrameWidgetClass, runBox,
			NULL );

	radioBox = XmVaCreateSimpleRadioBox( radioFrame, "radioBox",
			1,			// button one set
			NULL,
			NULL );

 	graphButton = XtVaCreateManagedWidget( "Continuously",
                        xmToggleButtonGadgetClass, radioBox,
			XmNset, TRUE,
                        NULL );

	moduleButton = XtVaCreateManagedWidget( "Module by module",
			xmToggleButtonGadgetClass, radioBox,
			NULL );

        onceButton = XtVaCreateManagedWidget( "N times",
                        xmToggleButtonGadgetClass, radioBox,
                        NULL );

	XtManageChild( radioBox );

	//  Create the control box allowing specification of the
	//  number of steps to execute the graph

        stepBox = XtVaCreateManagedWidget( "stepBox",
                        xmRowColumnWidgetClass, executeForm,
                        XmNorientation, XmVERTICAL,
                        XmNnumColumns, 1,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, runBox,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );

        stepLabel = XtVaCreateManagedWidget( "stepLabel",
                              xmLabelWidgetClass, stepBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "Number of graph steps:",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( stepLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

	sprintf( tmpBuf, "%d", pabloData.runStepSize );

	stepText = XtVaCreateManagedWidget( "stepText",
			xmTextFieldWidgetClass, stepBox,
			XmNvalue, tmpBuf,
			NULL );

	//  Create a update toggle box allowing selection of either
	//  event or time interval control of the display updates 

	/*******  BEGIN NOT IMPLEMENTED  
	updateBox = XtVaCreateManagedWidget( "updateBox",
			xmRowColumnWidgetClass, updateForm,
			XmNorientation, XmVERTICAL,
			XmNnumColumns, 1,
			XmNtopAttachment, XmATTACH_FORM,
			XmNleftAttachment, XmATTACH_FORM,
			NULL );

 	updateLabel = XtVaCreateManagedWidget( "updateLabel",
                              xmLabelWidgetClass, updateBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "Display Interval: ",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( updateLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

	updateRadioFrame = XtVaCreateManagedWidget( "stepBox",
                        xmFrameWidgetClass, updateBox,
			NULL );

	updateRadioBox = XmVaCreateSimpleRadioBox( updateRadioFrame,
		        "updateRadioBox",
			1,			// button one set
			NULL,
			NULL );

	eventsButton = XtVaCreateManagedWidget( "Events",
			xmToggleButtonGadgetClass, updateRadioBox,
                        XmNset, TRUE,
			NULL );

 	timeButton = XtVaCreateManagedWidget( "Time",
                        xmToggleButtonGadgetClass, updateRadioBox,
                        NULL );

	XtManageChild( updateRadioBox );
	*********END NOT IMPLEMENTED   */

	//  Create the scale for specifying the display update
	//  interval (in events)

	/*******  BEGIN NOT IMPLEMENTED 
        displayBox = XtVaCreateManagedWidget( "displayBox",
                        xmRowColumnWidgetClass, updateForm,
                        XmNorientation, XmVERTICAL,
                        XmNnumColumns, 1,
                        XmNtopAttachment, XmATTACH_FORM,
                        XmNleftAttachment, XmATTACH_WIDGET,
                        XmNleftWidget, updateBox,
                        XmNrightAttachment, XmATTACH_FORM,
                        NULL );

        eventLabel = XtVaCreateManagedWidget( "eventLabel",
                              xmLabelWidgetClass, displayBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              XmNtopAttachment, XmATTACH_FORM,
                              XmNleftAttachment, XmATTACH_WIDGET,
			      XmNleftWidget, updateBox, 
                              NULL );

        labelMessage =  XmStringCreateLtoR( "Events",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( eventLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

        eventBox = XtVaCreateManagedWidget( "eventBox",
                        xmRowColumnWidgetClass, displayBox,
                        XmNorientation, XmHORIZONTAL,
                        XmNnumColumns, 3,
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNtopWidget, eventLabel,
                        XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, updateBox,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );

        minEventLabel = XtVaCreateManagedWidget( "minEventLabel",
                              xmLabelWidgetClass, eventBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "1",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( minEventLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

        eventFraction = XtVaCreateManagedWidget( "eventFraction",
                                xmScaleWidgetClass, eventBox,
                                XmNminimum, 1,
                                XmNmaximum, pabloData.maxEventInterval,
                                XmNvalue, pabloData.eventInterval,
                                XmNshowValue, TRUE,
                                XmNorientation, XmHORIZONTAL,
                                NULL );

        maxEventLabel = XtVaCreateManagedWidget( "maxEventLabel",
                              xmLabelWidgetClass, eventBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

	sprintf(tmpBuf, "%d", pabloData.maxEventInterval);
        labelMessage =  XmStringCreateLtoR( tmpBuf,
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( maxEventLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );
	********END NOT IMPLEMENTED   */

	//  Create the scale for specifying the display update
	//  interval (in time)

	/*******  BEGIN NOT IMPLEMENTED 
        timeLabel = XtVaCreateManagedWidget( "timeLabel",
                              xmLabelWidgetClass, displayBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              XmNtopAttachment, XmATTACH_WIDGET,
                              XmNtopWidget, eventBox,
                              XmNleftAttachment, XmATTACH_WIDGET,
			      XmNleftWidget, updateBox,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "Time",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( timeLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

        timeBox = XtVaCreateManagedWidget( "timeBox",
                        xmRowColumnWidgetClass, displayBox,
                        XmNorientation, XmHORIZONTAL,
                        XmNnumColumns, 3,
                        XmNtopAttachment, XmATTACH_WIDGET,
                        XmNtopWidget, timeLabel,
                        XmNleftAttachment, XmATTACH_WIDGET,
			XmNleftWidget, updateBox,
			XmNrightAttachment, XmATTACH_FORM,
                        NULL );

        minTimeLabel = XtVaCreateManagedWidget( "minTimeLabel",
                              xmLabelWidgetClass, timeBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

        labelMessage =  XmStringCreateLtoR( "1",
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( minTimeLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

        timeFraction = XtVaCreateManagedWidget( "timeFraction",
                                xmScaleWidgetClass, timeBox,
                                XmNminimum, 1,
                                XmNmaximum, pabloData.maxTimeInterval,
                                XmNvalue, pabloData.timeInterval,
                                XmNshowValue, TRUE,
                                XmNorientation, XmHORIZONTAL,
                                NULL );

        maxTimeLabel = XtVaCreateManagedWidget( "maxTimeLabel",
                              xmLabelWidgetClass, timeBox,
                              XmNalignment, XmALIGNMENT_BEGINNING,
                              XmNresizable, FALSE,
                              NULL );

	sprintf(tmpBuf, "%d", pabloData.maxTimeInterval);
        labelMessage =  XmStringCreateLtoR( tmpBuf,
                                          XmSTRING_DEFAULT_CHARSET );

        XtVaSetValues( maxTimeLabel, XmNlabelString,
                       (XtArgVal) labelMessage, NULL );

        XmStringFree( labelMessage );

        XtSetSensitive( timeBox, FALSE_ );
	********END NOT IMPLEMENTED   */

	//  Motif action areas are never supposed to change size.
	//  We fix the size of the pane containing the buttons.

   	Dimension h; 
   	XtVaGetValues( dismissButton, XmNheight, &h, NULL );

   	XtVaSetValues( actionArea,
		       XmNpaneMaximum, h,
		       XmNpaneMinimum, h,
		       NULL );

	XtManageChild( dialogPane );
	XtManageChild( executeForm );

	/*******  BEGIN NOT IMPLEMENTED
	XtManageChild( updateForm );
	********END NOT IMPLEMENTED   */

	XtManageChild( actionArea );

   	XtAddCallback( stepText, XmNactivateCallback,
                      (XtCallbackProc)RunDialog::_staticStepTextCallback,
                      &cbinfo );

	/*******  BEGIN NOT IMPLEMENTED 
        XtAddCallback( eventFraction, XmNdragCallback,
                      (XtCallbackProc)RunDialog::_staticScaleCallback,
                      &cbinfo );
        XtAddCallback( eventFraction, XmNvalueChangedCallback,
                      (XtCallbackProc)RunDialog::_staticScaleCallback,
                      &cbinfo );
        XtAddCallback( timeFraction, XmNdragCallback,
                      (XtCallbackProc)RunDialog::_staticScaleCallback,
                      &cbinfo );
        XtAddCallback( eventFraction, XmNvalueChangedCallback,
                      (XtCallbackProc)RunDialog::_staticScaleCallback,
                      &cbinfo );
	*******END NOT IMPLEMENTED   */

	XtAddCallback( moduleButton, XmNvalueChangedCallback,
		       (XtCallbackProc)RunDialog::_staticExecuteCallback,
		       &cbinfoModule );

        XtAddCallback( graphButton, XmNvalueChangedCallback,
                       (XtCallbackProc)RunDialog::_staticExecuteCallback,
                       &cbinfoGraph );

        XtAddCallback( onceButton, XmNvalueChangedCallback,
                       (XtCallbackProc)RunDialog::_staticExecuteCallback,
                       &cbinfoOnce );

	/*******  BEGIN NOT IMPLEMENTED  
        XtAddCallback( eventsButton, XmNvalueChangedCallback,
                       (XtCallbackProc)RunDialog::_staticDisplayCallback,
                       &cbinfoEvents );

        XtAddCallback( timeButton, XmNvalueChangedCallback,
                       (XtCallbackProc)RunDialog::_staticDisplayCallback,
                       &cbinfoTime );
	********END NOT IMPLEMENTED   */

        XtAddCallback( dismissButton, XmNactivateCallback,
		      (XtCallbackProc)RunDialog::_staticDismissCallback,
		      (XtPointer) this );
        XtAddCallback( checkpointButton, XmNactivateCallback, 
		      (XtCallbackProc)RunDialog::_staticCheckpointCallback,
		      (XtPointer) this );
        XtAddCallback( snapshotButton, XmNactivateCallback,
		      (XtCallbackProc)RunDialog::_staticSnapshotCallback,
		      (XtPointer) this );
	XtAddCallback( runButton, XmNactivateCallback,
		      (XtCallbackProc)RunDialog::_staticRunCallback,
		      (XtPointer) this );
        XtAddCallback( stopButton, XmNactivateCallback,
		      (XtCallbackProc)RunDialog::_staticStopCallback,
		      (XtPointer) this );
        XtAddCallback( helpButton, XmNactivateCallback,
		      (XtCallbackProc)RunDialog::_staticHelpCallback,
		      (XtPointer) this );


        snapshotMode = SS_OFF;
}

RunDialog::~RunDialog()
{
	XtDestroyWidget( dialogPane );
	XtDestroyWidget( executeForm );

	/*******  BEGIN NOT IMPLEMENTED
	XtDestroyWidget( updateForm );
	********END NOT IMPLEMENTED   */

	XtDestroyWidget( actionArea );
	XtDestroyWidget( runDialog );

	pabloMainInterface = NULL;
}

void 
RunDialog::_dismissCallback()
{
        char *fetchText = XmTextGetString( stepText );
        int stepVal = atoi( fetchText );

        if ( stepVal != pabloData.runStepSize ) {
	   if ( stepVal >0 ) {
              pabloData.runStepSize = stepVal;
           } else {
	      error( "Invalid number of graph steps was entered. \n \
		      Resetting to previous value of %d.", 
		      pabloData.runStepSize );
	   }
	   updateDefaults();
	}

	XtUnmanageChild( runDialog );
	isManaged = FALSE_;
	pabloMainInterface->runPanelDismiss();
}

void
RunDialog::_checkpointCallback()
{
        pabloMainInterface->checkpoint();
}

void
RunDialog::_displayCallback( Widget , radio_cbInfo *cbi,
                            XmToggleButtonCallbackStruct *cbs )
{
        if ( cbs->set ) {
           switch ( cbi->button ) {
              case XmEVENTS:
                 XtSetSensitive( eventBox, TRUE_ );
                 XtSetSensitive( timeBox, FALSE_ );

                 displayEvents = TRUE_;
                 displayTime = FALSE_;
                 break;

              case XmTIME:
                 XtSetSensitive( eventBox, FALSE_ );
                 XtSetSensitive( timeBox, TRUE_ );

                 displayEvents = FALSE_;
                 displayTime = TRUE_;
                 break;

             default:
                 XtSetSensitive( eventBox, TRUE_ );
                 XtSetSensitive( timeBox, FALSE_ );

                 displayEvents = TRUE_;
                 displayTime = FALSE_;
                 break;
            }
        }
}

void
RunDialog::_executeCallback( Widget , radio_cbInfo *cbi,
                          XmToggleButtonCallbackStruct *cbs )
{
        if ( cbs->set ) {
           switch ( cbi->button ) {
              case XmRUN_GRAPH:
                 XtSetSensitive( stepBox, TRUE_ );

                 runGraph = TRUE_;
                 runModule = FALSE_;
                 runOnce = FALSE_;
                 break;

              case XmRUN_MODULE:
                 XtSetSensitive( stepBox, FALSE_ );

                 runGraph = FALSE_;
                 runModule = TRUE_;
                 runOnce = FALSE_;
                 break;

              case XmRUN_ONCE:
                 XtSetSensitive( stepBox, TRUE_ );

                 runGraph = FALSE_;
                 runModule = FALSE_;
                 runOnce = TRUE_;
                 break;

             default:
                 XtSetSensitive( stepBox, TRUE_ );

                 runGraph = TRUE_;
                 runModule = FALSE_;
                 runOnce = FALSE_;
                 break;
            }
        }
}

void 
RunDialog::_helpCallback( char* topic )
{
        Pablo::HelpSystem()->giveHelpOn(topic);
}

void 
RunDialog::_runCallback()
{
        char *fetchText = XmTextGetString( stepText );

        int stepVal = atoi( fetchText );

        if ( stepVal != pabloData.runStepSize ) {
	   if ( stepVal >0 ) {
              pabloData.runStepSize = stepVal;
           } else {
	      error( "Invalid number of graph steps was entered. \n \
		      Resetting to previous value prior to running.");
	   }
	   updateDefaults();
	}

        XtFree( fetchText);

        if ( runGraph == TRUE_ ) {
           XtSetSensitive( runButton, False );
           XtSetSensitive( dismissButton, False );

           pabloMainInterface->runRun();

           XtSetSensitive( runButton, True );
           XtSetSensitive( dismissButton, True );

        } else if ( runModule == TRUE_ ) {
           XtSetSensitive( radioBox, FALSE_ );
           XtSetSensitive( dismissButton, FALSE_ );
           XtSetSensitive( stopButton, FALSE_ );
           if ( pabloMainInterface->runModule() ) {  // True if graph done
               XtSetSensitive( radioBox, TRUE_ );
               XtSetSensitive( dismissButton, TRUE_ );
               XtSetSensitive( stopButton, TRUE_ );
	   }

        } else if ( runOnce == TRUE_ ) {
           pabloMainInterface->runGraphDiscrete( pabloData.runStepSize );
        }

}

void
RunDialog::_scaleCallback( Widget w, radio_cbInfo * ,
                          XmAnyCallbackStruct * )
{
        int     dataVal;

        XmScaleGetValue( w, &dataVal );

        if ( displayEvents == TRUE_ ) {
           pabloData.eventInterval = dataVal;
        } else if (displayTime == TRUE_ ) {
           pabloData.timeInterval = dataVal;
        }

}


void
RunDialog::_snapshotCallback()
{
	pabloMainInterface->runStop();
	snapshotDialog.realize();
}


void RunDialog::_staticCheckpointCallback( Widget ,
                                    XtPointer clientData,
                                    XtPointer )
{
        RunDialog *obj = (RunDialog *) clientData;

        obj->_checkpointCallback();
}


void
RunDialog::_staticSnapshotCallback( Widget ,
				    XtPointer clientData, XtPointer )
{
        RunDialog *obj = (RunDialog *) clientData;

        obj->_snapshotCallback();
}


void
RunDialog::_staticDismissCallback( Widget ,
                                       XtPointer clientData,
                                       XtPointer )
{
        RunDialog *obj = (RunDialog *) clientData;

        obj->_dismissCallback();
}

void
RunDialog::_staticDisplayCallback( Widget w,
                                     radio_cbInfo *cbi,
                                     XmToggleButtonCallbackStruct *cbs )
{
        cbi->dp->_displayCallback( w, cbi, cbs );
}

void
RunDialog::_staticExecuteCallback( Widget w,
                                     radio_cbInfo *cbi,
                                     XmToggleButtonCallbackStruct *cbs )
{
        cbi->dp->_executeCallback( w, cbi, cbs );
}

void RunDialog::_staticHelpCallback( Widget ,
                                    XtPointer clientData,
                                    XtPointer  )
{
        RunDialog *obj = (RunDialog *) clientData;

        obj->_helpCallback( "RunPanel" );
}

void RunDialog::_staticRunCallback( Widget ,
                                    XtPointer clientData,
                                    XtPointer  )
{
        RunDialog *obj = (RunDialog *) clientData;

        obj->_runCallback();
}

void
RunDialog::_staticScaleCallback( Widget w,
                                     radio_cbInfo *cbi,
                                     XmAnyCallbackStruct *cbs )
{
        cbi->dp->_scaleCallback( w, cbi, cbs );
}

void
RunDialog::_staticStepTextCallback( Widget w,
                                        radio_cbInfo *cbi,
                                        XmAnyCallbackStruct *cbs )
{
	cbi->dp->_stepTextCallback( w, cbi, cbs );
}

void RunDialog::_staticStopCallback( Widget ,
				    XtPointer clientData,
				    XtPointer )
{
	RunDialog *obj = (RunDialog *) clientData;
    
    	obj->_stopCallback();
}

void
RunDialog::_stepTextCallback( Widget w, radio_cbInfo *,
                             XmAnyCallbackStruct * )
{
	char*	fetchText;
	int	stepVal;

	fetchText = XmTextGetString( w );

	stepVal = atoi( fetchText );

	if (stepVal > 0) {
	   pabloData.runStepSize = stepVal;   
	} else {
	   error( "Invalid number of graph steps. Resetting to previous value");
	   char tmpBuf[50];
	   sprintf( tmpBuf, "%d", pabloData.runStepSize );
	   XmTextSetString( w, tmpBuf );
	}

	XtFree( fetchText);
}

void 
RunDialog::_stopCallback()
{
        pabloMainInterface->runStop();

        XtSetSensitive( radioBox, TRUE_ );
        XtSetSensitive( stepBox, TRUE_ );
}

Boolean_
RunDialog::isCameraOn()
{
        return( snapshotDialog.isCameraOn() );
}

void
RunDialog::raiseDialog()
{
	/* 
	 * We really never expect to get here if isManaged is TRUE because
	 * we can't select the Run menu if a RunPanel is active.  But...
	 * just in case that changes in the future, we add this check.
	 */
	if ( isManaged ) {
            XRaiseWindow( XtDisplay(runDialog), XtWindow(runDialog) );
	} else {
            XtManageChild( runDialog );
	    isManaged = TRUE_;
	}
}

void
RunDialog::takeSnapshot( Widget subjectWidget, const char *fuClass,
			 const char *fuName )
{
        snapshotDialog.takeSnapshot( subjectWidget, fuClass, fuName );
}


void
RunDialog::updateDefaults()
{
	char	tmpBuf[100];

	sprintf( tmpBuf, "%d", pabloData.runStepSize );

        XtVaSetValues( stepText, XmNvalue, tmpBuf, NULL );

	/*******  BEGIN NOT IMPLEMENTED 
	XtVaSetValues( eventFraction, XmNvalue, 1 ); // to prevent warnings
        XtVaSetValues( eventFraction, XmNmaximum, pabloData.maxTimeInterval );
        XtVaSetValues( eventFraction, XmNvalue, pabloData.eventInterval );

        XtVaSetValues( timeFraction, XmNvalue, 1 ); // to prevent warnings
        XtVaSetValues( timeFraction, XmNmaximum, pabloData.maxTimeInterval );
        XtVaSetValues( timeFraction, XmNvalue, pabloData.timeInterval );
	********END NOT IMPLEMENTED   */
}

/*
 * Initialize the static data
 */
const char *const RunDialog::MY_CLASS = "RunDialog";
PabloMainInterface *RunDialog::pabloMainInterface = NULL;
