/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth Aydt (aydt@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * GeneralDialogBox.C: Implements dialog boxes for Error, Information,
 *                     Question and Warning messages.
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Interface/RCS/GeneralDialogBox.C,v 1.21 1994/03/16 19:41:20 aydt Exp $
 *	
 */

#include <stdarg.h>
#include <stdio.h>
#include <Xm/Xm.h>
#include <Xm/MessageB.h>

#include "GeneralDialogBox.h"
#include "Pablo.h"
#include "WidgetBase.h"

GeneralDialogBox::GeneralDialogBox() 
{
	_setClassName( MY_CLASS );
	cbinfo.dp = this;

	XmString	dialogTitle;

	dialog = XmCreateMessageDialog( Pablo::TopLevel()->getWidget(),
			                "GeneralDialog", NULL, 0 );

	dialogTitle =  XmStringCreateLtoR( "Pablo General Dialog",
					    XmSTRING_DEFAULT_CHARSET );
			
	XtVaSetValues( dialog, 
		       XmNdialogTitle, (XtArgVal) dialogTitle, 
		       XmNdialogStyle, XmDIALOG_PRIMARY_APPLICATION_MODAL,
		       NULL );

        XtUnmanageChild( XmMessageBoxGetChild( dialog, 
					       XmDIALOG_HELP_BUTTON ));
        XtUnmanageChild( XmMessageBoxGetChild( dialog, 
					       XmDIALOG_CANCEL_BUTTON ));
	XmStringFree( dialogTitle );
}

GeneralDialogBox::~GeneralDialogBox()
{
	XtDestroyWidget( XtParent( dialog ) );
}

void
GeneralDialogBox::static_cb( Widget widget, cbInfo *cbi, 
			     XmAnyCallbackStruct *cbs )
{
	cbi->dp->callback( widget, cbi, cbs );
	//cout << "in static callback... just before return\n";
	return;
}

int
GeneralDialogBox::_run( DialogType myType, const char *msgBuf )
{
	int boxType;

	switch ( myType ) {
	    case ErrorDialog:
		boxType = XmDIALOG_ERROR;
		break;
	    case InformationDialog:
		boxType = XmDIALOG_INFORMATION;
		break;
	    case QuestionDialog:
		boxType = XmDIALOG_QUESTION;
		break;
	    case WarningDialog:
		boxType = XmDIALOG_WARNING;
		break;
	    case MessageDialog:
	    default:
		boxType = XmDIALOG_MESSAGE;
		break;
	}

   	XmString msg = XmStringCreateLtoR( (char *) msgBuf, 
					   XmSTRING_DEFAULT_CHARSET );
	XtVaSetValues( dialog, 
		       XmNmessageString, (XtArgVal) msg,
		       XmNdialogType, boxType,
		       NULL );
	XmStringFree( msg );

        XtAddCallback( dialog, XmNokCallback, 
			       (XtCallbackProc)GeneralDialogBox::static_cb, 
			       &cbinfo );

	if ( myType == QuestionDialog )  {
            XtManageChild( XmMessageBoxGetChild( dialog, 
			       XmDIALOG_CANCEL_BUTTON ));
            XtAddCallback( dialog, XmNcancelCallback, 
			       (XtCallbackProc)GeneralDialogBox::static_cb,
			       &cbinfo );
	}

        XtManageChild( dialog );

	cbinfo.button = 0;
        while ( cbinfo.button == 0 ) {
            XEvent event;
	    XtAppNextEvent( XtWidgetToApplicationContext( dialog ), &event );
            XtDispatchEvent( &event );
	}

	/*
	 * We don't have to unmanage dialog because the Motif Style Guide
	 * ways that when any button in the action area is pressed (except
	 * for the Help button), the dialog should be dismissed. The
	 * Motif toolkit, therefore, takes the specification at face value
	 * and enforces the default behavior. (pg 129 Heller Motif Manual)
	 */

	//cout << form(" after loop in instance %x\n", cbinfo.dp );

        XtRemoveCallback( dialog, XmNokCallback, 
				  (XtCallbackProc)GeneralDialogBox::static_cb, 
				  &cbinfo );
	if ( myType == QuestionDialog )  {
            XtRemoveCallback( dialog, XmNcancelCallback, 
			          (XtCallbackProc)GeneralDialogBox::static_cb,
				  &cbinfo );
            XtUnmanageChild( XmMessageBoxGetChild( dialog, 
			          XmDIALOG_CANCEL_BUTTON ));
	}

	return ( cbinfo.button );
}

void 
GeneralDialogBox::callback( Widget /* widget */, cbInfo *cbi, 
			    XmAnyCallbackStruct *cbs )
{
	//cout << form(" Callback in instance %x\n", cbi->dp );
	switch ( cbs->reason ) {
	  case XmCR_OK:
		cbi->button = 1;
		break;
	  case XmCR_CANCEL:
		cbi->button = 2;
		break;
	  default:
		cbi->button = 3;
		break;
	}
	return;
}

void
GeneralDialogBox::run( char *fmt, ... )
{
	char buf[16384];
	va_list arglist;
	
	va_start( arglist, fmt );
	vsprintf( buf, fmt, arglist );
	va_end( arglist );

	_run( MessageDialog, buf );
}

void
GeneralDialogBox::runError( char *fmt, ... )
{
	char buf[16384];
	va_list arglist;
	
	va_start( arglist, fmt );
	vsprintf( buf, fmt, arglist );
	va_end( arglist );

	_run( ErrorDialog, buf );
}

void
GeneralDialogBox::runInfo( char *fmt, ... )
{
	char buf[16384];
	va_list arglist;
	
	va_start( arglist, fmt );
	vsprintf( buf, fmt, arglist );
	va_end( arglist );

	_run( InformationDialog, buf );
}

Boolean_
GeneralDialogBox::runQuestion( char *fmt, ... )
{
	char buf[16384];
	va_list arglist;
	
	va_start( arglist, fmt );
	vsprintf( buf, fmt, arglist );
	va_end( arglist );

	if ( _run( QuestionDialog, buf )  == 1 ) {
	   return TRUE_;
	} else {
	   return FALSE_;
	}
}

void
GeneralDialogBox::runWarning( char *fmt, ... )
{
	char buf[16384];
	va_list arglist;
	
	va_start( arglist, fmt );
	vsprintf( buf, fmt, arglist );
	va_end( arglist );

	_run( WarningDialog, buf );
}

/*
 * Initialize the static data
 */
const char *const GeneralDialogBox::MY_CLASS = "GeneralDialogBox";
