/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Robert Olson (olson@cs.uiuc.edu)
 * Contributing Author: Daniel A. Reed (reed@cs.uiuc.edu)
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 */
/*
 * TranscriptWindow.h:  Implements a simple popup window containing
 *			a transcript of Pablo information, warning
 *			and error messages
 *
 * $Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/TranscriptWindow.h,v 1.10 1994/02/25 04:29:25 aydt Exp $	
 */

#ifndef TranscriptWindow_h
#define TranscriptWindow_h

typedef enum { TW_Error, TW_Normal } TextType;

#include <X11/Intrinsic.h>
#include <X11/Shell.h>

#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/PanedW.h>
#include <Xm/PushB.h>
#include <Xm/ScrolledW.h>
#include <Xm/Text.h>

#include "Pablo.h"
#include "Obj.h"

class TranscriptWindow : public Obj {
/*
 * 	A TranscriptWindow displays the information and error messages
 *	produced during Pablo's execution
 */

private:
	static const char *const MY_CLASS;

protected:

	Widget	transcriptDialog;
	Widget	dialogPane;
	Widget	controlArea;
     	Widget	actionArea;

        Widget	dismissButton;
   	Widget	helpButton;

	Widget	infoText;
 	Widget	infoLabel;
	Widget	errorText;
        Widget	errorLabel;

	static TranscriptWindow *singleInstance;

	enum twPartDesig { Ptext, PerrorText } ;

	/* Method _helpCallback:	help callback for transcript	*/
        void _helpCallback( char *topic );

	/* Method _staticDismissCallback: static callback to close the
	*				transcript window		*/
        static void _staticDismissCallback( Widget w,
                                    XtPointer clientData,
                                    XtPointer callData );

	/* Method _staticHelpCallback:	static callback to provide 
	*				interactive help		*/
	static void _staticHelpCallback( Widget w,
                                    XtPointer clientData,
                                    XtPointer callData );

public:
	/* Method TranscriptWindow:	The constructor			*/
	TranscriptWindow();

	/* Method ~TranscriptWindow:	The destructor			*/
	~TranscriptWindow();

        /* Method closeWindow:          closes the transcript dialog    */
        void closeWindow();

        /* Method openWindow:           pops up the transcript dialog   */   
        void openWindow();

	/* Method writeText:		writes text to the stdout or
	*				stderr windows			*/
	void writeText( const char *text, TextType type = TW_Normal );

	/* Method printOn:		stream output function		*/
	void printOn( ostream &os = cout ) const ;
};

inline ostream &operator<<( ostream &os, TranscriptWindow &obj )
{
	obj.printOn(os);
	return os;
}

#endif
