/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * SynthesizeCoordinates.h: A functional unit to populate a two-dimensional
 *	array with coordinate values of the form (a, b, ..., z)
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/SynthesizeCoordinates.h,v 1.7 1994/03/15 16:26:21 aydt Exp $
 */

#ifndef SynthesizeCoordinates_h
#define SynthesizeCoordinates_h

#include "CStringObjList.h"
#include "FunctionalUnit.h"
#include "Value.h"

class InputPort;
class OutputPort;

static const int MAXCOORDAXES = 10;  		// max number of ports

class SynthesizeCoordinates : public FunctionalUnit {
/*
* SynthesizeCoordinates is a functional unit that populates a two-dimensional
* array.  The maximum number of cells (size of the array's dimension 0) is
* set by the user in the configuration process.  Once that many cells have
* been seen, the "current cell" wraps around and begins again populating cells
* at the beginning of the array.  One size option is "infinity," which
* prevents overwrites.
*/

private:
	enum coordHistoryTypes { INFINITE, FINITE };

	static const char *const MY_CLASS;	// My class name
	static CStringObjList	 HistoryOption;

	InputPort       *coordValue[MAXCOORDAXES];
	OutputPort	*array;

	Boolean_	isConfigured;

	int		numCells;		// number of cells in array
	int     	maxCells;          	// max # of cells to keep
	int		arrayIndex;		// next index in array to write
	int		histOption;		// infinite or finite?
	int		indexCount;		// number of ports

	Value 		outputValue;

	/* Method _increaseSize:	 Increase the size of the array by 1
	*				 and preserve all cell values.       */
	void _increaseSize();

	/* Method _reduceArraySize:	 Reduce size of array to maxCells.
	*				 Preserve latest maxCells entries. */
	void _reduceArraySize();

	/* Method _shuffleEntries:	 Rearrange the entries in the array
	*				 so that the oldest is in the first
	*				 position.			     */
	void _shuffleEntries();

	/* Method _setPorts:		 Initialize the functional unit
	*				 ports				     */ 
	void _setPorts( int portCount );

public:
	/* Method SynthesizeCoordinates:  The constructor   		     */
	SynthesizeCoordinates();

	/* Method ~SynthesizeCoordinates: The destructor    		     */
	~SynthesizeCoordinates();

        /* Method configure:    	 Configure the functional unit 	     */
        virtual void configure();

	/* Method configureOperation:	 Configure and display the number of
	*				 ports for this functional unit      */
	virtual void configureOperation();

	/* Method copy:			 Copy this functional unit	     */
	FunctionalUnit * copy();

	/* Method init:			 Initialize the functional unit	     */
	virtual void init();

	/* Method inputTraitsValid:      Sets traits of output port. Here
	*				 input bindings are always valid 
	*				 so we always return TRUE_.	     */
	virtual Boolean_ inputTraitsValid();

        /* Method loadConfigFromFile:    Load configuration from a file      */
        virtual Boolean_ loadConfigFromFile( const CString& fileName );

	/* Method ready: 		 Returns TRUE_ if the functional unit
	*				 is currently executable	     */
	virtual Boolean_ ready();

	/* Method run:			 Execute the functional unit to fill 
	*				 in a cell in the array.	     */
	virtual void run( Boolean_& errorFlag );

        /* Method saveConfigToFile:       Save configuration to a file        */
        virtual Boolean_ saveConfigToFile( const CString& fileName ) const;
};

#endif SynthesizeCoordinates_h
