/*
 * This file is part of the Pablo Performance Analysis Environment
 *
 *                                           TM
 * The Pablo Performance Analysis Environment   software is *not* in
 * the public domain.  However, it is freely available without fee for
 * education, research, and non-profit purposes.  By obtaining copies
 * of this and other files that comprise the Pablo Performance Analysis
 * Environment, you, the Licensee, agree to abide by the following
 * conditions and understandings with respect to the copyrighted software:
 * 
 * 1.  The software is copyrighted in the name of the Board of Trustees
 *     of the University of Illinois (UI), and ownership of the software
 *     remains with the UI. 
 *
 * 2.  Permission to use, copy, and modify this software and its documentation
 *     for education, research, and non-profit purposes is hereby granted
 *     to Licensee, provided that the copyright notice, the original author's
 *     names and unit identification, and this permission notice appear on
 *     all such copies, and that no charge be made for such copies.  Any
 *     entity desiring permission to incorporate this software into commercial
 *     products should contact:
 *
 *          Professor Daniel A. Reed                 reed@cs.uiuc.edu
 *          University of Illinois
 *          Department of Computer Science
 *          2413 Digital Computer Laboratory
 *          1304 West Springfield Avenue
 *          Urbana, Illinois  61801
 *          USA
 *
 * 3.  Licensee may not use the name, logo, or any other symbol of the UI
 *     nor the names of any of its employees nor any adaptation thereof in
 *     advertizing or publicity pertaining to the software without specific
 *     prior written approval of the UI.
 *
 * 4.  THE UI MAKES NO REPRESENTATIONS ABOUT THE SUITABILITY OF THE
 *     SOFTWARE FOR ANY PURPOSE.  IT IS PROVIDED "AS IS" WITHOUT EXPRESS
 *     OR IMPLIED WARRANTY.
 *
 * 5.  The UI shall not be liable for any damages suffered by Licensee from
 *     the use of this software.
 *
 * 6.  The software was developed under agreements between the UI and the
 *     Federal Government which entitle the Government to certain rights.
 *
 **************************************************************************
 *
 * Developed by: The TAPESTRY Parallel Computing Laboratory
 *		 University of Illinois at Urbana-Champaign
 *		 Department of Computer Science
 *		 1304 W. Springfield Avenue
 *		 Urbana, IL	61801
 *
 * Copyright (c) 1987-1994
 * The University of Illinois Board of Trustees.
 *	All Rights Reserved.
 *
 * Author: Ruth A. Aydt (aydt.cs.uiuc.edu)
 *
 * Project Manager and Principal Investigator:
 *	Daniel A. Reed (reed@cs.uiuc.edu)
 *
 * Funded by: National Science Foundation grants NSF CCR86-57696,
 * NSF CCR87-06653 and NSF CDA87-22836 (Tapestry), NASA ICLASS Contract
 * No. NAG-1-613, DARPA Contract No. DABT63-91-K-0004, by a grant
 * from the Digital Equipment Corporation External Research Program,
 * and by a collaborative research agreement with the Intel Supercomputer
 * Systems Division.
 *
 */
/*
 * StructureDictionary.h: Class used to keep track of the structures the
 *			  system is aware of.  There is only one instance
 *			  of this class in the system and once entries are made
 *			  to the dictionary they cannot be changed or removed.
 *
 *	$Header: /mnt/Pablo-guitar/Stable.2-94/Visual/Src/System/Includes/RCS/StructureDictionary.h,v 1.15 1994/02/25 04:30:18 aydt Exp $
 */

#ifndef StructureDictionary_h
#define StructureDictionary_h

#include "Defines.h"
#include "Obj.h"
#include "StructureDescriptor.h"

class StructureDictionary : public Obj {
/*
*
* There is a single instance of the StructureDictionary class in the system.
* It is used to maintain a list of the StructureDescriptors encountered by the
* system.
*
*/
	friend class StructureDictionaryIterator;
	friend class StructureDictionaryInquirer;

	class StructureDictEntry {
	    friend class StructureDictionary;
	    friend class StructureDictionaryInquirer;
	    friend class StructureDictionaryIterator;

	private:
	    int			     systemTag;
	    StructureDescriptor	     structure;
	    StructureDictEntry	     *nextEntry;

	    StructureDictEntry() { nextEntry = NULL; }
	} ;

private:
	static const char *const     MY_CLASS;  	// My class name
	static StructureDescriptor   noStructure;
	static int    		     uniqueSystemTag;  // ? should this be here

	StructureDictEntry	     *headEntry;
	StructureDictEntry	     *tailEntry;

public:
	/* Method StructureDictionary:	A StructureDictionary constructor with
	*				no initialization		      */
	StructureDictionary();

	/* Method ~StructureDictionary:	The StructureDictionary destructor    */
	 ~StructureDictionary();

	/* Method contains:		Structure membership test based on
	*				on match with systemTag	              */
	Boolean_ contains( const int tag ) const;

	/* Method fetch:		Lookup the named tag and return the
	*				StructureDescriptor with that systemTag
	*				or NOMATCH StructureDescriptor if no 
	*				match was found.		      */
	const StructureDescriptor& fetch( const int tag ) const;

	/* Method insert:		Insert a StructureDescriptor into the
	 *				StructureDictionary. Returns the
	 *				assigned systemTag.		      */
	int insert( const StructureDescriptor& structDescr );

	/* Method loadFromFile:		Loads the StructureDictionary from 
	*				the specified file.  If duplicate tags
	*				are seen, those entries are not
	*				inserted.  uniqueSystemTag is updated
	*				to reflect the newly inserted entries */
	Boolean_ loadFromFile( const CString& filename );

	/* Method reset:		Clear all entries currently in the 
	*				dictionary. Set uniqueSystemTag to 1. */
	void reset();

	/* Method saveToFile:		Dumps contents of StructureDictionary
	 *				to specified file.  Returns Success_ 
	 *				or Failure_			      */
	Boolean_ saveToFile( const CString& filename ) const;

	/* Method printOn: 		Helper function for StructureDictionary
	*				output. 			      */
	virtual void printOn( ostream& strm = cout ) const;
};

inline ostream& operator<<( ostream& os, StructureDictionary& structDict )
{
	structDict.printOn (os);

	return os;
}

#endif StructureDictionary_h
